/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.structure;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.internal.structure.StructureProcessor;
import org.gridgain.internal.structure.map.IgniteMapImpl;
import org.gridgain.internal.structure.map.MapStructureDescriptor;
import org.gridgain.structure.IgniteMap;
import org.gridgain.structure.IgniteStructures;
import org.gridgain.structure.MapConfiguration;
import org.gridgain.structure.StructureUtils;

public class GridgainStructuresComponent
implements IgniteStructures,
IgniteComponent {
    private final IgniteSql sql;
    private final StructureProcessor processor;

    public GridgainStructuresComponent(CatalogManager catalogManager, IgniteTablesInternal tables, IgniteSql sql, SchemaManager manager, String nodeName) {
        this.processor = new StructureProcessor(catalogManager, tables, nodeName);
        this.sql = sql;
    }

    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(MapConfiguration configuration) {
        return this.doGetOrCreateMapAsync(configuration);
    }

    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(String name, Marshaller<K, byte[]> km, Marshaller<V, byte[]> vm) {
        return this.getOrCreateMapAsync(MapConfiguration.builder((String)name, km, vm).build());
    }

    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.getOrCreateMapAsync(MapConfiguration.builder((String)name, keyClass, valueClass).build());
    }

    public <K, V> IgniteMap<K, V> getOrCreateMap(MapConfiguration configuration) {
        return GridgainStructuresComponent.sync(this.getOrCreateMapAsync(configuration));
    }

    public <K, V> IgniteMap<K, V> getOrCreateMap(String name, Marshaller<K, byte[]> keyMarshaller, Marshaller<V, byte[]> valueMarshaller) {
        return GridgainStructuresComponent.sync(this.getOrCreateMapAsync(name, keyMarshaller, valueMarshaller));
    }

    public <K, V> IgniteMap<K, V> getOrCreateMap(String name, Class<K> keyClass, Class<V> valueClass) {
        return GridgainStructuresComponent.sync(this.getOrCreateMapAsync(name, keyClass, valueClass));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return null;
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return null;
    }

    private static <R> R sync(CompletableFuture<R> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)IgniteExceptionMapperUtil.mapToPublicException((Throwable)ExceptionUtils.unwrapCause((Throwable)e)));
        }
    }

    private <K, V> CompletableFuture<IgniteMap<K, V>> doGetOrCreateMapAsync(MapConfiguration conf) {
        MapStructureDescriptor descriptor = MapStructureDescriptor.of((MapConfiguration)conf);
        QualifiedName tableName = QualifiedName.of((String)"SYSTEM", (String)IgniteNameUtils.quoteIfNeeded((String)conf.getName().objectName()));
        return this.processor.process(descriptor).thenApply(view -> new IgniteMapImpl(tableName.toCanonicalForm(), view, this.sql, StructureUtils.cast((Marshaller)conf.getKeyMarshaller()), StructureUtils.cast((Marshaller)conf.getValueMarshaller())));
    }
}

