/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.structure;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.commands.CreateMapCommand;
import org.apache.ignite.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.KeyValueView;
import org.gridgain.internal.structure.descriptor.StructureDescriptor;
import org.gridgain.internal.structure.map.MapStructureDescriptor;

public class StructureProcessor {
    private static final IgniteLogger LOG = Loggers.forClass(StructureProcessor.class);
    private final CatalogManager catalogManager;
    private final IgniteTablesInternal tables;
    private final Executor executor;

    public StructureProcessor(CatalogManager catalogManager, IgniteTablesInternal tables, String nodeName) {
        this.catalogManager = catalogManager;
        this.tables = tables;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"structure-processor", (boolean)false, (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    public <K, V> CompletableFuture<KeyValueView<K, V>> process(StructureDescriptor<K, V> descriptor) {
        return this.getTable(descriptor).thenCompose(table -> {
            if (table != null) {
                return CompletableFuture.completedFuture(table);
            }
            return this.catalogManager.execute(StructureProcessor.createTable(descriptor)).thenComposeAsync(ignored -> this.getTable(descriptor), this.executor);
        });
    }

    private <K, V> CompletableFuture<KeyValueView<K, V>> getTable(StructureDescriptor<K, V> descriptor) {
        CatalogMapDescriptor mapDescriptor = this.catalogManager.catalog(this.catalogManager.latestCatalogVersion()).map(descriptor.name().schemaName(), descriptor.name().objectName());
        if (mapDescriptor == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            return this.tables.tableAsync(mapDescriptor.tableId()).thenApply(table -> {
                if (table == null) {
                    return null;
                }
                return table.keyValueView(descriptor.keyClass(), descriptor.valueClass());
            });
        }
        catch (NodeStoppingException e) {
            throw new IgniteException(e.traceId(), e.code(), e.getMessage(), (Throwable)e);
        }
    }

    private static <K, V> CatalogCommand createTable(StructureDescriptor<K, V> descriptor) {
        return CreateMapCommand.builder().schemaName(descriptor.name().schemaName()).mapName(descriptor.name().objectName()).keyType(((MapStructureDescriptor)descriptor).keyColumn().columnType()).valueType(((MapStructureDescriptor)descriptor).valueColumn().columnType()).zone(descriptor.distributionZone()).storageProfile(descriptor.storageProfile()).build();
    }
}

