/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.cache;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrottlingGenerationService
implements Service {
    public static final long TASKS_GENERATION_PERIOD = 10000L;
    public static final int TASKS_AMOUNT_PER_PERIOD = 8;
    public static final int TASKS_PEAK_AMOUNT = 16;
    public static final long SERVICE_MAX_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private static long endTime;
    private ScheduledThreadPoolExecutor threadExec;
    private ThreadPoolExecutor taskExec;
    @IgniteInstanceResource
    private Ignite ignite;
    @LoggerResource
    private IgniteLogger log;

    public void init(ServiceContext ctx) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("Service was initialized: " + ctx.name());
        }
        this.threadExec = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
        this.taskExec = (ThreadPoolExecutor)Executors.newCachedThreadPool();
    }

    public void cancel(ServiceContext ctx) {
        U.shutdownNow(TrottlingGenerationService.class, (ExecutorService)this.threadExec, null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Service was cancelled: " + ctx.name());
        }
    }

    public void execute(ServiceContext ctx) throws Exception {
        this.log.info("Executing trottling load service: " + ctx.name());
        endTime = System.currentTimeMillis() + SERVICE_MAX_TIMEOUT;
        this.threadExec.scheduleAtFixedRate(() -> this.startTasksIfNeeded(this.ignite), 0L, 10000L, TimeUnit.MILLISECONDS);
    }

    private void startTasksIfNeeded(Ignite ignite) {
        int activeJobsCnt;
        if (System.currentTimeMillis() > endTime) {
            this.threadExec.shutdown();
        }
        if ((activeJobsCnt = this.taskExec.getActiveCount()) < 16) {
            for (int i = 0; i < Integer.min(16 - activeJobsCnt, 8); ++i) {
                this.taskExec.submit(new CachePutRunnable("test-trl-" + UUID.randomUUID().toString(), ignite));
            }
        }
    }

    public static class CachePutRunnable
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(CachePutRunnable.class);
        private static final String DATA_REGION = "default";
        private static final int N = 10000;
        private final Random rnd = new Random();
        private final String cacheName;
        private final int keySize;
        private final int valSize;
        private final Ignite ignite;

        public CachePutRunnable(String cacheName, int keySize, int valSize, Ignite ignite) {
            this.cacheName = cacheName;
            this.keySize = keySize;
            this.valSize = valSize;
            this.ignite = ignite;
        }

        public CachePutRunnable(String cacheName, Ignite ignite) {
            this(cacheName, 32, 32768, ignite);
        }

        @Override
        public void run() {
            CacheConfiguration cfg = new CacheConfiguration().setName(this.cacheName).setDataRegionName(DATA_REGION);
            IgniteCache cache = this.ignite.getOrCreateCache(cfg);
            log.info("{} cache has been created", (Object)this.cacheName);
            int i = 0;
            while (i < 10000) {
                String key = UUID.randomUUID().toString();
                if (!this.ignite.affinity(this.cacheName).isPrimary(this.ignite.cluster().localNode(), (Object)key)) continue;
                cache.put((Object)this.nextKey(), (Object)this.nextValue());
                if (++i % 1000 != 0) continue;
                log.info("{} elements were added in {}", (Object)i, (Object)this.cacheName);
            }
            log.info("Data loading in {} was comleted", (Object)this.cacheName);
            this.ignite.destroyCache(this.cacheName);
            log.info("{} cache has been destroyed", (Object)this.cacheName);
        }

        public byte[] nextKey() {
            byte[] bytes = new byte[this.keySize];
            this.rnd.nextBytes(bytes);
            return bytes;
        }

        public byte[] nextValue() {
            byte[] bytes = new byte[this.valSize];
            this.rnd.nextBytes(bytes);
            return bytes;
        }
    }
}

