/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;
import org.apache.ignite.transactions.Transaction;

public class CacheRWService
implements Service {
    private long cacheGenerationPeriod = 10L;
    private int rwCachesNumber = 30;
    private int entryRange = 100;
    private boolean withTransaction = true;
    private boolean withDefaultCacheConfig = true;
    private final List<IgniteCache<Integer, Integer>> caches = new ArrayList<IgniteCache<Integer, Integer>>();
    private ScheduledExecutorService threadExec;
    IgniteTransactions transactions;
    @IgniteInstanceResource
    private transient IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;

    public CacheRWService(Map<String, Object> arg) {
        if (F.isEmpty(arg)) {
            return;
        }
        this.cacheGenerationPeriod = (Long)arg.getOrDefault("CACHES_GENERATION_PERIOD", this.cacheGenerationPeriod);
        this.rwCachesNumber = (Integer)arg.getOrDefault("CACHES_RW_CACHES_NUMBER", this.rwCachesNumber);
        this.entryRange = (Integer)arg.getOrDefault("CACHES_ENTRY_RANGE", this.entryRange);
        this.withTransaction = (Boolean)arg.getOrDefault("CACHES_WITH_TRANSACTION", this.withTransaction);
        this.withDefaultCacheConfig = (Boolean)arg.getOrDefault("CACHES_WITH_DEFAULT_CACHE_CONFIG", this.withDefaultCacheConfig);
    }

    public void cancel(ServiceContext ctx) {
        U.shutdownNow(CacheRWService.class, (ExecutorService)this.threadExec, null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Service was cancelled: " + ctx.name());
        }
    }

    public void init(ServiceContext ctx) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Service was initialized: " + ctx.name());
        }
        this.transactions = this.ignite.transactions();
        for (int i = 0; i < this.rwCachesNumber; ++i) {
            if (this.withDefaultCacheConfig) {
                this.caches.add((IgniteCache<Integer, Integer>)this.ignite.getOrCreateCache(this.getCacheDefaultConfiguration(i)));
                continue;
            }
            this.caches.add((IgniteCache<Integer, Integer>)this.ignite.getOrCreateCache("rw_cache_" + i));
        }
        this.threadExec = Executors.newScheduledThreadPool(10);
    }

    private CacheConfiguration<Integer, Integer> getCacheDefaultConfiguration(int idx) {
        return new CacheConfiguration("rw_cache_" + idx).setAtomicityMode(this.withTransaction ? CacheAtomicityMode.TRANSACTIONAL : CacheAtomicityMode.ATOMIC).setStatisticsEnabled(true);
    }

    public void execute(ServiceContext ctx) {
        this.log.info("Executing cache load service: " + ctx.name());
        this.threadExec.scheduleAtFixedRate(this::loading, 0L, this.cacheGenerationPeriod, TimeUnit.MILLISECONDS);
    }

    private void loading() {
        try {
            int cacheIdx = this.random(this.caches.size() - 1);
            IgniteCache<Integer, Integer> cache = this.caches.get(cacheIdx);
            boolean transactional = this.random(5) == 0;
            boolean rollback = this.random(3) == 0;
            int operationId = this.random(10);
            switch (operationId) {
                case 0: {
                    this.doTransactionalIfNeeded(cache.getName(), () -> {
                        int key = this.random(this.entryRange);
                        int val = this.random(this.entryRange);
                        cache.put((Object)key, (Object)val);
                    }, transactional, rollback);
                    break;
                }
                case 1: {
                    int key = this.random(this.entryRange);
                    cache.get((Object)key);
                    break;
                }
                case 2: {
                    this.doTransactionalIfNeeded(cache.getName(), () -> {
                        int key = this.random(this.entryRange);
                        cache.remove((Object)key);
                    }, transactional, rollback);
                    break;
                }
                case 3: {
                    this.doTransactionalIfNeeded(cache.getName(), () -> {
                        int key = this.random(this.entryRange);
                        int val = this.random(this.entryRange);
                        cache.replace((Object)key, (Object)val);
                    }, transactional, rollback);
                    break;
                }
                case 4: {
                    if (this.random(10) != 0) break;
                    cache.clear();
                }
            }
        }
        catch (Exception e) {
            this.log.error("Cache rw service error.", (Throwable)e);
        }
    }

    private void doTransactionalIfNeeded(String cacheName, Runnable r, boolean transactional, boolean rollback) {
        if (this.withTransaction && transactional) {
            try (Transaction tx = this.transactions.txStart();){
                IgniteCache cache = this.ignite.cache(cacheName);
                cache.put((Object)1, (Object)1);
                r.run();
                if (rollback) {
                    tx.rollback();
                }
                tx.commit();
            }
        } else {
            r.run();
        }
    }

    private int random(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }
}

