/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.util.stream.IntStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.control.agent.StartLoadTask;

public class Tester {
    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].isEmpty()) {
            throw new IllegalArgumentException("Empty argument.");
        }
        String addrs = null;
        String username = null;
        String password = null;
        String cfg = "ignite-cfg.xml";
        int nodesCnt = -1;
        for (int i = 0; i < args.length; i += 2) {
            String key = args[i].toLowerCase();
            String val = args[i + 1];
            if ("--cfg".equals(key)) {
                cfg = val;
            }
            if ("--nodes".equals(key)) {
                nodesCnt = Integer.parseInt(val, 10);
                continue;
            }
            if ("--address".equals(key)) {
                addrs = val;
                continue;
            }
            if ("--username".equals(key)) {
                username = val;
                continue;
            }
            if ("--password".equals(key)) {
                password = val;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument [argument=" + key + ", allowed=[--cfg, --nodes, --address, --username, --password]]");
        }
        if (nodesCnt <= 0 && F.isEmpty(addrs)) {
            throw new IllegalArgumentException("One of the arguments --nodes or --addrs must be specified.");
        }
        if (nodesCnt > 0) {
            if (U.resolveIgniteUrl((String)cfg, (boolean)false) == null) {
                throw new IllegalArgumentException("Failed to resolve configuration file path: " + cfg);
            }
            IgniteEx ignite = Tester.startCluster(cfg, nodesCnt);
            ClientConnectorConfiguration cliConnCfg = ignite.configuration().getClientConnectorConfiguration();
            String host = Tester.coalesce(cliConnCfg.getHost(), ignite.configuration().getLocalHost(), "localhost");
            int port = cliConnCfg.getPort();
            addrs = String.format("%s:%d", host, port);
        }
        Tester.startLoad(addrs, username, password);
    }

    public static void startLoad(String addrs, String username, String password) throws InterruptedException {
        ClientConfiguration cfg = new ClientConfiguration().setAddresses(new String[]{addrs});
        if (!F.isEmpty((String)username)) {
            cfg.setUserName(username).setUserPassword(password).setSslMode(SslMode.REQUIRED);
        }
        try (IgniteClient client = Ignition.startClient((ClientConfiguration)cfg);){
            client.compute().execute(StartLoadTask.class.getName(), null);
            System.out.println(">>> Load successfully started");
        }
        catch (Exception e) {
            System.out.println(">>> Failed to start load");
            e.printStackTrace();
        }
    }

    private static IgniteEx startCluster(String cfg, int nodesCnt) {
        if (nodesCnt >= 100) {
            throw new IllegalArgumentException("Too many nodes");
        }
        return (IgniteEx)IntStream.range(0, nodesCnt).parallel().mapToObj(i -> {
            try {
                return IgnitionEx.start((String)cfg, (String)("grid-" + i));
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }).findFirst().orElseThrow(() -> new IgniteException("Startup of cluster nodes failed"));
    }

    private static <T> T coalesce(T ... items) {
        for (T i : items) {
            if (i == null) continue;
            return i;
        }
        return null;
    }
}

