/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.util.HashMap;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.control.agent.StartLoadTask;

public class TesterForDataReplication {
    public static void main(String[] args) {
        String snd = "ignite-cfg-sender.xml";
        String receiver = "ignite-cfg-receiver.xml";
        if (U.resolveIgniteUrl((String)snd, (boolean)false) == null) {
            throw new IllegalArgumentException("Failed to resolve configuration for sender file path: " + snd);
        }
        if (U.resolveIgniteUrl((String)receiver, (boolean)false) == null) {
            throw new IllegalArgumentException("Failed to resolve configuration for receiver file path: " + receiver);
        }
        IgniteEx senderIgnite = TesterForDataReplication.startCluster(snd);
        senderIgnite.log().info(">>> Sender cluster started [clusterId={}]", senderIgnite.cluster().id().toString());
        IgniteEx receiverIgnite = TesterForDataReplication.startCluster(receiver);
        receiverIgnite.cluster().state(ClusterState.ACTIVE);
        receiverIgnite.log().info(">>> Receiver cluster started [clusterId={}]", receiverIgnite.cluster().id().toString());
        ClusterNode senderNode = senderIgnite.cluster().localNode();
        String host = (String)F.first((Iterable)senderNode.addresses());
        int port = (Integer)senderNode.attribute("clientListenerPort");
        String addrs = host + ":" + port;
        TesterForDataReplication.startLoad(addrs);
    }

    public static void startLoad(String addrs) {
        ClientConfiguration cfg = new ClientConfiguration().setAddresses(new String[]{addrs});
        try (IgniteClient client = Ignition.startClient((ClientConfiguration)cfg);){
            HashMap<String, Boolean> arg = new HashMap<String, Boolean>();
            arg.put("CACHES_WITH_DEFAULT_CACHE_CONFIG", false);
            client.compute().execute(StartLoadTask.class.getName(), arg);
            System.out.println(">>> Load on sender successfully started");
        }
        catch (Exception e) {
            System.out.println(">>> Failed to start load");
            e.printStackTrace();
        }
    }

    private static IgniteEx startCluster(String cfg) {
        try {
            return (IgniteEx)IgnitionEx.start((String)cfg, (String)("grid-" + UUID.randomUUID()));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }
}

