/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.query;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;
import org.gridgain.control.agent.query.LoadStatus;
import org.gridgain.control.agent.query.LoadStatusKey;
import org.gridgain.control.agent.query.Region;
import org.gridgain.control.agent.query.TargetCacheStatusEntry;

public class QueryGenerationService
implements Service {
    private long queriesGenerationPeriod = 100L;
    private int queriesAmountPerPeriod = 100;
    private int queriesPeakAmount = 10000;
    private long queriesMaxTimeout = TimeUnit.SECONDS.toMillis(2L);
    private long serviceMaxTimeout = TimeUnit.MINUTES.toMillis(60L);
    private int tableSize = 1000;
    protected static final String CACHE_WITH_LOAD = "TestCache";
    protected static final String CACHE_WITH_COMPLEX_OBJECT = "ComplexObjectCache";
    private static final ThreadLocalRandom RND = ThreadLocalRandom.current();
    private static long endTime;
    private ScheduledExecutorService threadExec;
    private ScheduledExecutorService cancelQueryExec;
    private static final List<QueryTemplate> queries;
    @IgniteInstanceResource
    private transient IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;

    public QueryGenerationService(Map<String, Object> arg) {
        if (F.isEmpty(arg)) {
            return;
        }
        this.queriesGenerationPeriod = (Long)arg.getOrDefault("QUERIES_GENERATION_PERIOD", this.queriesGenerationPeriod);
        this.queriesAmountPerPeriod = (Integer)arg.getOrDefault("QUERIES_AMOUNT_PER_PERIOD", this.queriesAmountPerPeriod);
        this.queriesPeakAmount = (Integer)arg.getOrDefault("QUERIES_PEAK_AMOUNT", this.queriesPeakAmount);
        this.queriesMaxTimeout = (Long)arg.getOrDefault("QUERIES_MAX_TIMEOUT", this.queriesMaxTimeout);
        this.serviceMaxTimeout = (Long)arg.getOrDefault("QUERIES_SERVICE_MAX_TIMEOUT", this.serviceMaxTimeout);
        this.tableSize = (Integer)arg.getOrDefault("QUERIES_TABLE_SIZE", this.tableSize);
    }

    public void init(ServiceContext ctx) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Service was initialized: " + ctx.name());
        }
        this.threadExec = Executors.newScheduledThreadPool(10);
        this.cancelQueryExec = Executors.newScheduledThreadPool(2);
        this.prepareCacheWithQueryLoad(this.ignite);
        this.prepareCacheWithComplexQuery(this.ignite);
    }

    public void cancel(ServiceContext ctx) {
        U.shutdownNow(QueryGenerationService.class, (ExecutorService)this.threadExec, null);
        U.shutdownNow(QueryGenerationService.class, (ExecutorService)this.cancelQueryExec, null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Service was cancelled: " + ctx.name());
        }
    }

    public void execute(ServiceContext ctx) {
        this.log.info("Executing sql load service: " + ctx.name());
        endTime = System.currentTimeMillis() + this.serviceMaxTimeout;
        this.threadExec.scheduleAtFixedRate(() -> this.startQueriesIfNeeded(this.ignite), 0L, this.queriesGenerationPeriod, TimeUnit.MILLISECONDS);
    }

    private void startQueriesIfNeeded(IgniteEx ignite) {
        int runningQueriesCnt;
        if (System.currentTimeMillis() > endTime) {
            this.threadExec.shutdown();
        }
        if ((runningQueriesCnt = ignite.context().query().runningQueries(0L).size()) < this.queriesPeakAmount) {
            for (int i = 0; i < Math.min(this.queriesPeakAmount - runningQueriesCnt, this.queriesAmountPerPeriod); ++i) {
                try {
                    this.startQuery(ignite, queries.get(i % queries.size()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void startQuery(IgniteEx ignite, QueryTemplate template) {
        long timeout = RND.nextLong(this.queriesMaxTimeout);
        GridQueryProcessor qryProc = ignite.context().query();
        QueryCursor cur = null;
        GridQueryCancel cancelHook = new GridQueryCancel();
        switch (template.getQueryType()) {
            case SQL_FIELDS: {
                SqlFieldsQuery qry = this.prepareSqlFieldsQuery(template);
                qry.setArgs(new Object[]{timeout});
                cur = (QueryCursor)F.first((List)qryProc.querySqlFields(null, qry, null, true, true, cancelHook));
                break;
            }
            case TEXT: {
                IgniteCache cache = ignite.cache(CACHE_WITH_LOAD);
                cur = cache.query((Query)new TextQuery(String.class, template.getQueryText()));
            }
        }
        if (cur != null) {
            if (RND.nextDouble() < 0.2) {
                cancelHook.cancel();
            } else {
                this.threadExec.execute(() -> ((QueryCursor)cur).getAll());
            }
        }
    }

    private void prepareCacheWithQueryLoad(IgniteEx ignite) {
        IgniteCache cache = ignite.getOrCreateCache(new CacheConfiguration(CACHE_WITH_LOAD).setIndexedTypes(new Class[]{Integer.class, String.class}));
        TreeMap<Integer, String> data = new TreeMap<Integer, String>();
        for (int i = 0; i < this.tableSize; ++i) {
            data.put(i, UUID.randomUUID().toString());
        }
        cache.putAll(data);
    }

    private void prepareCacheWithComplexQuery(IgniteEx ignite) {
        IgniteCache cache = ignite.getOrCreateCache(new CacheConfiguration(CACHE_WITH_COMPLEX_OBJECT).setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{LoadStatusKey.class, LoadStatus.class}));
        LocalDate ld = LocalDate.of(2022, 1, 1);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        HashMap<String, TargetCacheStatusEntry> map = new HashMap<String, TargetCacheStatusEntry>();
        map.put("key", new TargetCacheStatusEntry().setId(UUID.randomUUID()).setRequestId("id").setRegion(Region.R1).setTotalMessagesPublished(10L));
        cache.put((Object)new LoadStatusKey().setTargetCache(CACHE_WITH_LOAD).setAsOfDate(ld), (Object)new LoadStatus().setLastUpdateTime(ts).setEntriesByTaskName(map).setStatuses(new ArrayList<TargetCacheStatusEntry>(map.values())));
        cache.put((Object)new LoadStatusKey().setTargetCache("TestCache2"), (Object)new LoadStatus().setEntriesByTaskName(map).setEntriesByTaskName(map).setStatuses(map.values()));
    }

    private SqlFieldsQuery prepareSqlFieldsQuery(QueryTemplate template) {
        SqlFieldsQuery qry = new SqlFieldsQuery(template.getQueryText());
        qry.setSchema(CACHE_WITH_LOAD);
        qry.setLocal(template.isLocal());
        qry.setDistributedJoins(template.isDistributedJoins());
        qry.setCollocated(template.isCollocated());
        qry.setEnforceJoinOrder(template.isEnforceJoinOrder());
        qry.setLazy(template.isLazy());
        if (!F.isEmpty((Object[])template.getParameters())) {
            qry.setArgs(template.getParameters());
        }
        return qry;
    }

    static {
        queries = Arrays.asList(new QueryTemplate().setQueryType(GridCacheQueryType.SQL_FIELDS).setQueryText("SELECT 1").setLazy(true), new QueryTemplate().setQueryType(GridCacheQueryType.SQL_FIELDS).setQueryText("SELECT count(*)").setLazy(true).setLocal(true), new QueryTemplate().setQueryType(GridCacheQueryType.SQL_FIELDS).setQueryText("SELECT count(*)").setLazy(true), new QueryTemplate().setQueryType(GridCacheQueryType.SQL_FIELDS).setQueryText("SELECT * FROM String a, String b WHERE a._KEY < ?").setLocal(true), new QueryTemplate().setQueryType(GridCacheQueryType.SQL_FIELDS).setQueryText("SELECT * FROM InvalidType").setLazy(true), new QueryTemplate().setQueryType(GridCacheQueryType.TEXT).setQueryText("text query"));
    }

    public static class QueryTemplate {
        private GridCacheQueryType qryType;
        private String qryTxt;
        private Object[] parameters;
        private boolean distributedJoins;
        private boolean enforceJoinOrder;
        private boolean isLoc;
        private boolean lazy;
        private boolean collocated;

        public GridCacheQueryType getQueryType() {
            return this.qryType;
        }

        public QueryTemplate setQueryType(GridCacheQueryType qryType) {
            this.qryType = qryType;
            return this;
        }

        public String getQueryText() {
            return this.qryTxt;
        }

        public QueryTemplate setQueryText(String qryTxt) {
            this.qryTxt = qryTxt;
            return this;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public QueryTemplate setParameters(Object[] parameters) {
            this.parameters = parameters;
            return this;
        }

        public boolean isDistributedJoins() {
            return this.distributedJoins;
        }

        public QueryTemplate setDistributedJoins(boolean distributedJoins) {
            this.distributedJoins = distributedJoins;
            return this;
        }

        public boolean isEnforceJoinOrder() {
            return this.enforceJoinOrder;
        }

        public QueryTemplate setEnforceJoinOrder(boolean enforceJoinOrder) {
            this.enforceJoinOrder = enforceJoinOrder;
            return this;
        }

        public boolean isLocal() {
            return this.isLoc;
        }

        public QueryTemplate setLocal(boolean isLocal) {
            this.isLoc = isLocal;
            return this;
        }

        public boolean isLazy() {
            return this.lazy;
        }

        public QueryTemplate setLazy(boolean lazy) {
            this.lazy = lazy;
            return this;
        }

        public boolean isCollocated() {
            return this.collocated;
        }

        public QueryTemplate setCollocated(boolean collocated) {
            this.collocated = collocated;
            return this;
        }
    }
}

