/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.rolebased;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.gridgain.control.agent.AbstractSelfTest;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.rolebased.RoleBasedAuthenticator;
import org.gridgain.grid.security.rolebased.UserCredential;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JdbcThinAuthorizationRoleBasedAuthenticationTest
extends AbstractSelfTest {
    private static final String USERNAME = "user";
    private static final String PASSWORD = "user";
    private static final String ADMIN_USERNAME = "admin";
    private static final String ADMIN_PASSWORD = "admin";
    private static final String STATIC_USER = "default";
    private static final String STATIC_ROLE = "default";
    private static final String STATIC_PASSWORD = "default";
    private static final String USER_ROLE = "users";
    private static final String ADMIN_ROLE = "admins";

    @Before
    public void setup() {
        this.cleanPersistenceDir();
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        TestUtils.createRole(ignite, ADMIN_ROLE, "{defaultAllow:true}");
        TestUtils.createUser(ignite, "admin", "admin", ADMIN_ROLE);
        TestUtils.createUser(ignite, "user", "user", USER_ROLE);
    }

    @After
    public void teardown() {
        this.stopAllGrids();
    }

    @Test
    public void testConnectionOnInactiveGrid() throws Exception {
        this.ignite(0).cluster().state(ClusterState.INACTIVE);
        Connection ignored = this.connectDefaultUser();
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
        this.ensureAuthenticationFailure(() -> {
            Connection ignored = this.connectUser();
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }, "user");
    }

    @Test
    public void testCreateTableAllowed() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]}}");
        try (Connection conn = this.connectUser();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
        }
    }

    @Test
    public void testCreateTableDenied() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:false,{system:[]}}");
        try (Connection conn = this.connectUser();){
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)"), "CACHE_CREATE");
        }
    }

    @Test
    public void testDropTableAllowed() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE, CACHE_DESTROY]}}");
        try (Connection conn = this.connectUser();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DROP TABLE test");
        }
    }

    @Test
    public void testDropTableDenied() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:false,{system:[CACHE_CREATE]}}");
        try (Connection conn = this.connectUser();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DROP TABLE test"), "CACHE_DESTROY");
        }
    }

    @Test
    public void testUpdateAllowed() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]},{cache:'*',permissions:[CACHE_READ,CACHE_PUT]}}");
        try (Connection conn = this.connectUser();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "UPDATE test SET name='2' WHERE id=1");
        }
    }

    @Test
    public void testUpdateDenied() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]},{cache:'*',permissions:[CACHE_READ]}}");
        try (Connection conn = this.connectUser();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test2(id BIGINT PRIMARY KEY, name VARCHAR)");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')"), "CACHE_PUT");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test2(id, name) VALUES (1, '1')"), "CACHE_PUT");
        }
        conn = this.connectAdmin();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.connectDefaultUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test2(id, name) VALUES (1, '1')");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.connectUser();
        var2_2 = null;
        try {
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "UPDATE test SET name='2' WHERE id=1"), "CACHE_PUT");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "UPDATE test2 SET name='2' WHERE id=1"), "CACHE_PUT");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpdateDeniedWithoutReadPermission() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]},{cache:'*',permissions:[CACHE_PUT, CACHE_REMOVE]}}");
        try (Connection conn = this.connectAdmin();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
        }
        conn = this.connectDefaultUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test2(id BIGINT PRIMARY KEY, name VARCHAR)");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.connectUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test2(id, name) VALUES (1, '1')");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "UPDATE test SET name='2' WHERE name='1'"), "CACHE_READ");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "UPDATE test2 SET name='2' WHERE name='1'"), "CACHE_READ");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DELETE FROM test WHERE name='1'"), "CACHE_READ");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DELETE FROM test2 WHERE name='1'"), "CACHE_READ");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testRemoveAllowed() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]},{cache:'*',permissions:[CACHE_READ,CACHE_REMOVE]}}");
        try (Connection conn = this.connectAdmin();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')");
        }
        conn = this.connectDefaultUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test2(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test2(id, name) VALUES (1, '1')");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.connectUser();
        var2_2 = null;
        try {
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "UPDATE test SET name='2' WHERE id=1"), "CACHE_PUT");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DELETE FROM test WHERE id=1");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "UPDATE test2 SET name='2' WHERE id=1"), "CACHE_PUT");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DELETE FROM test2 WHERE id=1");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testRemoveDenied() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]},{cache:'*',permissions:[CACHE_READ]}}");
        try (Connection conn = this.connectAdmin();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')");
        }
        conn = this.connectDefaultUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test2(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test2(id, name) VALUES (1, '1')");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.connectUser();
        var2_2 = null;
        try {
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DELETE FROM test WHERE id=1"), "CACHE_REMOVE");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "DELETE FROM test2 WHERE id=1"), "CACHE_REMOVE");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSelectAllowed() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]},{cache:'*',permissions:[CACHE_READ]}}");
        try (Connection conn = this.connectAdmin();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')");
        }
        conn = this.connectDefaultUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test2(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test2(id, name) VALUES (1, '1')");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.connectUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.executeSelect(conn, "SELECT * FROM test WHERE id=1");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.executeSelect(conn, "SELECT * FROM test2 WHERE id=1");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSelectDenied() throws Exception {
        TestUtils.createRole(this.ignite(0), USER_ROLE, "{defaultAllow:true,{system:[CACHE_CREATE]},{cache:'*',permissions:[]}}");
        try (Connection conn = this.connectAdmin();){
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test(id, name) VALUES (1, '1')");
        }
        conn = this.connectDefaultUser();
        var2_2 = null;
        try {
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "CREATE TABLE test2(id BIGINT PRIMARY KEY, name VARCHAR)");
            JdbcThinAuthorizationRoleBasedAuthenticationTest.execute(conn, "INSERT INTO test2(id, name) VALUES (1, '1')");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.connectUser();
        var2_2 = null;
        try {
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.executeSelect(conn, "SELECT * FROM test WHERE id=1"), "CACHE_READ");
            this.ensureAuthorizationFailure(() -> JdbcThinAuthorizationRoleBasedAuthenticationTest.executeSelect(conn, "SELECT * FROM test2 WHERE id=1"), "CACHE_READ");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testCreateUserWithSqlAndPasswordIsHashed() {
        this.checkPasswordIsHashed("admin", "admin");
        this.checkPasswordIsHashed("user", "user");
    }

    @Test
    public void testCreateUserInCacheAndPasswordIsHashed() {
        String userLogin = "testUser";
        String userPass = "qwe123";
        IgniteEx ignite = this.ignite(0);
        IgniteCache cache = ignite.cache("ignite-users-cache");
        cache.put((Object)userLogin, (Object)new UserCredential(userPass, USER_ROLE));
        UserCredential userCred = (UserCredential)cache.get((Object)userLogin);
        AgentUtils.checkBcrypt((String)userPass, (String)userCred.getPassword());
        this.checkPasswordIsHashed(userLogin, userPass);
    }

    private void ensureAuthorizationFailure(Throwing task, String expPerm) {
        try {
            task.run();
            Assert.fail((String)"Exception not thrown.");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLException e0 = (SQLException)e;
                Assert.assertEquals((Object)"50000", (Object)e0.getSQLState());
                Assert.assertTrue((String)e0.getMessage(), (boolean)e0.getMessage().startsWith("Authorization failed [perm=" + expPerm));
            }
            Assert.fail((String)("Unexpected exception: " + e));
        }
    }

    private void checkPasswordIsHashed(String login, String pwdPlain) {
        IgniteEx ignite = this.ignite(0);
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT password FROM SecurityUsers WHERE login = $1").setArgs(new Object[]{login});
        try (FieldsQueryCursor resSet = ignite.context().query().querySqlFields(qry, true);){
            resSet.forEach(row -> AgentUtils.checkBcrypt((String)pwdPlain, (String)F.first((List)row).toString()));
        }
    }

    private void ensureAuthenticationFailure(Throwing task, String user) {
        try {
            task.run();
            Assert.fail((String)"Exception is not thrown.");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLException e0 = (SQLException)e;
                Assert.assertEquals((Object)"08004", (Object)e0.getSQLState());
                Assert.assertTrue((String)e0.getMessage(), (boolean)e0.getMessage().contains("The user name or password is incorrect"));
            }
            Assert.fail((String)("Unexpected exception: " + e));
        }
    }

    protected Connection connectUser() throws Exception {
        return JdbcThinAuthorizationRoleBasedAuthenticationTest.connect("user", "user");
    }

    protected Connection connectAdmin() throws Exception {
        return JdbcThinAuthorizationRoleBasedAuthenticationTest.connect("admin", "admin");
    }

    protected Connection connectDefaultUser() throws Exception {
        return JdbcThinAuthorizationRoleBasedAuthenticationTest.connect("default", "default");
    }

    private static Connection connect(String user, String pwd) throws Exception {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1;user=" + user + ";password=" + pwd);
    }

    private static void execute(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    private static void executeSelect(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
            }
        }
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration(instanceName).setCacheConfiguration(new CacheConfiguration[]{TestUtils.nebulaUserCacheConfiguration(), TestUtils.nebulaRoleCacheConfiguration()}).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:true}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("default", "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("default", "default")))});
    }

    @FunctionalInterface
    private static interface Throwing {
        public void run() throws Exception;
    }
}

