/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.structures;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.logger.NullLogger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.gridgain.control.agent.structures.TiersMetricTree;
import org.gridgain.control.agent.test.MetricTreeFixture;
import org.junit.Test;

public class TiersMetricTreeTest {
    @Test
    public void emptyTree() {
        TiersMetricTree tree = new TiersMetricTree();
        Assertions.assertThat((int)tree.getSize()).isEqualTo(0);
        Assertions.assertThat((int)tree.getForkNumber()).isEqualTo(0);
        Assertions.assertThat((List)tree.findAllBy(Arrays.asList("test.test.test", "test.*.test"))).isEmpty();
        Assertions.assertThat((List)tree.findAllBy(Collections.emptyList())).isEmpty();
    }

    @Test
    public void updateEmptyTreeWithoutChanges() {
        TiersMetricTree tree = new TiersMetricTree();
        boolean updated = tree.addMetrics(new HashMap());
        Assertions.assertThat((boolean)updated).isFalse();
        Assertions.assertThat((int)tree.getSize()).isEqualTo(0);
        Assertions.assertThat((int)tree.getForkNumber()).isEqualTo(0);
        Assertions.assertThat((List)tree.findAllBy(Arrays.asList("test.test.test", "test.*.test"))).isEmpty();
        Assertions.assertThat((List)tree.findAllBy(Collections.emptyList())).isEmpty();
    }

    @Test
    public void shouldNotFound() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        Assertions.assertThat((List)tree.findAllBy(Arrays.asList("test.test.test", "test.*.test"))).isEmpty();
        Assertions.assertThat((List)tree.findAllBy(Collections.emptyList())).isEmpty();
    }

    @Test
    public void shouldReturnSizeAndForkNumberForDefaultTestTree() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        Assertions.assertThat((int)tree.getSize()).isEqualTo(9);
        Assertions.assertThat((int)tree.getForkNumber()).isEqualTo(14);
    }

    @Test
    public void shouldFindAll() {
        Map<String, MetricRegistry> registries = MetricTreeFixture.defaultTestData();
        TiersMetricTree tree = new TiersMetricTree(registries);
        this.assertEquals(tree.findAll(), registries);
        this.assertEquals(tree.findAllBy(Collections.singleton("*.*.*")), registries);
    }

    @Test
    public void shouldFindByTire() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)tree.findAllBy(Collections.singletonList("aaa.aaa.aaa"))).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{reg -> {
            Assertions.assertThat((String)reg.name()).isEqualTo("test1");
            ((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"aaa.aaa.aaa"});
        }});
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)tree.findAllBy(Collections.singletonList("kkk.kkk.kkk"))).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{reg -> {
            Assertions.assertThat((String)reg.name()).isEqualTo("test2");
            ((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"kkk.kkk.kkk"});
        }});
    }

    @Test
    public void shouldFindByStar() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)tree.findAllBy(Collections.singletonList("zzz.aaa.*"))).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{reg -> {
            Assertions.assertThat((String)reg.name()).isEqualTo("test1");
            ((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(2)).containsOnlyKeys((Object[])new String[]{"zzz.aaa.bbb", "zzz.aaa.kkk"});
        }});
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)tree.findAllBy(Collections.singletonList("kkk.*.kkk"))).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{reg -> {
            Assertions.assertThat((String)reg.name()).isEqualTo("test2");
            ((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"kkk.kkk.kkk"});
        }});
    }

    @Test
    public void shouldFindInToDifferentRegistersSameMetrics() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        List res = tree.findAllBy(Collections.singletonList("aaa.aaa.bbb"));
        Assertions.assertThat(res.stream().filter(r -> "test1".equals(r.name())).findFirst()).hasValueSatisfying(reg -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"aaa.aaa.bbb"});
        });
        Assertions.assertThat(res.stream().filter(r -> "test2".equals(r.name())).findFirst()).hasValueSatisfying(reg -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"aaa.aaa.bbb"});
        });
    }

    @Test
    public void shouldFindByStarInToDifferentRegistersSameMetrics() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        List res = tree.findAllBy(Collections.singletonList("*.bbb.*"));
        Assertions.assertThat(res.stream().filter(r -> "test1".equals(r.name())).findFirst()).hasValueSatisfying(reg -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"aaa.bbb.aaa"});
        });
        Assertions.assertThat(res.stream().filter(r -> "test2".equals(r.name())).findFirst()).hasValueSatisfying(reg -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(2)).containsOnlyKeys((Object[])new String[]{"aaa.bbb.aaa", "aaa.bbb.lll"});
        });
    }

    @Test
    public void shouldNotUpdateTreeIfSameElementAlreadyExists() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        Assertions.assertThat((boolean)tree.addMetrics(new HashMap())).isFalse();
        Assertions.assertThat((int)tree.getSize()).isEqualTo(9);
        Assertions.assertThat((int)tree.getForkNumber()).isEqualTo(14);
        Assertions.assertThat((boolean)tree.addMetrics(MetricTreeFixture.defaultTestData())).isFalse();
        Assertions.assertThat((int)tree.getSize()).isEqualTo(9);
        Assertions.assertThat((int)tree.getForkNumber()).isEqualTo(14);
    }

    @Test
    public void shouldUpdateOnlyNewElementInTree() {
        TiersMetricTree tree = new TiersMetricTree(MetricTreeFixture.defaultTestData());
        Assertions.assertThat((List)tree.findAllBy(Arrays.asList("aaa.test.test", "aaa.*.test"))).isEmpty();
        MetricRegistry registry = new MetricRegistry("test3", "test3", null, null, (IgniteLogger)new NullLogger(), IgniteUtils.map((Object)"aaa.test.test", (Object)new AtomicLongMetric("aaa.test.test", null)));
        Map<String, MetricRegistry> mapWithNewElement = MetricTreeFixture.defaultTestData();
        mapWithNewElement.put(registry.name(), registry);
        Assertions.assertThat((boolean)tree.addMetrics(mapWithNewElement)).isTrue();
        Assertions.assertThat((int)tree.getSize()).isEqualTo(10);
        Assertions.assertThat((int)tree.getForkNumber()).isEqualTo(16);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)tree.findAllBy(Collections.singletonList("aaa.*.test"))).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{reg -> {
            Assertions.assertThat((String)reg.name()).isEqualTo("test3");
            ((MapAssert)Assertions.assertThat((Map)reg.metrics()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"aaa.test.test"});
        }});
    }

    private void assertEquals(List<MetricRegistry> actual, Map<String, MetricRegistry> exp) {
        for (Map.Entry<String, MetricRegistry> entry : exp.entrySet()) {
            MetricRegistry metrics = actual.stream().filter(f -> f.name().equals(entry.getKey())).findFirst().get();
            Assertions.assertThat((Map)metrics.metrics()).isEqualTo((Object)entry.getValue().metrics());
        }
    }
}

