/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.lifecycle;

import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.control.agent.processor.AbstractServiceTest;
import org.gridgain.control.agent.processor.lifecycle.ClusterLifecycleProcessor;
import org.gridgain.control.agent.processor.lifecycle.LifecycleState;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ClusterLifecycleProcessorTest
extends AbstractServiceTest {
    private ClusterLifecycleProcessor lifecycleProc;

    @Before
    public void setup() {
        this.lifecycleProc = new ClusterLifecycleProcessor(this.getMockContext());
        this.lifecycleProc.start();
    }

    @After
    public void tearDown() {
        this.lifecycleProc.stop(true);
    }

    @Test
    public void shouldStopAllActiveProcessors() throws Exception {
        GridProcessor mockProc_1 = (GridProcessor)Mockito.mock(GridProcessor.class);
        GridProcessor mockProc_2 = (GridProcessor)Mockito.mock(GridProcessor.class);
        this.lifecycleProc.registerExporter(mockProc_1, new LifecycleState[]{LifecycleState.CONNECTED});
        this.lifecycleProc.registerExporter(mockProc_2, new LifecycleState[]{LifecycleState.CONNECTED, LifecycleState.ACTIVATED});
        this.lifecycleProc.onAgentConnectedStatusChanged(true);
        this.lifecycleProc.stop(true);
        ((GridProcessor)Mockito.verify((Object)mockProc_1, (VerificationMode)Mockito.times((int)1))).stop(true);
        ((GridProcessor)Mockito.verify((Object)mockProc_2, (VerificationMode)Mockito.never())).stop(true);
    }

    @Test
    public void shouldStart2TimesAndStop2Times() throws Exception {
        GridProcessor mock = (GridProcessor)Mockito.mock(GridProcessor.class);
        this.lifecycleProc.registerExporter(mock, new LifecycleState[]{LifecycleState.CONNECTED});
        this.lifecycleProc.onAgentConnectedStatusChanged(false);
        this.lifecycleProc.onAgentConnectedStatusChanged(true);
        this.lifecycleProc.onAgentConnectedStatusChanged(true);
        this.lifecycleProc.onAgentConnectedStatusChanged(false);
        this.lifecycleProc.onAgentConnectedStatusChanged(false);
        this.lifecycleProc.onAgentConnectedStatusChanged(true);
        this.lifecycleProc.onAgentConnectedStatusChanged(false);
        ((GridProcessor)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)2))).start();
        ((GridProcessor)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)2))).stop(true);
    }

    @Test
    public void shouldStartAndStopConcurrently() throws Exception {
        GridProcessor mock = (GridProcessor)Mockito.mock(GridProcessor.class);
        this.lifecycleProc.registerExporter(mock, new LifecycleState[]{LifecycleState.CONNECTED});
        int parallelism = 10;
        int repeats = 25;
        for (int i = 0; i < repeats; ++i) {
            TestUtils.runMultipleTimesConcurrently(() -> this.lifecycleProc.onAgentConnectedStatusChanged(true), parallelism);
            TestUtils.runMultipleTimesConcurrently(() -> this.lifecycleProc.onAgentConnectedStatusChanged(false), parallelism);
        }
        ((GridProcessor)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)repeats))).start();
        ((GridProcessor)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)repeats))).stop(true);
    }

    @Override
    protected GridKernalContext getMockContext() {
        GridKernalContext ctx = super.getMockContext();
        Mockito.when((Object)ctx.event()).thenReturn(Mockito.mock(GridEventStorageManager.class));
        Mockito.when((Object)ctx.io()).thenReturn(Mockito.mock(GridIoManager.class));
        IgniteClusterEx cluster = (IgniteClusterEx)Mockito.mock(IgniteClusterEx.class);
        ClusterGroup grp = (ClusterGroup)Mockito.mock(ClusterGroup.class);
        Mockito.when((Object)ctx.grid().cluster()).thenReturn((Object)cluster);
        Mockito.when((Object)cluster.forPredicate((IgnitePredicate)ArgumentMatchers.any())).thenReturn((Object)grp);
        Mockito.when((Object)grp.forRemotes()).thenReturn((Object)grp);
        return ctx;
    }
}

