/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export.task;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatus;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatusSnapshot;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.apache.ignite.spi.collision.priorityqueue.PriorityQueueCollisionSpi;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.gridgain.control.agent.configuration.DistributedTaskExporterConfiguration;
import org.gridgain.control.agent.dto.compute.TaskInfo;
import org.gridgain.control.agent.dto.compute.TaskInfoStatus;
import org.gridgain.control.agent.processor.export.task.TaskInfoMapper;
import org.gridgain.control.agent.utils.AgentUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TaskInfoMapperWithPriorityQueueCollisionSpiTest {
    private static final String TEST_TASK_NAME = "test_task_name";
    private static final String TEST_PRIORITY_ATTRIBUTE = "grid.task.priority";
    private TaskInfoMapper taskInfoMapper;

    @Before
    public void init() {
        DistributedTaskExporterConfiguration taskExportCfg = (DistributedTaskExporterConfiguration)Mockito.mock(DistributedTaskExporterConfiguration.class);
        Mockito.when((Object)taskExportCfg.maxAttributeSize()).thenReturn((Object)255);
        Mockito.when((Object)taskExportCfg.taskBatchSize()).thenReturn((Object)100);
        GridKernalContext ctx = (GridKernalContext)Mockito.mock(GridKernalContext.class);
        Mockito.when((Object)ctx.config()).thenReturn((Object)new IgniteConfiguration().setCollisionSpi((CollisionSpi)new PriorityQueueCollisionSpi()));
        this.taskInfoMapper = new TaskInfoMapper(ctx, taskExportCfg);
    }

    @Test
    public void shouldMapBaseFields() {
        long curTime = 88888L;
        ComputeTaskStatusSnapshot snapshot = this.computeTaskStatusSnapshot();
        TaskInfo taskInfo = this.taskInfoMapper.toTask(curTime, snapshot);
        AssertionsForClassTypes.assertThat((Object)taskInfo.getStatus()).isEqualTo((Object)TaskInfoStatus.RUNNING);
        AssertionsForClassTypes.assertThat((String)taskInfo.getTaskName()).isEqualTo(snapshot.taskName());
        AssertionsForClassTypes.assertThat((Object)taskInfo.getSessionId()).isEqualTo((Object)snapshot.sessionId());
        AssertionsForClassTypes.assertThat((Object)taskInfo.getReducerId()).isEqualTo((Object)snapshot.originatingNodeId());
        AssertionsForClassTypes.assertThat((Long)taskInfo.getEndedAt()).isEqualTo((Object)AgentUtils.zeroToNull((long)snapshot.endTime()));
        AssertionsForClassTypes.assertThat((Object)taskInfo.getSessionId()).isEqualTo((Object)snapshot.sessionId());
        AssertionsForClassTypes.assertThat((long)taskInfo.getVersion()).isEqualTo(curTime);
        AssertionsForClassTypes.assertThat((boolean)taskInfo.isFullSupport()).isTrue();
        ((AbstractStringAssert)AssertionsForClassTypes.assertThat((String)taskInfo.getCreatedBy()).isNotNull()).isEqualTo(snapshot.createBy());
    }

    @Test
    public void shouldCatsLongAttributes() {
        String attrKey = RandomStringUtils.random((int)510);
        String attrVal = RandomStringUtils.random((int)765);
        ComputeTaskStatusSnapshot snapshot = this.computeTaskStatusSnapshot(U.map((Object)attrKey, (Object)attrVal));
        TaskInfo taskInfo = this.taskInfoMapper.toTask(123L, snapshot);
        String cutVal = (String)taskInfo.getAttributes().get(attrKey.substring(0, 255));
        AssertionsForClassTypes.assertThat((String)cutVal).isEqualTo(attrVal.substring(0, 255));
    }

    @Test
    public void shouldReturnTaskPriority() {
        int testPri = 99;
        ComputeTaskStatusSnapshot snapshot = this.computeTaskStatusSnapshot(U.map((Object)TEST_PRIORITY_ATTRIBUTE, (Object)99));
        TaskInfo taskInfo = this.taskInfoMapper.toTask(0L, snapshot);
        AssertionsForClassTypes.assertThat((Integer)taskInfo.getPriority()).isEqualTo(99);
        snapshot = this.computeTaskStatusSnapshot();
        taskInfo = this.taskInfoMapper.toTask(0L, snapshot);
        AssertionsForClassTypes.assertThat((Integer)taskInfo.getPriority()).isEqualTo(0);
    }

    private ComputeTaskStatusSnapshot computeTaskStatusSnapshot() {
        return this.computeTaskStatusSnapshot(null);
    }

    private ComputeTaskStatusSnapshot computeTaskStatusSnapshot(@Nullable Map<Object, Object> attrs) {
        return ComputeTaskStatus.snapshot((GridTaskSessionImpl)new GridTaskSessionImpl(UUID.randomUUID(), TEST_TASK_NAME, null, TEST_TASK_NAME, IgniteUuid.randomUuid(), null, null, 12345L, 123456L, Collections.emptyList(), attrs, (GridKernalContext)Mockito.mock(GridKernalContext.class), true, false, UUID.randomUUID(), null, (Object)"test_login"));
    }
}

