/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export;

import io.opencensus.common.Timestamp;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracestate;
import io.opencensus.trace.export.SpanData;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.tracing.TracingSpi;
import org.apache.ignite.spi.tracing.opencensus.OpenCensusTraceExporter;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.configuration.DistributedSpanExporterConfiguration;
import org.gridgain.control.agent.dto.feature.AbstractFeatureRequest;
import org.gridgain.control.agent.dto.feature.AgentDynamicFeatures;
import org.gridgain.control.agent.dto.feature.DisablingAgentFeatureRequest;
import org.gridgain.control.agent.dto.tracing.Span;
import org.gridgain.control.agent.dto.tracing.SpanBatch;
import org.gridgain.control.agent.processor.AbstractServiceTest;
import org.gridgain.control.agent.processor.export.SpanExporter;
import org.gridgain.control.agent.processor.feature.AgentDynamicFeatureProcessor;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

public class SpanExporterTest
extends AbstractServiceTest {
    private static final int SPAN_MAX_BATCH_SIZE = 300;
    private final GridKernalContext ctx = this.getMockContext();
    private final DistributedSpanExporterConfiguration exporterCfg = this.getMockExportConfig();
    private final AgentDynamicFeatureProcessor agentFeatureProcessor = new AgentDynamicFeatureProcessor(Clock.systemDefaultZone());
    private static final String UNKNOWN_SPAN_NAME = "unknown.name-123";

    @Before
    public void setup() {
        Queue exporters = (Queue)ReflectionTestUtils.getField(SpanExporter.class, (String)"LOCAL_EXPORTERS");
        exporters.clear();
    }

    @Test
    public void shouldSendTracesToTopic() throws Exception {
        SpanExporter exporter = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        exporter.getTraceHandler().timeLimitedExport(this.getSpanData());
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(SpanBatch.class);
        ((ControlCenterAgent)Mockito.verify((Object)AgentUtils.ggccAgent((GridKernalContext)this.ctx), (VerificationMode)Mockito.timeout((long)100L).times(1))).sendToAgentCoordinator((String)ArgumentMatchers.eq((Object)"control-center-agent-topic"), (Message)payloadCaptor.capture());
        List spans = ((SpanBatch)payloadCaptor.getValue()).getList();
        Assert.assertEquals((long)1L, (long)spans.size());
        Span span = (Span)F.first((List)spans);
        Assert.assertEquals((Object)SpanType.CACHE_API_GET.spanName(), (Object)span.getName());
        Assert.assertEquals((Object)SpanType.CACHE_API_GET.scope(), (Object)span.getScope());
    }

    @Test
    public void shouldSendTracesWithUnknownSpanNameToTopic() throws Exception {
        SpanExporter exporter = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        exporter.getTraceHandler().timeLimitedExport(this.getSpanDataWithUnknownName());
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(SpanBatch.class);
        ((ControlCenterAgent)Mockito.verify((Object)AgentUtils.ggccAgent((GridKernalContext)this.ctx), (VerificationMode)Mockito.timeout((long)100L).times(1))).sendToAgentCoordinator((String)ArgumentMatchers.eq((Object)"control-center-agent-topic"), (Message)payloadCaptor.capture());
        List spans = ((SpanBatch)payloadCaptor.getValue()).getList();
        Assert.assertEquals((long)1L, (long)spans.size());
        Span span = (Span)F.first((List)spans);
        Assert.assertEquals((Object)UNKNOWN_SPAN_NAME, (Object)span.getName());
        Assert.assertNull((Object)span.getScope());
    }

    @Test
    public void shouldSendTracesWithNullEndTimestampToTopic() throws Exception {
        SpanExporter exporter = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        exporter.getTraceHandler().timeLimitedExport(Collections.singletonList(this.createSpan(SpanType.CACHE_API_GET.spanName(), null)));
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(SpanBatch.class);
        ((ControlCenterAgent)Mockito.verify((Object)AgentUtils.ggccAgent((GridKernalContext)this.ctx), (VerificationMode)Mockito.timeout((long)100L).times(1))).sendToAgentCoordinator((String)ArgumentMatchers.eq((Object)"control-center-agent-topic"), (Message)payloadCaptor.capture());
        List spans = ((SpanBatch)payloadCaptor.getValue()).getList();
        Assert.assertEquals((long)1L, (long)spans.size());
        Span span = (Span)F.first((List)spans);
        Assert.assertEquals((Object)SpanType.CACHE_API_GET.spanName(), (Object)span.getName());
        Assert.assertEquals((Object)SpanType.CACHE_API_GET.scope(), (Object)span.getScope());
        Assert.assertEquals((long)10000L, (long)span.getTimestamp());
        Assert.assertEquals((long)0L, (long)span.getDuration());
    }

    @Test
    public void shouldNotSendTracesWhenTracingDisabled() throws Exception {
        SpanExporter exporter = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        this.agentFeatureProcessor.onRequest((AbstractFeatureRequest)new DisablingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), false));
        exporter.getTraceHandler().timeLimitedExport(this.getSpanData());
        ((ControlCenterAgent)Mockito.verify((Object)AgentUtils.ggccAgent((GridKernalContext)this.ctx), (VerificationMode)Mockito.never())).sendToAgentCoordinator((String)ArgumentMatchers.eq((Object)"control-center-agent-topic"), (Message)ArgumentMatchers.any(Message.class));
    }

    @Test
    public void shouldSplitSpansToBatches() throws Exception {
        SpanExporter exporter = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        List<SpanData> overflowedSpanBatch = this.getSpanData(301);
        exporter.getTraceHandler().timeLimitedExport(overflowedSpanBatch);
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(SpanBatch.class);
        ((ControlCenterAgent)Mockito.verify((Object)AgentUtils.ggccAgent((GridKernalContext)this.ctx), (VerificationMode)Mockito.timeout((long)100L).times(2))).sendToAgentCoordinator((String)ArgumentMatchers.eq((Object)"control-center-agent-topic"), (Message)payloadCaptor.capture());
        List allCalls = payloadCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)allCalls.size());
        Assert.assertEquals((long)300L, (long)((SpanBatch)allCalls.get(0)).getList().size());
        Assert.assertEquals((long)1L, (long)((SpanBatch)allCalls.get(1)).getList().size());
    }

    @Test
    public void shouldStart() {
        SpanExporter exporter = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        OpenCensusTraceExporter mock = this.mockTraceExporter(exporter);
        exporter.start();
        ((OpenCensusTraceExporter)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.eq((Object)this.ctx.igniteInstanceName()));
    }

    @Test
    public void shouldStartOnlyOneExporter() {
        SpanExporter spanExporter1 = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        SpanExporter spanExporter2 = new SpanExporter(this.ctx, this.exporterCfg, this.agentFeatureProcessor);
        OpenCensusTraceExporter exporter1 = this.mockTraceExporter(spanExporter1);
        OpenCensusTraceExporter exporter2 = this.mockTraceExporter(spanExporter2);
        spanExporter1.start();
        spanExporter2.start();
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.never())).stop();
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.never())).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.never())).stop();
        spanExporter2.stop(true);
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.never())).stop();
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.never())).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.never())).stop();
        spanExporter2.start();
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.never())).stop();
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.never())).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.never())).stop();
        spanExporter1.stop(true);
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.times((int)1))).stop();
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.never())).stop();
        spanExporter2.stop(true);
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter1, (VerificationMode)Mockito.times((int)1))).stop();
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.times((int)1))).start((String)ArgumentMatchers.any());
        ((OpenCensusTraceExporter)Mockito.verify((Object)exporter2, (VerificationMode)Mockito.times((int)1))).stop();
    }

    private OpenCensusTraceExporter mockTraceExporter(SpanExporter exporter) {
        OpenCensusTraceExporter mockExporter = (OpenCensusTraceExporter)Mockito.mock(OpenCensusTraceExporter.class);
        ReflectionTestUtils.setField((Object)exporter, (String)"exporter", (Object)mockExporter);
        return mockExporter;
    }

    @Override
    protected GridKernalContext getMockContext() {
        GridKernalContext ctx = super.getMockContext();
        IgniteClusterEx cluster = ctx.grid().cluster();
        ClusterGroup grp = (ClusterGroup)Mockito.mock(ClusterGroup.class);
        Mockito.when((Object)cluster.forServers()).thenReturn((Object)grp);
        Mockito.when((Object)grp.nodes()).thenReturn(Collections.singletonList(new TcpDiscoveryNode()));
        IgniteConfiguration cfg = (IgniteConfiguration)Mockito.mock(IgniteConfiguration.class);
        TracingSpi tracingSpi = (TracingSpi)Mockito.mock(TracingSpi.class);
        Mockito.when((Object)ctx.config()).thenReturn((Object)cfg);
        Mockito.when((Object)cfg.getTracingSpi()).thenReturn((Object)tracingSpi);
        return ctx;
    }

    private DistributedSpanExporterConfiguration getMockExportConfig() {
        DistributedSpanExporterConfiguration cfg = (DistributedSpanExporterConfiguration)Mockito.mock(DistributedSpanExporterConfiguration.class);
        Mockito.when((Object)cfg.spanBatchSize()).thenReturn((Object)300);
        return cfg;
    }

    private List<SpanData> getSpanData(int spanNumbers) {
        return IntStream.range(0, spanNumbers).mapToObj(i -> this.createSpan()).collect(Collectors.toList());
    }

    private List<SpanData> getSpanData() {
        return Collections.singletonList(this.createSpan());
    }

    private List<SpanData> getSpanDataWithUnknownName() {
        return Collections.singletonList(this.createSpan(UNKNOWN_SPAN_NAME, Timestamp.create((long)20L, (int)20)));
    }

    private SpanData createSpan() {
        return this.createSpan(SpanType.CACHE_API_GET.spanName(), Timestamp.create((long)20L, (int)20));
    }

    private SpanData createSpan(String name, Timestamp endTimestamp) {
        return SpanData.create((SpanContext)SpanContext.create((TraceId)TraceId.generateRandomId((Random)new Random()), (SpanId)SpanId.generateRandomId((Random)new Random()), (TraceOptions)TraceOptions.DEFAULT, (Tracestate)Tracestate.builder().build()), (SpanId)SpanId.generateRandomId((Random)new Random()), (Boolean)false, (String)name, null, (Timestamp)Timestamp.create((long)10L, (int)10), (SpanData.Attributes)SpanData.Attributes.create(new HashMap(), (int)0), (SpanData.TimedEvents)SpanData.TimedEvents.create(new ArrayList(), (int)0), (SpanData.TimedEvents)SpanData.TimedEvents.create(new ArrayList(), (int)0), (SpanData.Links)SpanData.Links.create(new ArrayList(), (int)0), null, null, (Timestamp)endTimestamp);
    }
}

