/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.deployment;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.ignite.IgniteDeploymentException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.ThinClientConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.dto.action.deployment.MavenRepositoryConfiguration;
import org.gridgain.control.agent.processor.deployment.Artifact;
import org.gridgain.control.agent.processor.deployment.ArtifactType;
import org.gridgain.control.agent.processor.deployment.DeploymentUnitStatus;
import org.gridgain.control.agent.processor.deployment.DeploymentUnitVersionConfiguration;
import org.gridgain.control.agent.processor.deployment.ManagedDeploymentSpi;
import org.gridgain.control.agent.processor.deployment.ManagedDeploymentUnit;
import org.gridgain.control.agent.processor.deployment.NodeVersionStatusDetails;
import org.gridgain.control.agent.test.DeploymentUnitTestUtils;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ManagedDeploymentSpiTest
extends AgentCommonAbstractTest {
    private static final String TEST_TASK = "org.apache.ignite.tests.p2p.CacheDeploymentTestTask2";
    private static final String TEST_DU_NAME = "Test deployment";
    public static final MavenRepositoryConfiguration[] EMPTY_MAVEN_REPOSITORY_CONFIGS = new MavenRepositoryConfiguration[0];
    private static IgniteCallable<Integer> call;
    private static Service srvc;
    private ManagedDeploymentSpi deploymentSpi;
    private RepositorySystem repoSys = (RepositorySystem)Mockito.spy((Object)DeploymentUnitTestUtils.testRepositorySystem());

    protected static URLClassLoader prepareClassLoader() throws Exception {
        String callSrc = "package org.apache.ignite.tests.p2p.compute;import org.apache.ignite.lang.IgniteCallable;\npublic class ExternalCallable implements IgniteCallable {\n    @Override public Object call() {\n        return 43;\n    }\n}";
        String srvcSrc = "package org.apache.ignite.tests.p2p;\nimport org.apache.ignite.services.Service;\nimport org.apache.ignite.services.ServiceContext;\npublic class NoopService implements Service {\n    @Override public void cancel(ServiceContext ctx) {}\n    @Override public void init(ServiceContext ctx) throws Exception {}\n    @Override public void execute(ServiceContext ctx) throws Exception {}\n}";
        Path srcTmpDir = Files.createTempDirectory("ManagedDeploymentSpiTest", new FileAttribute[0]);
        Path callTmpDir = new File(srcTmpDir.toFile(), "org/apache/ignite/tests/p2p/compute").toPath();
        Files.createDirectories(callTmpDir, new FileAttribute[0]);
        Path srvcTmpDir = new File(srcTmpDir.toFile(), "org/apache/ignite/tests/p2p").toPath();
        Files.createDirectories(srvcTmpDir, new FileAttribute[0]);
        File callSrcFile = new File(callTmpDir.toFile(), "ExternalCallable.java");
        Path callSrcFilePath = Files.write(callSrcFile.toPath(), callSrc.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        File srvcSrcFile = new File(srvcTmpDir.toFile(), "NoopService.java");
        Path srvcSrcFilePath = Files.write(srvcSrcFile.toPath(), srvcSrc.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StringWriter compilerLogger = new StringWriter();
        String classPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String surefireClassPath = System.getProperty("surefire.test.class.path");
        if (surefireClassPath != null) {
            classPath = classPath + separator + surefireClassPath;
        }
        List cpList = Arrays.stream(classPath.split(separator)).map(File::new).collect(Collectors.toList());
        StandardJavaFileManager sjfm = compiler.getStandardFileManager(null, null, null);
        sjfm.setLocation(StandardLocation.CLASS_PATH, cpList);
        Iterable<? extends JavaFileObject> fileObjects = sjfm.getJavaFileObjects(callSrcFilePath.toFile(), srvcSrcFilePath.toFile());
        JavaCompiler.CompilationTask task = compiler.getTask(compilerLogger, sjfm, null, null, null, fileObjects);
        boolean result = task.call();
        String err = compilerLogger.toString();
        if (!result) {
            throw new IgniteException("Failed to compile test classes: " + err + ", cp: " + classPath);
        }
        try {
            sjfm.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close java filemanager: " + e.getMessage());
        }
        Assert.assertTrue((String)"Failed to remove source file.", (boolean)srvcSrcFile.delete());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return new URLClassLoader(new URL[]{srcTmpDir.toUri().toURL()}, loader);
    }

    @BeforeClass
    public static void enableEventDrivenServiceProcessor() throws Exception {
        System.setProperty("IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED", "true");
        URLClassLoader cl = ManagedDeploymentSpiTest.prepareClassLoader();
        call = (IgniteCallable)cl.loadClass("org.apache.ignite.tests.p2p.compute.ExternalCallable").newInstance();
        srvc = (Service)cl.loadClass("org.apache.ignite.tests.p2p.NoopService").newInstance();
    }

    @AfterClass
    public static void rollbackEnableEventDrivenServiceProcessor() {
        System.clearProperty("IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED");
    }

    protected int clusterSize() {
        return 1;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        IgnitionEx.dependencyResolver(this::stubForBlockingResolveArtifactMethod);
        IgniteEx ignite = this.startGrids(this.clusterSize());
        this.changeAgentConfiguration(ignite);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.deploymentSpi = (ManagedDeploymentSpi)ignite.configuration().getDeploymentSpi();
    }

    @Override
    public void teardown() {
        Mockito.reset((Object[])new RepositorySystem[]{this.repoSys});
        super.teardown();
    }

    @Test
    public void shouldPassWithValidSchema() throws Exception {
        this.deploymentSpi.collectDependencies(Arrays.asList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("http://localhost"), new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://localhost")));
    }

    @Test
    public void shouldFailWithExcludedArtifact() {
        TestUtils.assertThrows(() -> this.deploymentSpi.collectDependencies(Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-core:2.9.0"))), IllegalArgumentException.class);
    }

    @Test
    public void shouldCreateDeploymentUnitDraft() throws Exception {
        final String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeploymentUnitDraft(depId, Collections.emptyList());
        TestUtils.assertWithPoll(new ThrowingRunnable(){

            public void run() throws Throwable {
                Assertions.assertThat((List)ManagedDeploymentSpiTest.this.deploymentSpi.units()).extracting(new String[]{"deploymentId", "status", "version"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, DeploymentUnitStatus.DRAFT, null})});
            }
        });
        List cfgs = this.deploymentSpi.readDeploymentUnitConfigs(depId);
        ((ListAssert)Assertions.assertThat((List)cfgs).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"createdAt"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitVersionConfiguration[]{new DeploymentUnitVersionConfiguration().setVersionId(verId).setName(TEST_DU_NAME).setArtifacts(Collections.emptyList())});
    }

    @Test
    public void shouldDeployNewVersionOnNodeJoin() throws Exception {
        String depIdDraft = UUID.randomUUID().toString();
        String depIdRestored = UUID.randomUUID().toString();
        String verIdDraft = this.prepareDeploymentUnitDraft(depIdDraft, Collections.singleton(DeploymentUnitTestUtils.mavenTestArtifact()));
        String verIdRestored = this.prepareDeployedDeploymentUnit(depIdRestored, DeploymentUnitTestUtils.mavenTestArtifact());
        TestUtils.assertWithPoll(() -> {
            List units = this.deploymentSpi.units();
            if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.AVAILABLE.equals(arg_0))) {
                return false;
            }
            Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depIdDraft, verIdDraft, null, DeploymentUnitStatus.DRAFT}), Assertions.tuple((Object[])new Object[]{depIdRestored, verIdRestored, 1, DeploymentUnitStatus.AVAILABLE})});
            return true;
        });
        IgniteEx igniteSecond = this.startGrid(this.clusterSize());
        TestUtils.assertWithPoll(() -> {
            List units = this.deploymentSpi.units();
            if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.RETIRING.equals(arg_0))) {
                return false;
            }
            Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "version", "status"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depIdRestored, 1, DeploymentUnitStatus.RETIRING}), Assertions.tuple((Object[])new Object[]{depIdRestored, 2, DeploymentUnitStatus.AVAILABLE}), Assertions.tuple((Object[])new Object[]{depIdDraft, null, DeploymentUnitStatus.DRAFT})});
            return true;
        });
        TestUtils.assertWithPoll(() -> {
            List units = ((ManagedDeploymentSpi)igniteSecond.configuration().getDeploymentSpi()).units();
            if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.AVAILABLE.equals(arg_0))) {
                return false;
            }
            Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "version", "status"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depIdRestored, 2, DeploymentUnitStatus.AVAILABLE}), Assertions.tuple((Object[])new Object[]{depIdDraft, null, DeploymentUnitStatus.DRAFT})});
            return true;
        });
        this.startClient();
        TestUtils.assertWithPoll(() -> {
            List units = this.deploymentSpi.units();
            if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.RETIRING.equals(arg_0))) {
                return false;
            }
            Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "version", "status"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depIdRestored, 1, DeploymentUnitStatus.RETIRING}), Assertions.tuple((Object[])new Object[]{depIdRestored, 2, DeploymentUnitStatus.RETIRING}), Assertions.tuple((Object[])new Object[]{depIdRestored, 3, DeploymentUnitStatus.AVAILABLE}), Assertions.tuple((Object[])new Object[]{depIdDraft, null, DeploymentUnitStatus.DRAFT})});
            return true;
        });
        TestUtils.assertWithPoll(() -> {
            List units = ((ManagedDeploymentSpi)igniteSecond.configuration().getDeploymentSpi()).units();
            if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.AVAILABLE.equals(arg_0))) {
                return false;
            }
            Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "version", "status"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depIdRestored, 3, DeploymentUnitStatus.AVAILABLE}), Assertions.tuple((Object[])new Object[]{depIdRestored, 2, DeploymentUnitStatus.RETIRING}), Assertions.tuple((Object[])new Object[]{depIdDraft, null, DeploymentUnitStatus.DRAFT})});
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRedeployOnClusterRestart() throws Exception {
        String brokenArtifact = "org.apache.ignite:ignite-extdata-p2p:2.9.0INVALID_NAME";
        String depId = UUID.randomUUID().toString();
        this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        String verIdDeployed = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        this.prepareFailedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.EXTERNAL_LINK, brokenArtifact));
        this.stopAllGrids();
        IgniteConfiguration cfg0 = this.getConfiguration(this.instanceName(0));
        ManagedDeploymentSpi spy = (ManagedDeploymentSpi)Mockito.spy((Object)cfg0.getDeploymentSpi());
        ((ManagedDeploymentSpi)Mockito.doAnswer((Answer)new DelayAfterCall(1000L)).when((Object)spy)).deployLocal(ArgumentMatchers.anyString(), (DeploymentUnitVersionConfiguration)ArgumentMatchers.any());
        cfg0.setDeploymentSpi((DeploymentSpi)spy);
        System.setProperty("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK", "true");
        try (IgniteEx ignite = this.startGrid(cfg0);){
            TestUtils.assertWithPoll(() -> {
                List units = ((ManagedDeploymentSpi)ignite.configuration().getDeploymentSpi()).units();
                if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.AVAILABLE.equals(arg_0))) {
                    return false;
                }
                Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, verIdDeployed, 2, DeploymentUnitStatus.AVAILABLE})});
                return true;
            });
            try (IgniteEx ignite1 = this.startGrid(1);){
                TestUtils.assertWithPoll(() -> {
                    List units = ((ManagedDeploymentSpi)ignite.configuration().getDeploymentSpi()).units();
                    if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.AVAILABLE.equals(arg_0))) {
                        return false;
                    }
                    Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, 2, DeploymentUnitStatus.RETIRING}), Assertions.tuple((Object[])new Object[]{depId, 4, DeploymentUnitStatus.AVAILABLE})});
                    Assert.assertNotNull((Object)((ManagedDeploymentSpi)ignite1.configuration().getDeploymentSpi()).findResource(TEST_TASK));
                    return true;
                });
            }
        }
        finally {
            System.clearProperty("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK");
        }
    }

    @Test
    public void shouldRestartNodeWhenArtifactIsUnavailable() throws Exception {
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        this.stopAllGrids();
        ((RepositorySystem)Mockito.doAnswer(invocation -> {
            throw new ConnectException("TestException");
        }).when((Object)this.repoSys)).resolveArtifact((RepositorySystemSession)ArgumentMatchers.any(), (ArtifactRequest)ArgumentMatchers.any());
        IgniteEx ignite = this.startGrid(0);
        TestUtils.assertWithPoll(() -> {
            List units = ((ManagedDeploymentSpi)ignite.configuration().getDeploymentSpi()).units();
            Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, verId, 1, DeploymentUnitStatus.FAILED_TO_DEPLOY})});
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeployDownloadingVersionOnNodeJoin() throws Exception {
        CountDownLatch awaitOnEnterToResolveArtifactMtd = new CountDownLatch(3);
        CountDownLatch blockingResolveArtifactMtdCall = new CountDownLatch(1);
        ((RepositorySystem)Mockito.doAnswer(invocation -> {
            awaitOnEnterToResolveArtifactMtd.countDown();
            U.awaitQuiet((CountDownLatch)blockingResolveArtifactMtdCall);
            return invocation.callRealMethod();
        }).when((Object)this.repoSys)).resolveArtifact((RepositorySystemSession)ArgumentMatchers.any(), (ArtifactRequest)ArgumentMatchers.any());
        try {
            String depId = UUID.randomUUID().toString();
            String verId = this.prepareDeploymentUnitDraft(depId, Collections.singleton(DeploymentUnitTestUtils.mavenTestArtifact()));
            this.deploymentSpi.deployOnCluster(depId, verId);
            TestUtils.assertWithPoll(() -> {
                List units = this.deploymentSpi.units();
                if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.DOWNLOADING.equals(arg_0))) {
                    return false;
                }
                Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, verId, 1, DeploymentUnitStatus.DOWNLOADING})});
                return true;
            });
            AtomicReference cliRef = new AtomicReference();
            Thread clientStart = new Thread(() -> cliRef.set(this.startClient()));
            clientStart.start();
            Thread nodeStart = new Thread(() -> this.startGrid(this.clusterSize()));
            nodeStart.start();
            awaitOnEnterToResolveArtifactMtd.await(30L, TimeUnit.SECONDS);
            blockingResolveArtifactMtdCall.countDown();
            TestUtils.assertWithPoll(() -> {
                List units = this.deploymentSpi.units();
                if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.AVAILABLE.equals(arg_0))) {
                    return false;
                }
                Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, verId, 1, DeploymentUnitStatus.AVAILABLE})});
                return true;
            });
            TestUtils.assertWithPoll(() -> {
                IgniteEx client = (IgniteEx)cliRef.get();
                if (client == null) {
                    return false;
                }
                List units = ((ManagedDeploymentSpi)client.configuration().getDeploymentSpi()).units();
                if (units.stream().map(ManagedDeploymentUnit::getStatus).noneMatch(arg_0 -> DeploymentUnitStatus.AVAILABLE.equals(arg_0))) {
                    return false;
                }
                Assertions.assertThat((List)units).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, verId, 1, DeploymentUnitStatus.AVAILABLE})});
                return true;
            });
        }
        finally {
            TestUtils.resetLatch(awaitOnEnterToResolveArtifactMtd);
            TestUtils.resetLatch(blockingResolveArtifactMtdCall);
        }
    }

    @Test
    public void shouldUpdateDeploymentUnitDraftArtifacts() throws Exception {
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeploymentUnitDraft(depId, Collections.emptyList());
        this.deploymentSpi.updateArtifacts(depId, verId, Collections.singleton(DeploymentUnitTestUtils.mavenTestArtifact()));
        TestUtils.assertWithPoll(() -> {
            ((ListAssert)Assertions.assertThat((List)this.deploymentSpi.readDeploymentUnitConfigs(depId)).usingRecursiveFieldByFieldElementComparator()).extracting(new String[]{"versionId", "version", "draft", "artifacts"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{verId, null, true, Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))})});
            return true;
        });
    }

    @Test
    public void shouldDeployDeploymentUnit() throws Exception {
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeploymentUnitDraft(depId, Collections.singleton(DeploymentUnitTestUtils.mavenTestArtifact()));
        this.deploymentSpi.deployOnCluster(depId, verId);
        TestUtils.assertWithPoll(() -> {
            List units = this.deploymentSpi.units();
            if (units.size() != 1) {
                return false;
            }
            ManagedDeploymentUnit unit = (ManagedDeploymentUnit)units.get(0);
            ClassLoader clsLdr = unit.classLoader();
            if (!(clsLdr instanceof URLClassLoader)) {
                return false;
            }
            URL[] urls = ((URLClassLoader)clsLdr).getURLs();
            return Objects.equals(depId, unit.getDeploymentId()) && unit.getStatus() == DeploymentUnitStatus.AVAILABLE && unit.getVersion() == 1 && clsLdr instanceof URLClassLoader && urls.length == 1 && urls[0].getPath().contains(".m2/repository/org/apache/ignite/ignite-extdata-p2p/2.9.0/ignite-extdata-p2p-2.9.0.jar");
        });
        List cfgs = this.deploymentSpi.readDeploymentUnitConfigs(depId);
        ((ListAssert)Assertions.assertThat((List)cfgs).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"createdAt", "deployedAt"})).contains((Object[])new DeploymentUnitVersionConfiguration[]{new DeploymentUnitVersionConfiguration().setVersion(Integer.valueOf(1)).setVersionId(verId).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(Collections.singletonMap(this.ignite(0).localNode().id(), new NodeVersionStatusDetails().setStatus(DeploymentUnitStatus.AVAILABLE)))});
    }

    @Test
    public void shouldDeployExternalLinkDeploymentUnitWithQueryString() throws Exception {
        String longQueryLink = "https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar?response-content-disposition=inline&X-Amz-Security-Token=IQoJb3JpZ1luX2VjEIb%2F%2F%2F%2F%2F%2F%2F%2F%2F%2FwEaCmV1LW5vcnRoLTEiSDBGAiEAyVkVwA6AAxDg0kFnKaJ38rQ0sm1jS9hssqJ6nJiV5B0CIQDEgV1TtncYX8M3hVGKIE7wU9BNPfLpRQPmuHUZmRZpSCqEAwjW%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F8BEAEaDDM5MTkzMjk0MzYxMyIMAD2yq%2Fwe6jrf%2FJySKtgC28BvQXtWHj3T6oiNFbHBX%2Be709sgDLFHjXZ744nN9spVs4ZO9F0ozt37Ts7a4dJnZ%2F0PCWclkTnZrWHrUKm9cwnLUIoLARIeQ5sp5v2J4GZwNBWqRha3jooeSMCIAdlpORzSe%2BXQ1hb6oVofdcLTFU7MGJPTIUbVqKgtqdeSu8ik3v4D2HQjHXpwdK8bea1Vsmm0MLGZUnezIZBMHXQsdYGK%2BoMGGhjGQz7srvGvzLjvkBE8bV58ACyINH2zRF0Pd6rO2JVVT8XLfG44X7Dmv0Y6Ff3qQnZSfJg1GovYK%2BnRFqTqa5gWioMXdU9SsRWvOLFPrIFgXnXDuIThNZfVpXJ0PP5u%2B9yuUF5OkLRI4wJfATC30bNmdwk2frpfWCh9rraiFbe6kctWiIUJhRdE%2FSOK92v2wyMwlI9R3ZVw38Iho%2F52CCCsvYkY%2FSXk9BbSkdnUVBa19aYwhraDlwY6sgJUYV67z%1BsvarlU4pD5612H8zhZiNBgzpwClnGCpb3tq%2F6OkKB%2F7%2BrCQ9OxLhf0srfXzuPTCHLZmE2nrsKKIGIdT9SVd8eO1uG3C5UJgC%2BXfNeIg5o0ufiLd6C62NFslyVhckqsKpWSsxnBgU61mHnTtOGlVA8fcNehV8a0IbWWl6dJmw2jCIumQaurtAFYpfjxaJHtjj5sT8uXkSyXxNMhTxq2n9%2BTCBrgnJOIm2KMMn8e%2Fp5nTiTIN9X8cXYtElpf%2F62ZfxOx9mvSKOkGTWwQoP88F8IwQgj3DeeWnNrT0AlockO04RGDKlKkssZ0Zw9yDv9JYbNnefVP6zDvr4GrPpKM7KXIeJQo%2BTcKO%2FYuOdn88OEhrbp6V28R2c0MNuLvHDGbzWmjxZ7LfKayw4YoAbg%3D&X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Date=20210727T062939Z&X-Amz-SignedHeaders=host&X-Amz-Expires=0&X-Amz-Credential=ASIAVVQIGDT5WREPKOPQ%2F20220727%2Fus-west-1%2Fs3%2Faws4_request&X-Amz-Sydnay=1eF7374fSc0d7af15fe01c857544958dG45693572782811f108a8fFcea596dd0";
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.EXTERNAL_LINK, longQueryLink));
        List cfgs = this.deploymentSpi.readDeploymentUnitConfigs(depId);
        ((ListAssert)Assertions.assertThat((List)cfgs).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"createdAt", "deployedAt"})).contains((Object[])new DeploymentUnitVersionConfiguration[]{new DeploymentUnitVersionConfiguration().setVersion(Integer.valueOf(1)).setVersionId(verId).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate(longQueryLink))).setStatusDetails(Collections.singletonMap(this.ignite(0).localNode().id(), new NodeVersionStatusDetails().setStatus(DeploymentUnitStatus.AVAILABLE)))});
    }

    @Test
    public void shouldDeployLatestDeploymentUnitArtifacts() throws Exception {
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeploymentUnitDraft(depId, Collections.singleton(DeploymentUnitTestUtils.externalTestArtifact()));
        this.deploymentSpi.updateArtifacts(depId, verId, Collections.singleton(DeploymentUnitTestUtils.mavenTestArtifact()));
        this.deploymentSpi.deployOnCluster(depId, verId);
        TestUtils.assertWithPoll(() -> {
            List units = this.deploymentSpi.units();
            if (units.size() != 1) {
                return false;
            }
            ManagedDeploymentUnit unit = (ManagedDeploymentUnit)units.get(0);
            ClassLoader clsLdr = unit.classLoader();
            if (!(clsLdr instanceof URLClassLoader)) {
                return false;
            }
            URL[] urls = ((URLClassLoader)clsLdr).getURLs();
            return Objects.equals(depId, unit.getDeploymentId()) && unit.getStatus() == DeploymentUnitStatus.AVAILABLE && unit.getVersion() == 1 && clsLdr instanceof URLClassLoader && urls.length == 1 && urls[0].getPath().contains(".m2/repository/org/apache/ignite/ignite-extdata-p2p/2.9.0/ignite-extdata-p2p-2.9.0.jar");
        });
        List cfgs = this.deploymentSpi.readDeploymentUnitConfigs(depId);
        ((ListAssert)Assertions.assertThat((List)cfgs).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"createdAt", "deployedAt"})).contains((Object[])new DeploymentUnitVersionConfiguration[]{new DeploymentUnitVersionConfiguration().setVersion(Integer.valueOf(1)).setVersionId(verId).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(Collections.singletonMap(this.ignite(0).localNode().id(), new NodeVersionStatusDetails().setStatus(DeploymentUnitStatus.AVAILABLE)))});
    }

    @Test
    public void shouldCloneDeploymentUnitDraft() throws Exception {
        String depId = UUID.randomUUID().toString();
        String verIdOrig = this.prepareDeploymentUnitDraft(depId, Collections.singleton(DeploymentUnitTestUtils.mavenTestArtifact()));
        String verIdClone = this.deploymentSpi.clone(depId, verIdOrig);
        List cfgs = this.deploymentSpi.readDeploymentUnitConfigs(depId);
        ((ListAssert)Assertions.assertThat((List)cfgs).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"createdAt", "deployedAt"})).contains((Object[])new DeploymentUnitVersionConfiguration[]{new DeploymentUnitVersionConfiguration().setVersionId(verIdOrig).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))), new DeploymentUnitVersionConfiguration().setVersionId(verIdClone).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0")))});
    }

    @Test
    public void shouldCloneDeploymentUnit() throws Exception {
        String depId = UUID.randomUUID().toString();
        String verIdOrid = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        String verIdClone = this.deploymentSpi.clone(depId, verIdOrid);
        List cfgs = this.deploymentSpi.readDeploymentUnitConfigs(depId);
        ((ListAssert)Assertions.assertThat((List)cfgs).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"createdAt", "deployedAt"})).contains((Object[])new DeploymentUnitVersionConfiguration[]{new DeploymentUnitVersionConfiguration().setVersion(Integer.valueOf(1)).setVersionId(verIdOrid).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(Collections.singletonMap(this.ignite(0).localNode().id(), new NodeVersionStatusDetails().setStatus(DeploymentUnitStatus.AVAILABLE))), new DeploymentUnitVersionConfiguration().setVersionId(verIdClone).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0")))});
    }

    @Test
    public void shouldCloneFailedDeploymentUnit() throws Exception {
        String brokenArtifact = "org.apache.ignite:ignite-extdata-p2p:2.9.0INVALID_NAME";
        String depId = UUID.randomUUID().toString();
        String verIdOrig = this.prepareFailedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.MAVEN_ARTIFACT, brokenArtifact));
        String verIdClone = this.deploymentSpi.clone(depId, verIdOrig);
        List cfgs = this.deploymentSpi.readDeploymentUnitConfigs(depId);
        ((ListAssert)Assertions.assertThat((List)cfgs).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"createdAt", "deployedAt", "statusDetails"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitVersionConfiguration[]{new DeploymentUnitVersionConfiguration().setVersionId(verIdClone).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate(brokenArtifact))), new DeploymentUnitVersionConfiguration().setVersion(Integer.valueOf(1)).setVersionId(verIdOrig).setName(TEST_DU_NAME).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate(brokenArtifact)))});
    }

    @Test
    public void shouldRunDeployedTask() throws Exception {
        String depId = UUID.randomUUID().toString();
        this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        try (IgniteEx client = this.startClient();){
            Assert.assertNull((Object)client.compute().execute(TEST_TASK, (Object)this.ignite(0).localNode()));
        }
        client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));
        var3_3 = null;
        try {
            Assert.assertNull((Object)client.compute().execute(TEST_TASK, (Object)this.ignite(0).localNode()));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var3_3 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test
    public void shouldRunDeployedCallable() throws Exception {
        String depId = UUID.randomUUID().toString();
        this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        try (IgniteEx client = this.startClient();){
            Assert.assertEquals((long)42L, (long)((Integer)client.compute().call(call)).intValue());
        }
    }

    @Test
    public void shouldRunDeployedService() throws Exception {
        String depId = UUID.randomUUID().toString();
        this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        try (IgniteEx client = this.startClient();){
            client.services().deploy(new ServiceConfiguration().setName("no-op").setService(srvc).setTotalCount(2).setMaxPerNodeCount(1));
            Assert.assertNotNull((Object)this.ignite(0).services().service("no-op"));
        }
    }

    @Test
    public void shouldDeployUploadedArtifact() throws Exception {
        String depId = UUID.randomUUID().toString();
        this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.uploadedTestArtifact());
        try (IgniteEx client = this.startClient();){
            client.services().deploy(new ServiceConfiguration().setName("no-op").setService(srvc).setTotalCount(2).setMaxPerNodeCount(1));
            Assert.assertNotNull((Object)this.ignite(0).services().service("no-op"));
        }
    }

    @Test
    public void shouldRemoveDeploymentUnitVersions() throws Exception {
        String brokenArtifact = "org.apache.ignite:ignite-extdata-p2p:2.9.0INVALID_NAME";
        String depIdKept = UUID.randomUUID().toString();
        String depId = UUID.randomUUID().toString();
        String verIdKept = this.prepareDeploymentUnitDraft(depIdKept, Collections.emptyList());
        String verIdDraft = this.prepareDeploymentUnitDraft(depId, Collections.emptyList());
        String verIdFailed = this.prepareFailedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.EXTERNAL_LINK, brokenArtifact));
        String verIdAvailable = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        TestUtils.assertWithPoll(() -> Assertions.assertThat((List)this.deploymentSpi.units()).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depId, verIdFailed, 1, DeploymentUnitStatus.FAILED_TO_DEPLOY}), Assertions.tuple((Object[])new Object[]{depId, verIdAvailable, 2, DeploymentUnitStatus.AVAILABLE}), Assertions.tuple((Object[])new Object[]{depId, verIdDraft, null, DeploymentUnitStatus.DRAFT}), Assertions.tuple((Object[])new Object[]{depIdKept, verIdKept, null, DeploymentUnitStatus.DRAFT})}));
        File deployFolder = U.resolveWorkDirectory((String)this.deploymentSpi.ignite().configuration().getWorkDirectory(), (String)"deployment/managed", (boolean)false);
        File verIdAvailableDeployFolder = Paths.get(deployFolder.getAbsolutePath(), depId, verIdAvailable).toFile();
        Assert.assertTrue((boolean)verIdAvailableDeployFolder.exists());
        this.deploymentSpi.removeVersion(depId, Arrays.asList(verIdDraft, verIdAvailable, verIdFailed));
        TestUtils.assertWithPoll(() -> Assertions.assertThat((List)this.deploymentSpi.units()).extracting(new String[]{"deploymentId", "versionId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{depIdKept, verIdKept, null, DeploymentUnitStatus.DRAFT})}));
        Assert.assertNull((Object)this.ignite(0).context().distributedMetastorage().read(ManagedDeploymentSpi.makeMetastorageKey((String)depId)));
        System.gc();
        try (IgniteEx client = this.startClient();){
            TestUtils.assertThrows(() -> client.compute().execute(TEST_TASK, (Object)this.ignite(0).localNode()), IgniteDeploymentException.class, "Unknown task name or failed to auto-deploy task (was task (re|un)deployed?): org.apache.ignite.tests.p2p.CacheDeploymentTestTask2");
        }
        Assert.assertFalse((boolean)verIdAvailableDeployFolder.exists());
    }

    @Test
    public void shouldRemoveDraftsValidly() throws Exception {
        String depId = UUID.randomUUID().toString();
        String verIdDraftKeep = this.prepareDeploymentUnitDraft(depId, Collections.emptyList());
        String verIdDraftRemoved = this.prepareDeploymentUnitDraft(depId, Collections.emptyList());
        TestUtils.assertWithPoll(() -> Assertions.assertThat((List)this.deploymentSpi.units()).extracting(new String[]{"versionId", "version", "status"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{verIdDraftRemoved, null, DeploymentUnitStatus.DRAFT}), Assertions.tuple((Object[])new Object[]{verIdDraftKeep, null, DeploymentUnitStatus.DRAFT})}));
        this.deploymentSpi.removeVersion(depId, Collections.singletonList(verIdDraftRemoved));
        TestUtils.assertWithPoll(() -> Assertions.assertThat((List)this.deploymentSpi.units()).extracting(new String[]{"versionId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{verIdDraftKeep, null, DeploymentUnitStatus.DRAFT})}));
    }

    @Test
    public void shouldUseLocalMavenRepositoryByDefault() throws Exception {
        Collection repos = this.deploymentSpi.readMavenRepositories();
        Assertions.assertThat((Collection)repos).contains((Object[])new MavenRepositoryConfiguration[]{ManagedDeploymentSpi.MAVEN_CENTRAL_REPOSITORY});
        String depId = UUID.randomUUID().toString();
        String verIdRemote = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        this.deploymentSpi.writeMavenRepositories(EMPTY_MAVEN_REPOSITORY_CONFIGS);
        repos = this.deploymentSpi.readMavenRepositories();
        Assertions.assertThat((Collection)repos).isEmpty();
        String verIdLoc = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        System.gc();
        TestUtils.assertWithPoll(() -> Assertions.assertThat((List)this.deploymentSpi.units()).extracting(new String[]{"versionId", "version", "status"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{verIdRemote, 1, DeploymentUnitStatus.DECOMMISSIONED}), Assertions.tuple((Object[])new Object[]{verIdLoc, 2, DeploymentUnitStatus.AVAILABLE})}));
        try (IgniteEx client = this.startClient();){
            Assert.assertNull((Object)client.compute().execute(TEST_TASK, (Object)this.ignite(0).localNode()));
        }
    }

    @Test
    public void shouldDeployOnNodesWithManagedDeploymentSPI() throws Exception {
        String depId = UUID.randomUUID().toString();
        try (IgniteEx ignored = this.startGrid(this.getConfiguration("default").setDeploymentSpi(null));){
            this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.uploadedTestArtifact());
        }
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        return super.getConfiguration(igniteInstanceName).setDeploymentSpi((DeploymentSpi)new ManagedDeploymentSpi().setExcludedArtifacts(Arrays.asList("org.apache.ignite:ignite-core", "org.apache.ignite:ignite-ml", "junit:junit"))).setClientConnectorConfiguration(new ClientConnectorConfiguration().setThinClientConfiguration(new ThinClientConfiguration().setMaxActiveComputeTasksPerConnection(100)));
    }

    private String prepareDeployedDeploymentUnit(String depId, org.gridgain.control.agent.dto.action.deployment.ArtifactRequest ... artifacts) throws Exception {
        return this.deployDeploymentUnit0(depId, DeploymentUnitStatus.AVAILABLE, artifacts);
    }

    private String prepareFailedDeploymentUnit(String depId, org.gridgain.control.agent.dto.action.deployment.ArtifactRequest ... artifacts) throws Exception {
        return this.deployDeploymentUnit0(depId, DeploymentUnitStatus.FAILED_TO_DEPLOY, artifacts);
    }

    private String deployDeploymentUnit0(String depId, DeploymentUnitStatus goalStatus, org.gridgain.control.agent.dto.action.deployment.ArtifactRequest ... artifacts) throws Exception {
        assert (artifacts.length > 0);
        String verId = this.prepareDeploymentUnitDraft(depId, Arrays.asList(artifacts));
        this.deploymentSpi.deployOnCluster(depId, verId);
        TestUtils.assertWithPoll(() -> {
            List units = this.deploymentSpi.units();
            return units.stream().anyMatch(unit -> Objects.equals(verId, unit.getVersionId()) && unit.getStatus() == goalStatus);
        });
        return verId;
    }

    private String prepareDeploymentUnitDraft(String depId, Collection<org.gridgain.control.agent.dto.action.deployment.ArtifactRequest> artifacts) throws Exception {
        String verId = this.deploymentSpi.createDraft(depId, TEST_DU_NAME);
        TestUtils.assertWithPoll(() -> this.deploymentSpi.units().stream().anyMatch(unit -> Objects.equals(verId, unit.getVersionId()) && DeploymentUnitStatus.DRAFT == unit.getStatus()));
        if (!F.isEmpty(artifacts)) {
            this.deploymentSpi.updateArtifacts(depId, verId, artifacts);
        }
        return verId;
    }

    private <T> T stubForBlockingResolveArtifactMethod(T instance) {
        if (instance instanceof RepositorySystem) {
            return (T)this.repoSys;
        }
        return instance;
    }

    private static class DelayAfterCall
    implements Answer<Object> {
        private final long sleepyTime;

        public DelayAfterCall(long sleepyTime) {
            this.sleepyTime = sleepyTime;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Object val = invocation.callRealMethod();
            U.sleep((long)this.sleepyTime);
            return val;
        }
    }
}

