/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.deployment;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.ignite.spi.deployment.local.LocalDeploymentSpi;
import org.gridgain.control.agent.AbstractSelfTest;
import org.gridgain.control.agent.processor.deployment.ManagedDeploymentSpi;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.ListeningTestLogger;
import org.gridgain.control.agent.utils.LogListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ManagedAndLocalMixTest
extends AbstractSelfTest {
    @Parameterized.Parameter
    public DeploymentSpi spi1;
    @Parameterized.Parameter(value=1)
    public DeploymentSpi spi2;
    @Parameterized.Parameter(value=2)
    public boolean isSecondClient;
    @Parameterized.Parameter(value=3)
    public boolean firstWarns;
    @Parameterized.Parameter(value=4)
    public boolean secondFails;

    @Parameterized.Parameters(name="spi1={0}, spi2={1}, isSecondClient={2}, firstWarns={3}, secondFails={4}")
    public static Collection<Object[]> testData() {
        return Arrays.asList({new LocalDeploymentSpi(), new ManagedDeploymentSpi(), false, false, true}, {new ManagedDeploymentSpi(), new LocalDeploymentSpi(), false, true, false}, {new LocalDeploymentSpi(), new ManagedDeploymentSpi(), true, false, false}, {new ManagedDeploymentSpi(), new LocalDeploymentSpi(), true, false, false});
    }

    @After
    public void tearDown() {
        this.stopAllGrids();
    }

    @Test
    public void testManagedAndLocalSpiMix() throws Exception {
        LogListener listener1 = LogListener.matches(">>> Remote SPI with the same name is not configured").build();
        LogListener listener2 = LogListener.matches(">>> Remote SPI with the same name is not configured").build();
        IgniteConfiguration cfg1 = this.getConfiguration("node1");
        cfg1.setGridLogger((IgniteLogger)new ListeningTestLogger(cfg1.getGridLogger(), listener1));
        cfg1.setDeploymentSpi(this.spi1);
        this.startGrid(cfg1);
        IgniteConfiguration cfg2 = this.getConfiguration("node2");
        cfg2.setGridLogger((IgniteLogger)new ListeningTestLogger(cfg2.getGridLogger(), listener2));
        cfg2.setDeploymentSpi(this.spi2);
        cfg2.setClientMode(this.isSecondClient);
        if (!this.secondFails) {
            IgniteEx ignite = this.startGrid(cfg2);
            Assert.assertEquals((long)2L, (long)ignite.cluster().nodes().size());
        } else {
            TestUtils.assertThrowsAnyCause(() -> this.startGrid(cfg2), IgniteSpiException.class, "Remote SPI with the same name is not configured");
        }
        Assert.assertEquals((Object)this.firstWarns, (Object)listener1.check());
        Assert.assertFalse((boolean)listener2.check());
    }
}

