/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.cache.CacheInfo;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Assert;
import org.junit.Test;

public class CacheChangesProcessorWithSnapshotsTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldSendCacheInfoAfterRestoreFromSnapshot() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            return actual != null && CU.cacheId((String)"test-cache") == actual.getCacheId() && !actual.isCreatedBySql();
        });
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(Collections.singleton("test-cache"), null);
        snapshotFut.get();
        cache.destroy();
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().noneMatch(i -> "test-cache".equals(i.getCacheName()));
        });
        gg.snapshot().restoreSnapshot(snapshotFut.snapshotOperation().snapshotId(), Collections.singleton("test-cache"), null).get();
        Assert.assertEquals((Object)2, (Object)cache.get((Object)1));
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            return actual != null && CU.cacheId((String)"test-cache") == actual.getCacheId() && !actual.isCreatedBySql();
        });
    }

    @Test
    public void shouldSendCacheInfoAfterRestoreFromSnapshotWithCache() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            return actual != null && CU.cacheId((String)"test-cache") == actual.getCacheId() && !actual.isCreatedBySql();
        });
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(Collections.singleton("test-cache"), null);
        snapshotFut.get();
        cache.put((Object)1, (Object)3);
        Assert.assertEquals((Object)3, (Object)cache.get((Object)1));
        gg.snapshot().restoreSnapshot(snapshotFut.snapshotOperation().snapshotId(), Collections.singleton("test-cache"), null).get();
        Assert.assertEquals((Object)2, (Object)cache.get((Object)1));
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            return actual != null && CU.cacheId((String)"test-cache") == actual.getCacheId() && !actual.isCreatedBySql();
        });
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
        return cfg;
    }
}

