/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.cache.CacheInfo;
import org.gridgain.control.agent.dto.cache.CacheSqlMetadata;
import org.gridgain.control.agent.dto.dr.FullStateDataReplicationStatus;
import org.gridgain.control.agent.dto.dr.IncrementalDataReplicationStatus;
import org.gridgain.control.agent.fixtures.Country;
import org.gridgain.control.agent.fixtures.CountryWithAnnotations;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.cache.dr.CacheDrPauseReason;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.memory.DrSenderInMemoryStore;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.GridPluginUtils;
import org.junit.Assert;
import org.junit.Test;

public class CacheChangesProcessorTest
extends AgentCommonAbstractTest {
    public static final String KEYSTORE_PASSWORD = "tde-password";
    public static final String KEYSTORE_PATH = IgniteUtils.resolveIgnitePath((String)"modules/core/src/test/resources/tde.jks").getAbsolutePath();

    @Test
    public void shouldSendInitialStates() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> CU.isSystemCache((String)i.getCacheName())});
            return cacheInfos.size() == 1 && actual != null && actual.isSystemCache();
        });
        TestUtils.assertWithPoll(() -> this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id())) != null);
    }

    @Test
    public void shouldSendValidCacheInfo() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        this.createCache((Ignite)ignite, "test-cache");
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((long)CU.cacheId((String)"test-cache"), (long)actual.getCacheId());
            Assert.assertFalse((boolean)actual.isSystemCache());
            Assert.assertFalse((boolean)actual.isCreatedBySql());
            Assert.assertEquals((Object)CacheMode.PARTITIONED, (Object)actual.getMode());
            Assert.assertEquals((Object)CacheAtomicityMode.ATOMIC, (Object)actual.getAtomicityMode());
            Assert.assertFalse((boolean)actual.getStatisticsEnabled());
            Assert.assertFalse((boolean)actual.getEncryptionEnabled());
            Assert.assertNull((Object)actual.getDrSenderGroupName());
            Assert.assertNull((Object)actual.getIncrementalDataReplicationStatus());
            Assert.assertNull((Object)actual.getIncrementalDataReplicationStatusReason());
            Assert.assertNull((Object)actual.getFullStateDataReplicationStatus());
        });
        ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE mc_agent_test_table_1 (id int, value int, PRIMARY KEY (id));"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_1".equals(i.getCacheName())});
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((long)CU.cacheId((String)"SQL_PUBLIC_MC_AGENT_TEST_TABLE_1"), (long)actual.getCacheId());
            Assert.assertFalse((boolean)actual.isSystemCache());
            Assert.assertTrue((boolean)actual.isCreatedBySql());
            Assert.assertEquals((Object)CacheMode.PARTITIONED, (Object)actual.getMode());
            Assert.assertEquals((Object)CacheAtomicityMode.ATOMIC, (Object)actual.getAtomicityMode());
            Assert.assertFalse((boolean)actual.getStatisticsEnabled());
            Assert.assertFalse((boolean)actual.getEncryptionEnabled());
            Assert.assertNull((Object)actual.getDrSenderGroupName());
            Assert.assertNull((Object)actual.getIncrementalDataReplicationStatus());
            Assert.assertNull((Object)actual.getIncrementalDataReplicationStatusReason());
            Assert.assertNull((Object)actual.getFullStateDataReplicationStatus());
        });
    }

    @Test
    public void shouldSendCacheInfoOnCreatedOrDestroyedCache() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().anyMatch(i -> "test-cache".equals(i.getCacheName()));
        });
        cache.destroy();
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().noneMatch(i -> "test-cache".equals(i.getCacheName()));
        });
    }

    @Test
    public void shouldSendCacheInfoIfCacheCreatedOnOtherNode() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        IgniteEx ignite_2 = this.startGrid(0);
        IgniteCache cache = this.createCache((Ignite)ignite_2, "test-cache-1");
        cache.put((Object)1, (Object)2);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().anyMatch(i -> "test-cache-1".equals(i.getCacheName()));
        });
        cache.destroy();
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().noneMatch(i -> "test-cache-1".equals(i.getCacheName()));
        });
    }

    @Test
    public void shouldSendCacheInfoOnCreatedOrDestroyedCacheFromSql() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE mc_agent_test_table_1 (id int, value int, PRIMARY KEY (id));"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().anyMatch(i -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_1".equals(i.getCacheName()));
        });
        ignite.context().query().querySqlFields(new SqlFieldsQuery("DROP TABLE mc_agent_test_table_1;"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().noneMatch(i -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_1".equals(i.getCacheName()));
        });
    }

    @Test
    public void shouldSendCacheMetadataOnAlterTableAndCreateIndex() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE mc_agent_test_table_2 (id int, value int, PRIMARY KEY (id));"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheSqlMetadata> metadata = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id()), CacheSqlMetadata.class);
            if (F.isEmpty(metadata)) {
                return false;
            }
            CacheSqlMetadata cacheMeta = metadata.stream().filter(m -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_2".equals(m.getCacheName())).findFirst().get();
            Map fields = cacheMeta.getFields();
            return fields.containsKey("ID") && fields.containsKey("VALUE");
        });
        ignite.context().query().querySqlFields(new SqlFieldsQuery("ALTER TABLE mc_agent_test_table_2 ADD id_2 int;"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheSqlMetadata> metadata = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id()), CacheSqlMetadata.class);
            if (F.isEmpty(metadata)) {
                return false;
            }
            CacheSqlMetadata cacheMeta = metadata.stream().filter(m -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_2".equals(m.getCacheName())).findFirst().get();
            Map fields = cacheMeta.getFields();
            return fields.containsKey("ID") && fields.containsKey("VALUE") && fields.containsKey("ID_2");
        });
    }

    @Test
    public void shouldSendCacheMetadataOnCreateAndDropIndex() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE mc_agent_test_table_3 (id int, value int, PRIMARY KEY (id));"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheSqlMetadata> metadata = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id()), CacheSqlMetadata.class);
            if (F.isEmpty(metadata)) {
                return false;
            }
            CacheSqlMetadata cacheMeta = metadata.stream().filter(m -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_3".equals(m.getCacheName())).findFirst().get();
            List idxes = cacheMeta.getIndexes();
            return idxes.isEmpty();
        });
        ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE INDEX my_index ON mc_agent_test_table_3 (value)"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheSqlMetadata> metadata = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id()), CacheSqlMetadata.class);
            if (F.isEmpty(metadata)) {
                return false;
            }
            CacheSqlMetadata cacheMeta = metadata.stream().filter(m -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_3".equals(m.getCacheName())).findFirst().get();
            List idxes = cacheMeta.getIndexes();
            return idxes.size() == 1;
        });
        ignite.context().query().querySqlFields(new SqlFieldsQuery("DROP INDEX my_index;"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheSqlMetadata> metadata = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id()), CacheSqlMetadata.class);
            if (F.isEmpty(metadata)) {
                return false;
            }
            CacheSqlMetadata cacheMeta = metadata.stream().filter(m -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_3".equals(m.getCacheName())).findFirst().get();
            List idxes = cacheMeta.getIndexes();
            return idxes.isEmpty();
        });
    }

    @Test
    public void shouldSendSqlMetadataForCacheCreatedByCacheConfiguration() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        ignite.getOrCreateCache(this.getCountryCacheConfig());
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().anyMatch(i -> "Country".equals(i.getCacheName()));
        });
        TestUtils.assertWithPoll(() -> {
            List<CacheSqlMetadata> metadata = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id()), CacheSqlMetadata.class);
            if (F.isEmpty(metadata)) {
                return false;
            }
            CacheSqlMetadata cacheMeta = metadata.stream().filter(m -> "Country".equals(m.getCacheName())).findFirst().get();
            return "java.lang.Integer".equals(cacheMeta.getFields().get("ID")) && "java.lang.String".equals(cacheMeta.getFields().get("NAME")) && "java.lang.Integer".equals(cacheMeta.getFields().get("POPULATION"));
        });
    }

    @Test
    public void shouldSendSqlMetadataForCacheCreatedByCacheConfigurationWithAnnotations() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        ignite.getOrCreateCache(this.getCountryWithAnnotationsCacheConfig());
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().anyMatch(i -> "CountryWithAnnotations".equals(i.getCacheName()));
        });
        TestUtils.assertWithPoll(() -> {
            List<CacheSqlMetadata> metadata = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesSqlMetaDest((UUID)cluster.id()), CacheSqlMetadata.class);
            if (F.isEmpty(metadata)) {
                return false;
            }
            CacheSqlMetadata cacheMeta = metadata.stream().filter(m -> "CountryWithAnnotations".equals(m.getCacheName())).findFirst().get();
            return "java.lang.Integer".equals(cacheMeta.getFields().get("ID")) && "java.lang.String".equals(cacheMeta.getFields().get("NAME")) && "java.lang.Integer".equals(cacheMeta.getFields().get("POPULATION")) && cacheMeta.getIndexes().size() == 1;
        });
    }

    @Test
    public void shouldSendCacheInfoIfReplicatedCacheCreatedOnOtherNode() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        IgniteEx ignite_2 = this.startGrid(0);
        IgniteCache cache = ignite_2.getOrCreateCache(this.cacheConfiguration("test-cache-1").setCacheMode(CacheMode.REPLICATED));
        cache.put((Object)1, (Object)2);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().anyMatch(i -> "test-cache-1".equals(i.getCacheName()) && CacheMode.REPLICATED == i.getMode());
        });
        cache.destroy();
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().noneMatch(i -> "test-cache-1".equals(i.getCacheName()));
        });
    }

    @Test
    public void shouldSendCacheInfoOnCreatedOrDestroyedReplicatedCacheFromSql() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE mc_agent_test_table_1 (id int, value int, PRIMARY KEY (id)) WITH \"template=replicated\";"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().anyMatch(i -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_1".equals(i.getCacheName()) && CacheMode.REPLICATED == i.getMode());
        });
        ignite.context().query().querySqlFields(new SqlFieldsQuery("DROP TABLE mc_agent_test_table_1;"), true);
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().noneMatch(i -> "SQL_PUBLIC_MC_AGENT_TEST_TABLE_1".equals(i.getCacheName()));
        });
    }

    @Test
    public void shouldNotSendCacheInfoForLocalCache() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((long)CU.cacheId((String)"test-cache"), (long)actual.getCacheId());
            Assert.assertFalse((boolean)actual.isSystemCache());
            Assert.assertFalse((boolean)actual.isCreatedBySql());
            Assert.assertEquals((Object)CacheMode.PARTITIONED, (Object)actual.getMode());
            Assert.assertEquals((Object)CacheAtomicityMode.ATOMIC, (Object)actual.getAtomicityMode());
        });
        ignite.getOrCreateCache(this.cacheConfiguration("local-cache").setCacheMode(CacheMode.LOCAL));
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((long)CU.cacheId((String)"test-cache"), (long)actual.getCacheId());
            Assert.assertFalse((boolean)actual.isSystemCache());
            Assert.assertFalse((boolean)actual.isCreatedBySql());
            Assert.assertEquals((Object)CacheMode.PARTITIONED, (Object)actual.getMode());
            Assert.assertEquals((Object)CacheAtomicityMode.ATOMIC, (Object)actual.getAtomicityMode());
            CacheInfo locCache = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "local-cache".equals(i.getCacheName())});
            Assert.assertNull((Object)locCache);
        });
        cache.destroy();
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            Assert.assertNull((Object)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())}));
            Assert.assertNull((Object)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "local-cache".equals(i.getCacheName())}));
        });
    }

    @Test
    public void shouldSendCacheInfoOnToggleStatistics() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        this.checkStatisticsEnabled(cluster.id(), false);
        cache.enableStatistics(true);
        this.checkStatisticsEnabled(cluster.id(), true);
        cache.enableStatistics(false);
        this.checkStatisticsEnabled(cluster.id(), false);
    }

    @Test
    public void shouldSendCacheInfoWithEncryptionEnabled() {
        KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
        encSpi.setKeyStorePath(KEYSTORE_PATH);
        encSpi.setKeyStorePassword(KEYSTORE_PASSWORD.toCharArray());
        IgniteEx ignite = this.startGrid(this.getConfiguration("default").setEncryptionSpi((EncryptionSpi)encSpi));
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        ignite.getOrCreateCache(this.cacheConfiguration("test-cache").setEncryptionEnabled(true));
        this.checkEncryptionEnabled(cluster.id(), true);
    }

    @Test
    public void shouldNotSendCacheInfoBeforeAttach() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.createCache((Ignite)ignite, "test-cache");
        Assert.assertThrows(ConditionTimeoutException.class, () -> TestUtils.assertWithPoll(() -> !this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class).isEmpty()));
    }

    @Test
    public void shouldSendCacheInfoIfDrEventWasTriggered() {
        IgniteConfiguration node1Cfg = this.getConfiguration("default");
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)node1Cfg).setDataCenterId((byte)15);
        IgniteEx ignite = this.startGrid(node1Cfg);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        DrSenderConfiguration sndCfg = new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)5).setReceiverAddresses(new String[]{"127.0.0.1"}).setStore((DrSenderStore)new DrSenderInMemoryStore())});
        IgniteConfiguration node2Cfg = this.getConfiguration(this.instanceName(0));
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)node2Cfg).setDataCenterId((byte)15).setDrSenderConfiguration(sndCfg);
        IgniteEx ignite2 = this.startGrid(node2Cfg);
        IgniteCache cache = ignite2.getOrCreateCache(this.cacheConfiguration("test-cache-1").setPluginConfigurations(new CachePluginConfiguration[]{new GridGainCacheConfiguration().setDrSenderConfiguration(new CacheDrSenderConfiguration())}));
        GridDr dr = ((GridGainImpl)ignite2.context().grid().plugin("GridGain")).dr();
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            Assert.assertFalse((boolean)cacheInfos.isEmpty());
            CacheInfo cacheInfo = cacheInfos.stream().filter(i -> "test-cache-1".equals(i.getCacheName())).findFirst().get();
            Assert.assertEquals((Object)"<default>", (Object)cacheInfo.getDrSenderGroupName());
            Assert.assertEquals((Object)IncrementalDataReplicationStatus.WORKING, (Object)cacheInfo.getIncrementalDataReplicationStatus());
            Assert.assertNull((Object)cacheInfo.getIncrementalDataReplicationStatusReason());
            Assert.assertNull((Object)cacheInfo.getFullStateDataReplicationStatus());
            Assert.assertEquals((long)-1L, (long)cacheInfo.getFullStateDataReplicationEntriesCount());
            Assert.assertEquals((long)-1L, (long)cacheInfo.getFullStateDataReplicationFinishTime());
        });
        int cacheEntriesCount = 10;
        for (int i = 0; i < cacheEntriesCount; ++i) {
            cache.put((Object)i, (Object)("value-" + i));
        }
        dr.stopReplication("test-cache-1");
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo cacheInfo = cacheInfos.stream().filter(i -> "test-cache-1".equals(i.getCacheName())).findFirst().get();
            Assert.assertEquals((Object)"<default>", (Object)cacheInfo.getDrSenderGroupName());
            Assert.assertEquals((Object)IncrementalDataReplicationStatus.STOPPED, (Object)cacheInfo.getIncrementalDataReplicationStatus());
            Assert.assertEquals((Object)CacheDrPauseReason.USER_REQUEST.name(), (Object)cacheInfo.getIncrementalDataReplicationStatusReason());
            Assert.assertNull((Object)cacheInfo.getFullStateDataReplicationStatus());
        });
        long beforeFstFinish = System.currentTimeMillis();
        dr.startReplication("test-cache-1");
        dr.stateTransfer("test-cache-1", new byte[]{24});
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            Optional<CacheInfo> cacheInfoOptional = cacheInfos.stream().filter(i -> "test-cache-1".equals(i.getCacheName())).filter(info -> info.getFullStateDataReplicationStatus() == FullStateDataReplicationStatus.WORKING).findFirst();
            if (!cacheInfoOptional.isPresent()) {
                return;
            }
            CacheInfo cacheInfo = cacheInfoOptional.get();
            System.out.println("<<<< " + cacheInfo);
            Assert.assertEquals((Object)"<default>", (Object)cacheInfo.getDrSenderGroupName());
            Assert.assertEquals((Object)IncrementalDataReplicationStatus.WORKING, (Object)cacheInfo.getIncrementalDataReplicationStatus());
            Assert.assertNull((Object)cacheInfo.getIncrementalDataReplicationStatusReason());
            Assert.assertEquals((Object)FullStateDataReplicationStatus.WORKING, (Object)cacheInfo.getFullStateDataReplicationStatus());
        });
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo cacheInfo = cacheInfos.stream().filter(i -> "test-cache-1".equals(i.getCacheName())).findFirst().get();
            System.out.println("<<<< " + cacheInfo);
            Assert.assertEquals((Object)"<default>", (Object)cacheInfo.getDrSenderGroupName());
            Assert.assertEquals((Object)IncrementalDataReplicationStatus.WORKING, (Object)cacheInfo.getIncrementalDataReplicationStatus());
            Assert.assertNull((Object)cacheInfo.getIncrementalDataReplicationStatusReason());
            Assert.assertNull((Object)cacheInfo.getFullStateDataReplicationStatus());
            Assert.assertEquals((long)cacheEntriesCount, (long)cacheInfo.getFullStateDataReplicationEntriesCount());
            Assert.assertTrue((cacheInfo.getFullStateDataReplicationFinishTime() >= beforeFstFinish ? 1 : 0) != 0);
        });
        dr.stopReplication("test-cache-1");
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo cacheInfo = cacheInfos.stream().filter(i -> "test-cache-1".equals(i.getCacheName())).findFirst().get();
            Assert.assertEquals((Object)"<default>", (Object)cacheInfo.getDrSenderGroupName());
            Assert.assertEquals((Object)IncrementalDataReplicationStatus.STOPPED, (Object)cacheInfo.getIncrementalDataReplicationStatus());
            Assert.assertEquals((Object)CacheDrPauseReason.USER_REQUEST.name(), (Object)cacheInfo.getIncrementalDataReplicationStatusReason());
            Assert.assertNull((Object)cacheInfo.getFullStateDataReplicationStatus());
        });
        cache.destroy();
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            return cacheInfos != null && cacheInfos.stream().noneMatch(i -> "test-cache-1".equals(i.getCacheName()));
        });
    }

    @Test
    public void shouldCorrectlyProcessFstStatistics() {
        IgniteConfiguration node1Cfg = this.getConfiguration("default");
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)node1Cfg).setDataCenterId((byte)15);
        IgniteEx ignite = this.startGrid(node1Cfg);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        DrSenderConfiguration sndCfg = new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)5).setReceiverAddresses(new String[]{"127.0.0.1"}).setStore((DrSenderStore)new DrSenderInMemoryStore())});
        IgniteConfiguration node2Cfg = this.getConfiguration(this.instanceName(0));
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)node2Cfg).setDataCenterId((byte)15).setDrSenderConfiguration(sndCfg);
        IgniteEx ignite2 = this.startGrid(node2Cfg);
        IgniteCache cache1 = ignite2.getOrCreateCache(this.cacheConfiguration("test-cache-1").setPluginConfigurations(new CachePluginConfiguration[]{new GridGainCacheConfiguration().setDrSenderConfiguration(new CacheDrSenderConfiguration())}));
        IgniteCache cache2 = ignite2.getOrCreateCache(this.cacheConfiguration("test-cache-2").setPluginConfigurations(new CachePluginConfiguration[]{new GridGainCacheConfiguration().setDrSenderConfiguration(new CacheDrSenderConfiguration())}));
        int cache1EntriesCount = 10;
        for (int i2 = 0; i2 < cache1EntriesCount; ++i2) {
            cache1.put((Object)i2, (Object)("value-" + i2));
        }
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            Assert.assertFalse((boolean)cacheInfos.isEmpty());
            CacheInfo cacheInfo1 = cacheInfos.stream().filter(i -> "test-cache-1".equals(i.getCacheName())).findFirst().get();
            CacheInfo cacheInfo2 = cacheInfos.stream().filter(i -> "test-cache-2".equals(i.getCacheName())).findFirst().get();
            Assert.assertEquals((long)-1L, (long)cacheInfo1.getFullStateDataReplicationEntriesCount());
            Assert.assertEquals((long)-1L, (long)cacheInfo1.getFullStateDataReplicationFinishTime());
            Assert.assertEquals((long)-1L, (long)cacheInfo2.getFullStateDataReplicationEntriesCount());
            Assert.assertEquals((long)-1L, (long)cacheInfo2.getFullStateDataReplicationFinishTime());
        });
        GridDr dr = ((GridGainImpl)ignite2.context().grid().plugin("GridGain")).dr();
        long beforeFst = System.currentTimeMillis();
        dr.stateTransfer("test-cache-1", new byte[]{24});
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
            CacheInfo cacheInfo1 = cacheInfos.stream().filter(i -> "test-cache-1".equals(i.getCacheName())).findFirst().get();
            Assert.assertNull((Object)cacheInfo1.getFullStateDataReplicationStatus());
            Assert.assertEquals((long)cache1EntriesCount, (long)cacheInfo1.getFullStateDataReplicationEntriesCount());
            Assert.assertTrue((cacheInfo1.getFullStateDataReplicationFinishTime() >= beforeFst ? 1 : 0) != 0);
        });
        List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)cluster.id()), CacheInfo.class);
        CacheInfo cacheInfo2 = cacheInfos.stream().filter(i -> "test-cache-2".equals(i.getCacheName())).findFirst().get();
        Assert.assertEquals((long)-1L, (long)cacheInfo2.getFullStateDataReplicationEntriesCount());
        Assert.assertEquals((long)-1L, (long)cacheInfo2.getFullStateDataReplicationFinishTime());
        cache1.destroy();
        cache2.destroy();
    }

    @Test
    public void shouldNotBlockSystemThreadPoolWithCacheInfoUpdates() {
        IgniteEx ignite1 = this.getSenderIgnite(1);
        this.getSenderIgnite(2);
        this.changeAgentConfiguration(ignite1);
        IgniteClusterEx cluster = ignite1.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> ignite1.cluster().state() == ClusterState.ACTIVE);
        ThreadPoolExecutor tp = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>());
        this.createCachesAsync(tp, ignite1, 0, 200);
        TestUtils.assertWithPoll(() -> tp.getQueue().isEmpty());
        this.createCachesAsync(tp, ignite1, 200, 300);
        ignite1.cluster().state(ClusterState.INACTIVE);
        TestUtils.assertWithPoll(() -> ignite1.cluster().state() == ClusterState.INACTIVE);
        ignite1.cluster().state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> ignite1.cluster().state() == ClusterState.ACTIVE);
        IgniteCache cache = ignite1.getOrCreateCache("simpleCache");
        cache.put((Object)1, (Object)2);
        Assert.assertSame((Object)2, (Object)cache.get((Object)1));
    }

    private void createCachesAsync(ThreadPoolExecutor tp, IgniteEx ignite1, int startIdx, int endIdx) {
        int i = startIdx;
        while (i < endIdx) {
            int cacheId = i++;
            tp.submit(() -> ignite1.getOrCreateCache(this.cacheConfiguration("test-cache-" + cacheId).setPluginConfigurations(new CachePluginConfiguration[]{new GridGainCacheConfiguration().setDrSenderConfiguration(new CacheDrSenderConfiguration())})));
        }
    }

    private IgniteEx getSenderIgnite(int instanceId) {
        DrSenderConfiguration sndCfg = new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)5).setReceiverAddresses(new String[]{"127.0.0.1"}).setStore((DrSenderStore)new DrSenderInMemoryStore())});
        IgniteConfiguration node2Cfg = this.getConfiguration(this.instanceName(instanceId));
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)node2Cfg).setDataCenterId((byte)15).setDrSenderConfiguration(sndCfg);
        return this.startGrid(node2Cfg);
    }

    private void checkStatisticsEnabled(UUID clusterId, boolean statisticsEnabled) {
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)clusterId), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)statisticsEnabled, (Object)actual.getStatisticsEnabled());
        });
    }

    private void checkEncryptionEnabled(UUID clusterId, boolean encryptionEnabled) {
        TestUtils.assertWithPoll(() -> {
            List<CacheInfo> cacheInfos = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterCachesInfoDest((UUID)clusterId), CacheInfo.class);
            CacheInfo actual = (CacheInfo)F.find(cacheInfos, null, (IgnitePredicate[])new IgnitePredicate[]{(P1 & Serializable)i -> "test-cache".equals(i.getCacheName())});
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)encryptionEnabled, (Object)actual.getEncryptionEnabled());
        });
    }

    private CacheConfiguration<Integer, Country> getCountryCacheConfig() {
        CacheConfiguration ccfg = this.cacheConfiguration("Country");
        ccfg.setSqlSchema("Country");
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(Country.class.getName());
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        qryEntities.add(qryEntity);
        LinkedHashMap<String, String> qryFlds = new LinkedHashMap<String, String>();
        qryFlds.put("id", "java.lang.Integer");
        qryFlds.put("name", "java.lang.String");
        qryFlds.put("population", "java.lang.Integer");
        qryEntity.setFields(qryFlds);
        ccfg.setQueryEntities(qryEntities);
        return ccfg;
    }

    private CacheConfiguration<Integer, CountryWithAnnotations> getCountryWithAnnotationsCacheConfig() {
        return this.cacheConfiguration("CountryWithAnnotations").setSqlSchema("CountryWithAnnotations").setIndexedTypes(new Class[]{Integer.class, CountryWithAnnotations.class});
    }
}

