/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.config;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;

public class TestWebsocketDecoratedFactory
implements WebSocketHandlerDecoratorFactory {
    private static final Logger log = LoggerFactory.getLogger(TestWebsocketDecoratedFactory.class);
    private final Map<String, WebSocketSession> sessions = new HashMap<String, WebSocketSession>();
    private final Map<String, CloseStatus> closeStatuses = new HashMap<String, CloseStatus>();

    public WebSocketHandler decorate(WebSocketHandler hnd) {
        return new WebSocketHandlerDecorator(hnd){

            public void afterConnectionEstablished(WebSocketSession ses) throws Exception {
                TestWebsocketDecoratedFactory.this.sessions.put(ses.getId(), ses);
                super.afterConnectionEstablished(ses);
            }

            public void afterConnectionClosed(WebSocketSession ses, CloseStatus closeStatus) throws Exception {
                TestWebsocketDecoratedFactory.this.closeStatuses.put(ses.getId(), closeStatus);
                super.afterConnectionClosed(ses, closeStatus);
            }
        };
    }

    public void disconnectAllClients() {
        Iterator<Map.Entry<String, WebSocketSession>> it = this.sessions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, WebSocketSession> entry = it.next();
            try {
                entry.getValue().close(CloseStatus.NOT_ACCEPTABLE);
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
            it.remove();
        }
    }

    public int getConnectedSessionsCount() {
        return this.sessions.entrySet().size();
    }

    public Collection<CloseStatus> closeStatuses() {
        return this.closeStatuses.values();
    }
}

