/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.commandline;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.ConnectionAndSslParameters;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.commandline.ManagementArguments;
import org.gridgain.control.agent.commandline.ManagementCommand;
import org.gridgain.control.agent.commandline.ManagementCommandArgsParser;
import org.gridgain.control.agent.configuration.ControlCenterAgentConfiguration;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.transport.ws.StompRouter;
import org.gridgain.control.agent.transport.ws.WebSocketConnectionFactory;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ManagementCommandsTest
extends AgentCommonAbstractTest {
    private static final String KEY_STORE_PATH = "some/path/key-store.jks";
    private static final String STORE_TYPE = "jks";
    private static final String TRUST_STORE_PATH = "some/path/trust-store.jks";
    @Mock
    protected WebSocketConnectionFactory mgr;

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration("src/test/resources/ignite-cfg-without-agent.xml", instanceName);
    }

    @Test
    public void shouldPrintHelp() {
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(null);
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(6, "  management.(sh|bat) [--host HOST_OR_IP]"));
            Assert.assertTrue((boolean)hnd.startsWithAt(11, "    management.(sh|bat) --status"));
            Assert.assertTrue((boolean)hnd.startsWithAt(14, "    management.(sh|bat) --on"));
            Assert.assertTrue((boolean)hnd.startsWithAt(17, "    management.(sh|bat) --off"));
            Assert.assertTrue((boolean)hnd.startsWithAt(20, "    management.(sh|bat) --uri"));
            Assert.assertTrue((boolean)hnd.startsWithAt(23, "    management.(sh|bat) --token"));
        });
    }

    @Test
    public void shouldToggleAgentState() {
        this.startGrid();
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Collections.singletonList("--status"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--status] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --status "));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            hnd.clear();
            res = cmd.execute(Arrays.asList("--uri", "http://localhost", "--management-cipher-suites", "CIPHER_1,CIPHER_2", "--management-keystore", KEY_STORE_PATH, "--management-keystore-type", STORE_TYPE, "--management-keystore-password", "KEYSTORE_PASSWORD", "--management-truststore", TRUST_STORE_PATH, "--management-truststore-type", STORE_TYPE, "--management-truststore-password", "TRUSTSTORE_PASSWORD", "--management-session-timeout", "1", "--management-session-expiration-timeout", "100"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--uri] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --uri "));
            Assert.assertTrue((boolean)hnd.containsAt(5, "--management-keystore-password *****"));
            Assert.assertTrue((boolean)hnd.containsAt(5, "--management-truststore-password *****"));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            Assert.assertTrue((boolean)hnd.startsWithAt(9, "Connection status: connecting"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store type             | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | some/path/key-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store type           | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | some/path/trust-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center cipher suites              | 1: CIPHER_1"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "                                          | 2: CIPHER_2"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | 1ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | 100ms"));
            hnd.clear();
            res = cmd.execute(Collections.singletonList("--off"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--off] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --off"));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: disabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store type             | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | some/path/key-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store type           | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | some/path/trust-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center cipher suites              | 1: CIPHER_1"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "                                          | 2: CIPHER_2"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | 1ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | 100ms"));
            hnd.clear();
            cmd.execute(Collections.singletonList("--status"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--status] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --status"));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: disabled"));
            Assert.assertTrue((boolean)hnd.startsWithAt(9, "Connection status: disconnected"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store type             | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | some/path/key-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store type           | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | some/path/trust-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center cipher suites              | 1: CIPHER_1"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "                                          | 2: CIPHER_2"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | 1ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | 100ms"));
            hnd.clear();
            res = cmd.execute(Collections.singletonList("--on"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--on] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --on"));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            Assert.assertTrue((boolean)hnd.startsWithAt(9, "Connection status: connecting"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store type             | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | some/path/key-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store type           | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | some/path/trust-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center cipher suites              | 1: CIPHER_1"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "                                          | 2: CIPHER_2"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | 1ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | 100ms"));
            hnd.clear();
            cmd.execute(Collections.singletonList("--status"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--status] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --status"));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            Assert.assertTrue((boolean)hnd.startsWithAt(9, "Connection status: connecting"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store type             | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | some/path/key-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store type           | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | some/path/trust-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center cipher suites              | 1: CIPHER_1"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "                                          | 2: CIPHER_2"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | 1ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | 100ms"));
        });
    }

    @Test
    public void shouldNotReconnectAfterMiscChanges() {
        this.startGrid();
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Collections.singletonList("--status"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--status] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --status "));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            hnd.clear();
            ArrayList<String> args = new ArrayList<String>(Arrays.asList("--uri", "http://localhost", "--management-cipher-suites", "CIPHER_1,CIPHER_2", "--management-keystore", KEY_STORE_PATH, "--management-keystore-type", STORE_TYPE, "--management-keystore-password", "KEYSTORE_PASSWORD", "--management-truststore", TRUST_STORE_PATH, "--management-truststore-type", STORE_TYPE, "--management-truststore-password", "TRUSTSTORE_PASSWORD"));
            res = cmd.execute(args);
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center query idle timeout         | " + AgentUtils.timeout((long)300000L)));
            hnd.clear();
            Mockito.reset((Object[])new WebSocketConnectionFactory[]{this.mgr});
            args.add("--management-session-timeout");
            args.add("1");
            args.add("--management-session-expiration-timeout");
            args.add("100");
            args.add("--query-idle-timeout");
            args.add("200");
            res = cmd.execute(args);
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center query idle timeout         | 200ms"));
            try {
                ((WebSocketConnectionFactory)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.never())).connect((URI)ArgumentMatchers.any(), (ControlCenterAgentConfiguration)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (StompRouter)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Test
    public void shouldChangeAgentConfiguration() {
        this.startGrid();
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Collections.singletonList("--status"));
            ControlCenterAgentConfiguration exp = new ControlCenterAgentConfiguration();
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost:3000"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | " + AgentUtils.timeout((long)exp.getSecuritySessionTimeout())));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | " + AgentUtils.timeout((long)exp.getSecuritySessionExpirationTimeout())));
            hnd.clear();
            res = cmd.execute(Arrays.asList("--uri", String.join((CharSequence)",", exp.getUris()), "--management-session-timeout", "0", "--management-session-expiration-timeout", "0", "--query-idle-timeout", "0"));
            Assert.assertEquals((long)0L, (long)res);
            exp.getUris().forEach(uri -> Assert.assertTrue((boolean)hnd.containsAt(10, (String)uri)));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | disabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | disabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | Unlimited"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | Unlimited"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center query idle timeout         | Unlimited"));
            hnd.clear();
            res = cmd.execute(Arrays.asList("--uri", "http://localhost:4000", "--management-cipher-suites", "CIPHER_1,CIPHER_2", "--management-keystore", KEY_STORE_PATH, "--management-keystore-password", "KEYSTORE_PASSWORD", "--management-session-timeout", "100", "--management-session-expiration-timeout", "200", "--query-idle-timeout", "300"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost:4000"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store type             | jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | some/path/key-store.jks"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | disabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center cipher suites              | 1: CIPHER_1"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "                                          | 2: CIPHER_2"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | 100ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | 200ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center query idle timeout         | 300ms"));
            hnd.clear();
            res = cmd.execute(Arrays.asList("--uri", "http://localhost:3000"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost:3000"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center key store                  | disabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center trust store                | disabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session timeout            | 100ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center session expiration timeout | 200ms"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "Control Center query idle timeout         | 300ms"));
        });
    }

    @Test
    public void shouldParseArguments() {
        this.parseArgs(Collections.singletonList("--status"));
        this.parseArgs(Collections.singletonList("--help"));
        ConnectionAndSslParameters args = this.parseArgs(Collections.singletonList("--on"));
        ManagementArguments arg = ((ManagementCommand)args.command()).arg();
        Assert.assertTrue((boolean)arg.enable());
        args = this.parseArgs(Collections.singletonList("--off"));
        arg = ((ManagementCommand)args.command()).arg();
        Assert.assertFalse((boolean)arg.enable());
        this.assertParseArgsThrows("Expected server URIs", "--uri");
        this.assertParseArgsThrows("Expected server URIs but got '--query-idle-timeout'", "--uri", "--query-idle-timeout");
        args = this.parseArgs(Arrays.asList("--uri", "http://localhost:3000"));
        arg = ((ManagementCommand)args.command()).arg();
        Assert.assertFalse((boolean)arg.enable());
        Assert.assertEquals(Collections.singletonList("http://localhost:3000"), (Object)arg.serverUris());
        this.assertParseArgsThrows("Invalid uri argument: --wrong", "--uri", "http://localhost", "--wrong");
        args = this.parseArgs(Arrays.asList("--uri", "http://localhost", "--management-cipher-suites", "CIPHER_1,CIPHER_2", "--management-keystore", KEY_STORE_PATH, "--management-keystore-password", "KEYSTORE_PASSWORD", "--management-truststore", TRUST_STORE_PATH, "--management-truststore-password", "TRUSTSTORE_PASSWORD", "--management-session-timeout", "1", "--management-session-expiration-timeout", "100", "--query-idle-timeout", "200"));
        arg = ((ManagementCommand)args.command()).arg();
        Assert.assertFalse((boolean)arg.enable());
        Assert.assertEquals(Collections.singletonList("http://localhost"), (Object)arg.serverUris());
        Assert.assertEquals(Arrays.asList("CIPHER_1", "CIPHER_2"), (Object)arg.cipherSuites());
        Assert.assertEquals((Object)KEY_STORE_PATH, (Object)arg.keyStore());
        Assert.assertEquals((Object)"KEYSTORE_PASSWORD", (Object)arg.keyStorePassword());
        Assert.assertEquals((Object)TRUST_STORE_PATH, (Object)arg.trustStore());
        Assert.assertEquals((Object)"TRUSTSTORE_PASSWORD", (Object)arg.trustStorePassword());
        Assert.assertEquals((long)1L, (long)arg.sessionTimeout());
        Assert.assertEquals((long)100L, (long)arg.sessionExpirationTimeout());
        Assert.assertEquals((long)200L, (long)arg.queryIdleTimeout());
        this.assertParseArgsThrows("Expecting session timeout", "--uri", "http://localhost", "--management-session-timeout");
        this.assertParseArgsThrows("Invalid value for session timeout: x", "--uri", "http://localhost", "--management-session-timeout", "x");
        this.assertParseArgsThrows("Expecting session expiration timeout", "--uri", "http://localhost", "--management-session-expiration-timeout");
        this.assertParseArgsThrows("Invalid value for session expiration timeout: x", "--uri", "http://localhost", "--management-session-expiration-timeout", "x");
        this.assertParseArgsThrows("Expecting query idle timeout", "--uri", "http://localhost", "--query-idle-timeout");
        this.assertParseArgsThrows("Invalid value for query idle timeout: x", "--uri", "http://localhost", "--query-idle-timeout", "x");
    }

    @Test
    public void shouldValidateServerUris() {
        this.parseArgs(Arrays.asList("--uri", "http://localhost:3000"));
        TestUtils.assertThrows(() -> this.parseArgs(Arrays.asList("--uri", "http:localhost:3000")), IllegalArgumentException.class);
        TestUtils.assertThrows(() -> this.parseArgs(Arrays.asList("--uri", "\\\\:localhost:3000")), IllegalArgumentException.class);
        TestUtils.assertThrows(() -> this.parseArgs(Arrays.asList("--uri", "http:localhost:")), IllegalArgumentException.class);
        TestUtils.assertThrows(() -> this.parseArgs(Arrays.asList("--uri", "")), IllegalArgumentException.class);
        TestUtils.assertThrows(() -> this.parseArgs(Arrays.asList("--uri", " ")), IllegalArgumentException.class);
    }

    @Test
    public void shouldGenerateToken() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite, true);
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Collections.singletonList("--token"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--token] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --token "));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Open the link in a browser to monitor your cluster:"));
            Assert.assertTrue((boolean)hnd.startsWithAt(11, "If you are already using Control Center, you can add the cluster manually using a one-time token:"));
            Assert.assertTrue((boolean)hnd.startsWithAt(14, "NOTE: the token will expire in 5 minutes."));
        });
    }

    @Test
    public void shouldThrowErrorOnTokenRequest() {
        this.startGrid();
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Collections.singletonList("--token"));
            Assert.assertEquals((long)5L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--token] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --token "));
            Assert.assertTrue((boolean)hnd.startsWithAt(7, "Failed to connect to the Control Center backend. Please check Control Center agent connection settings"));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Command [--token] finished with code: 5"));
        });
    }

    @Test
    public void shouldReconnectAfterConnectionIsChanged() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite, true);
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Collections.singletonList("--status"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--status] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --status "));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost:" + this.port));
            hnd.clear();
            res = cmd.execute(Arrays.asList("--uri", "http://127.0.0.1:" + this.port));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--uri] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --uri "));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://127.0.0.1:" + this.port));
            hnd.clear();
            res = cmd.execute(Collections.singletonList("--status"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--status] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --status "));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://127.0.0.1:" + this.port));
            hnd.clear();
            res = cmd.execute(Collections.singletonList("--token"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--token] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --token "));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Open the link in a browser to monitor your cluster:"));
            Assert.assertTrue((boolean)hnd.startsWithAt(9, "http://127.0.0.1:" + this.port + "/go/"));
            Assert.assertTrue((boolean)hnd.startsWithAt(11, "If you are already using Control Center, you can add the cluster manually using a one-time token:"));
            Assert.assertTrue((boolean)hnd.startsWithAt(14, "NOTE: the token will expire in 5 minutes."));
        });
    }

    @Test
    public void shouldCheckConnectionStatus() {
        IgniteEx ignite = this.startGrid();
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)ignite);
        agent.stop();
        this.createCmdHandler().forEach((cmd, hnd) -> {
            cmd.execute(Collections.singletonList("--status"));
            Assert.assertTrue((boolean)hnd.equalsAt(9, "Connection status: disconnected"));
            hnd.clear();
            int res = cmd.execute(Arrays.asList("--uri", this.buildControlCenterUri(false, false)));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.anyOfAt(9, "Connection status: connecting", "Connection status: connected"));
        });
    }

    @Test
    public void shouldShowStatusIfOldestNodeWithoutAgent() throws Exception {
        this.startNodeWithTestLoggerAndNoAgent(log -> {
            this.startGrid(1);
            this.createCmdHandler().forEach((cmd, hnd) -> {
                cmd.execute(Arrays.asList("--uri", "http://localhost:3000"));
                int res = cmd.execute(Collections.singletonList("--status"));
                Assert.assertEquals((long)0L, (long)res);
                Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
                Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost:3000"));
            });
        });
    }

    @Test
    public void shouldShowStatusIfOldestNodeIsClient() {
        this.startGrid(1);
        this.startClient();
        this.startGrid(3);
        this.stopGrid(1);
        this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Arrays.asList("--port", String.valueOf(11212), "--uri", "http://localhost:3000"));
            Assert.assertEquals((long)0L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Control Center: enabled"));
            Assert.assertTrue((boolean)hnd.containsAt(10, "URI(s) to Control Center                  | 1: http://localhost:3000"));
        });
    }

    @Test
    public void shouldShowHumanReadbleErrorIfNodeWithoutAgent() throws Exception {
        this.startNodeWithTestLoggerAndNoAgent(log -> this.createCmdHandler().forEach((cmd, hnd) -> {
            int res = cmd.execute(Arrays.asList("--uri", "http://localhost:3000"));
            Assert.assertEquals((long)5L, (long)res);
            Assert.assertTrue((boolean)hnd.startsWithAt(4, "Command [--uri] started"));
            Assert.assertTrue((boolean)hnd.startsWithAt(5, "Arguments: --uri http://localhost:3000"));
            Assert.assertTrue((boolean)hnd.startsWithAt(7, "Control Center Agent is missing. Please enable the module. For more details please read the following: https://www.gridgain.com/docs/control-center/latest/getting-started/connect/connect-gridgain-cluster"));
            Assert.assertTrue((boolean)hnd.startsWithAt(8, "Command [--uri] finished with code: 5"));
        }));
    }

    private ConnectionAndSslParameters parseArgs(List<String> args) {
        return new ManagementCommandArgsParser(CommandHandler.initLogger(null)).parseAndValidate(args.iterator());
    }

    private void assertParseArgsThrows(String failMsg, String ... args) {
        TestUtils.assertThrows(() -> this.parseArgs(Arrays.asList(args)), IllegalArgumentException.class, failMsg);
    }
}

