/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.gridgain.control.agent.action.annotation.ActionController;
import org.gridgain.control.agent.utils.AgentUtils;

@ActionController
public class TestActionControllerWithSecurity {
    private final GridKernalContext ctx;

    public TestActionControllerWithSecurity(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    public CompletableFuture<Void> adminAction() {
        AgentUtils.authorizeIfNeeded((IgniteSecurity)this.ctx.security(), (SecurityPermission)SecurityPermission.ADMIN_OPS);
        return CompletableFuture.completedFuture(null);
    }

    public String nodeIdAction() {
        AgentUtils.authorizeIfNeeded((IgniteSecurity)this.ctx.security(), (SecurityPermission)SecurityPermission.ADMIN_OPS);
        return this.ctx.grid().cluster().localNode().id().toString();
    }

    public String nodeIdActionWithSleep(long ms) throws InterruptedException {
        AgentUtils.authorizeIfNeeded((IgniteSecurity)this.ctx.security(), (SecurityPermission)SecurityPermission.ADMIN_OPS);
        Thread.sleep(ms);
        return this.ctx.grid().cluster().localNode().id().toString();
    }

    public void noopAction() {
    }
}

