/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Test;

public class ServiceActionControllerTest
extends AbstractActionControllerTest {
    @Test
    public void shouldSuccessfullyCancelServices() throws Exception {
        CountDownLatch serviceCancelLatches = new CountDownLatch(2);
        DummyService.cancelLatch("testService1", serviceCancelLatches);
        DummyService.cancelLatch("testService2", serviceCancelLatches);
        this.cluster.ignite().services().deployNodeSingletonAsync("testService1", (Service)new DummyService()).get();
        this.cluster.ignite().services().deployNodeSingletonAsync("testService2", (Service)new DummyService()).get();
        Assertions.assertThat((Collection)this.cluster.ignite().services().serviceDescriptors()).hasSize(2);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ServiceActions.stop").setArgument((Object)Lists.newArrayList((Object[])new String[]{"testService1", "testService2"}));
        this.executeAction(req, Duration.ofSeconds(20L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)serviceCancelLatches.await(5L, TimeUnit.SECONDS));
        Assertions.assertThat((Collection)this.cluster.ignite().services().serviceDescriptors()).isEmpty();
    }

    @Test
    public void shouldSkipToCancelNonExistingServices() throws Exception {
        CountDownLatch serviceCancelLatches = new CountDownLatch(1);
        DummyService.cancelLatch("testService1", serviceCancelLatches);
        DummyService.cancelLatch("testService2", serviceCancelLatches);
        this.cluster.ignite().services().deployNodeSingletonAsync("testService1", (Service)new DummyService()).get();
        this.cluster.ignite().services().deployNodeSingletonAsync("testService2", (Service)new DummyService()).get();
        Assertions.assertThat((Collection)this.cluster.ignite().services().serviceDescriptors()).hasSize(2);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ServiceActions.stop").setArgument((Object)Lists.newArrayList((Object[])new String[]{"testService1", "testService3"}));
        this.executeAction(req, Duration.ofSeconds(20L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)serviceCancelLatches.await(5L, TimeUnit.SECONDS));
        Assertions.assertThat((Collection)this.cluster.ignite().services().serviceDescriptors()).hasSize(1);
    }

    public static class DummyService
    implements Service {
        public static final ConcurrentMap<String, AtomicInteger> started = new ConcurrentHashMap<String, AtomicInteger>();
        public static final ConcurrentMap<String, AtomicInteger> inited = new ConcurrentHashMap<String, AtomicInteger>();
        private static final ConcurrentMap<String, CountDownLatch> exeLatches = new ConcurrentHashMap<String, CountDownLatch>();
        private static final ConcurrentMap<String, CountDownLatch> cancelLatches = new ConcurrentHashMap<String, CountDownLatch>();
        private static final ConcurrentMap<String, AtomicInteger> cancelled = new ConcurrentHashMap<String, AtomicInteger>();

        public void cancel(ServiceContext ctx) {
            AtomicInteger cntr = (AtomicInteger)cancelled.get(ctx.name());
            if (cntr == null) {
                cntr = new AtomicInteger();
                AtomicInteger old = cancelled.putIfAbsent(ctx.name(), cntr);
                if (old != null) {
                    cntr = old;
                }
            }
            cntr.incrementAndGet();
            CountDownLatch latch = (CountDownLatch)cancelLatches.get(ctx.name());
            if (latch != null) {
                latch.countDown();
            }
            System.out.println("Cancelling service: " + ctx.name());
        }

        public void init(ServiceContext ctx) throws Exception {
            AtomicInteger cntr = (AtomicInteger)inited.get(ctx.name());
            if (cntr == null) {
                cntr = new AtomicInteger();
                AtomicInteger old = inited.putIfAbsent(ctx.name(), cntr);
                if (old != null) {
                    cntr = old;
                }
            }
            cntr.incrementAndGet();
            System.out.println("Initializing service: " + ctx.name());
        }

        public void execute(ServiceContext ctx) {
            AtomicInteger cntr = (AtomicInteger)started.get(ctx.name());
            if (cntr == null) {
                cntr = new AtomicInteger();
                AtomicInteger old = started.putIfAbsent(ctx.name(), cntr);
                if (old != null) {
                    cntr = old;
                }
            }
            cntr.incrementAndGet();
            System.out.println("Executing service: " + ctx.name());
            CountDownLatch latch = (CountDownLatch)exeLatches.get(ctx.name());
            if (latch != null) {
                latch.countDown();
            }
        }

        public static int cancelled(String name) {
            AtomicInteger cntr = (AtomicInteger)cancelled.get(name);
            return cntr == null ? 0 : cntr.get();
        }

        public static int started(String name) {
            AtomicInteger cntr = (AtomicInteger)started.get(name);
            return cntr == null ? 0 : cntr.get();
        }

        public static void reset() {
            System.out.println("Resetting dummy service.");
            started.clear();
            exeLatches.clear();
            cancelled.clear();
        }

        public static void exeLatch(String name, CountDownLatch latch) {
            exeLatches.put(name, latch);
        }

        public static void cancelLatch(String name, CountDownLatch latch) {
            cancelLatches.put(name, latch);
        }
    }
}

