/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.impl.DefaultFtpServer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDeploymentException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.sshd.server.SshServer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.gridgain.control.agent.dto.action.deployment.CodeDeploymentIdRequest;
import org.gridgain.control.agent.dto.action.deployment.CodeDeploymentIdResponse;
import org.gridgain.control.agent.dto.action.deployment.CodeDeploymentIdsRequest;
import org.gridgain.control.agent.dto.action.deployment.CreateCodeDeploymentRequest;
import org.gridgain.control.agent.dto.action.deployment.DeploymentUnitResponse;
import org.gridgain.control.agent.dto.action.deployment.MavenRepositoryConfiguration;
import org.gridgain.control.agent.dto.action.deployment.NodeStatusDetailsResponse;
import org.gridgain.control.agent.dto.action.deployment.RenameDeploymentUnitArgument;
import org.gridgain.control.agent.dto.action.deployment.UpdateCodeDeploymentArtifactRequest;
import org.gridgain.control.agent.processor.deployment.Artifact;
import org.gridgain.control.agent.processor.deployment.ArtifactType;
import org.gridgain.control.agent.processor.deployment.DeploymentUnitStatus;
import org.gridgain.control.agent.processor.deployment.ManagedDeploymentSpi;
import org.gridgain.control.agent.test.DeploymentUnitTestUtils;
import org.gridgain.control.agent.test.TestServers;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public class CodeDeploymentActionsControllerTest
extends AbstractActionControllerTest {
    public static final String IGNITE_EXTDATA_P2P_2_10 = "ignite-extdata-p2p-2.10.0.jar";
    private static final String TEST_TASK = "org.apache.ignite.tests.p2p.CacheDeploymentTestTask2";
    private RepositorySystem repoSys = (RepositorySystem)Mockito.spy((Object)DeploymentUnitTestUtils.testRepositorySystem());
    @Value(value="classpath:/sftp/providers.xml")
    private Resource sftpCfgRsrc;

    @Override
    protected int clusterSize() {
        return 2;
    }

    @Override
    public void setup() throws Exception {
        IgnitionEx.dependencyResolver(this::stubForBlockingResolveArtifactMethod);
        super.setup();
    }

    @Override
    protected void cleanup() {
        Mockito.reset((Object[])new RepositorySystem[]{this.repoSys});
        super.cleanup();
        this.deleteDirectory("deployment/managed");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        return super.getConfiguration(igniteInstanceName).setDeploymentSpi((DeploymentSpi)new ManagedDeploymentSpi().setExcludedArtifacts(Arrays.asList("org.apache.ignite:ignite-core", "org.apache.ignite:ignite-ml", "junit:junit")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloading() throws Exception {
        CountDownLatch awaitOnEnterToResolveArtifactMtd = new CountDownLatch(2);
        CountDownLatch blockingResolveArtifactMtdCall = new CountDownLatch(1);
        ((RepositorySystem)Mockito.doAnswer(invocation -> {
            awaitOnEnterToResolveArtifactMtd.countDown();
            U.awaitQuiet((CountDownLatch)blockingResolveArtifactMtdCall);
            return invocation.callRealMethod();
        }).when((Object)this.repoSys)).resolveArtifact((RepositorySystemSession)ArgumentMatchers.any(), (ArtifactRequest)ArgumentMatchers.any());
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDraft(depId);
        this.updateDraftArtifacts(depId, verId, DeploymentUnitTestUtils.mavenTestArtifact());
        Request deployReq = new Request().setId(UUID.randomUUID()).setAction("CodeDeploymentActions.deploy").setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setArgument((Object)new CodeDeploymentIdRequest().setDeploymentId(depId).setVersionId(verId));
        try {
            this.executeAction((AbstractRequest)deployReq, res -> {
                TaskResponse taskRes = this.taskResult(deployReq.getId());
                return taskRes != null && (taskRes.getStatus() == Status.RUNNING || taskRes.getStatus() == Status.COMPLETED);
            });
            awaitOnEnterToResolveArtifactMtd.await();
            this.checkDeploymentUnitList(actual -> {
                ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Collections.singletonList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId).setStatus(DeploymentUnitStatus.DOWNLOADING).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.DOWNLOADING))))});
                return true;
            });
        }
        finally {
            TestUtils.resetLatch(awaitOnEnterToResolveArtifactMtd);
            TestUtils.resetLatch(blockingResolveArtifactMtdCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAvailableAfterDownloadingOnNonCoordinator() throws Exception {
        CountDownLatch awaitOnEnterToResolveArtifactMtd = new CountDownLatch(2);
        CountDownLatch blockingResolveArtifactMtdCall = new CountDownLatch(1);
        UUID coordNid = this.cluster.localNode().id();
        ((RepositorySystem)Mockito.doAnswer(invocation -> {
            awaitOnEnterToResolveArtifactMtd.countDown();
            ArtifactRequest req = (ArtifactRequest)invocation.getArgument(1, ArtifactRequest.class);
            if (!coordNid.toString().equals(req.getRequestContext())) {
                U.await((CountDownLatch)blockingResolveArtifactMtdCall);
            }
            return invocation.callRealMethod();
        }).when((Object)this.repoSys)).resolveArtifact((RepositorySystemSession)ArgumentMatchers.any(), (ArtifactRequest)ArgumentMatchers.any());
        try {
            String depId = UUID.randomUUID().toString();
            String verId1 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
            String verId2 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
            awaitOnEnterToResolveArtifactMtd.await();
            this.checkDeploymentUnitList(actual -> {
                ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setVersionId(verId2).setStatus(DeploymentUnitStatus.DOWNLOADING).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails((Collection)Stream.of(new NodeStatusDetailsResponse(this.cluster.localNode().id(), DeploymentUnitStatus.AVAILABLE), new NodeStatusDetailsResponse(this.cluster.forRemotes().node().id(), DeploymentUnitStatus.DOWNLOADING)).sorted(Comparator.comparing(NodeStatusDetailsResponse::getNodeId)).collect(Collectors.toList())), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId1).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE))))});
                return true;
            });
        }
        finally {
            TestUtils.resetLatch(awaitOnEnterToResolveArtifactMtd);
            TestUtils.resetLatch(blockingResolveArtifactMtdCall);
        }
    }

    @Test
    public void failedToDeploy() {
        String brokenArtifact = "org.apache.ignite:ignite-extdata-p2p:2.9.0INVALID_NAME";
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.MAVEN_ARTIFACT, brokenArtifact));
        this.checkExpectedDeploymentFailure(depId, verId, brokenArtifact);
    }

    @Test
    public void failedToDeployExternalLinkArtifact() {
        String brokenArtifact = "https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jarINVALID_URL_PART";
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.EXTERNAL_LINK, brokenArtifact));
        this.checkExpectedDeploymentFailure(depId, verId, brokenArtifact);
    }

    @Test
    public void deploy() {
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDraft(depId);
        this.updateDraftArtifacts(depId, verId, DeploymentUnitTestUtils.mavenTestArtifact());
        Request deployReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.deploy").setArgument((Object)new CodeDeploymentIdRequest().setDeploymentId(depId).setVersionId(verId));
        this.executeActionAndWaitCompleted((AbstractRequest)deployReq);
        this.checkDeploymentUnitList(actual -> {
            if (this.isDownloadingInProgress((List<DeploymentUnitResponse>)actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Collections.singletonList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verId).setVersion(Integer.valueOf(1)).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE))))});
            DeploymentUnitResponse.DeploymentUnitVersionResponse ver = (DeploymentUnitResponse.DeploymentUnitVersionResponse)((DeploymentUnitResponse)actual.get(0)).getVersions().iterator().next();
            return ver.getDeployedAt() != null && ver.getDeployedAt() >= ver.getCreatedAt();
        });
        Collection<NodeStatusDetailsResponse> serverNodeStatus = this.allStatus(DeploymentUnitStatus.AVAILABLE);
        try (IgniteEx client = this.startClient();){
            this.checkDeploymentUnitList(actual -> {
                ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.verId", "versions.createdAt", "versions.deployedAt", "versions.statusDetails"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setStatus(DeploymentUnitStatus.RETIRING).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(serverNodeStatus)))});
                return true;
            });
            Assert.assertNull((Object)client.compute().execute(TEST_TASK, (Object)this.ignite(0).localNode()));
        }
    }

    @Test
    public void cloneRequest() {
        String depId = UUID.randomUUID().toString();
        String verIdOrig = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        Request cloneReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.clone").setArgument((Object)new CodeDeploymentIdRequest().setDeploymentId(depId).setVersionId(verIdOrig));
        AtomicReference verIdCloneRef = new AtomicReference();
        this.executeAction((AbstractRequest)cloneReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            CodeDeploymentIdResponse actual = this.result(r, new TypeReference<CodeDeploymentIdResponse>(){});
            verIdCloneRef.set(actual.getVersionId());
            return Objects.equals(actual.getDeploymentId(), depId);
        });
        this.checkDeploymentUnitList(actual -> {
            if (this.isDownloadingInProgress((List<DeploymentUnitResponse>)actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt"})).contains((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId((String)verIdCloneRef.get()).setStatus(DeploymentUnitStatus.DRAFT).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(Collections.emptyList()), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdOrig).setVersion(Integer.valueOf(1)).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE))))});
            return true;
        });
    }

    @Test
    public void cloneAndDeploy() {
        String depId = UUID.randomUUID().toString();
        String verIdOrig = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        Request deployReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.cloneAndDeploy").setArgument((Object)new CodeDeploymentIdRequest().setDeploymentId(depId).setVersionId(verIdOrig));
        AtomicReference verIdCloneRef = new AtomicReference();
        this.executeAction((AbstractRequest)deployReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            CodeDeploymentIdResponse actual = this.result(r, new TypeReference<CodeDeploymentIdResponse>(){});
            verIdCloneRef.set(actual.getVersionId());
            return Objects.equals(actual.getDeploymentId(), depId);
        });
        this.checkDeploymentUnitList(actual -> {
            if (this.isDownloadingInProgress((List<DeploymentUnitResponse>)actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt"})).contains((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setVersionId((String)verIdCloneRef.get()).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdOrig).setVersion(Integer.valueOf(1)).setStatus(DeploymentUnitStatus.RETIRING).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.RETIRING))))});
            return true;
        });
    }

    @Test
    public void updateArtifacts() {
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDraft(depId);
        this.updateDraftArtifacts(depId, verId, DeploymentUnitTestUtils.mavenTestArtifact());
        this.checkDeploymentUnitList(actual -> {
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Collections.singletonList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verId).setStatus(DeploymentUnitStatus.DRAFT).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(Collections.emptyList())))});
            return true;
        });
    }

    @Test
    public void create() {
        long ts = System.currentTimeMillis();
        String depId = UUID.randomUUID().toString();
        Request deployReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.create").setArgument((Object)new CreateCodeDeploymentRequest().setDeploymentId(depId).setName("Test deployment"));
        AtomicReference verIdRef = new AtomicReference();
        this.executeAction((AbstractRequest)deployReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            CodeDeploymentIdResponse actual = this.result(r, new TypeReference<CodeDeploymentIdResponse>(){});
            Assertions.assertThat((String)actual.getDeploymentId()).isEqualTo(depId);
            verIdRef.set(actual.getVersionId());
            return true;
        });
        this.checkDeploymentUnitList(actual -> {
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Collections.singletonList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId((String)verIdRef.get()).setStatus(DeploymentUnitStatus.DRAFT).setArtifacts(Collections.emptyList()).setStatusDetails(Collections.emptyList())))});
            DeploymentUnitResponse.DeploymentUnitVersionResponse ver = (DeploymentUnitResponse.DeploymentUnitVersionResponse)((DeploymentUnitResponse)actual.get(0)).getVersions().iterator().next();
            return ver.getCreatedAt() >= ts && ver.getDeployedAt() == null;
        });
    }

    @Test
    public void deployMaven() {
        Path artifactRepoPath = Paths.get(System.getProperty("user.home"), ".m2", "repository", "org", "slf4j", "slf4j-simple", "1.7.30");
        U.delete((Path)artifactRepoPath);
        Assertions.assertThat((File)artifactRepoPath.toFile()).doesNotExist();
        String name = "slf4j";
        String coordinate = "org.slf4j:slf4j-simple:1.7.30";
        String coordinateChild = "org.slf4j:slf4j-api:1.7.30";
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDraft(depId, name);
        this.updateDraftArtifacts(depId, verId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.MAVEN_ARTIFACT, coordinate));
        this.deployDraft(depId, verId);
        this.checkDeploymentUnitList(actual -> {
            if (this.isDownloadingInProgress((List<DeploymentUnitResponse>)actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName(name).setVersions(Collections.singletonList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate(coordinate).setDependencies(Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate(coordinateChild))))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE))))});
            return true;
        });
        Assertions.assertThat((Path)artifactRepoPath).exists();
        Assertions.assertThat((Path)artifactRepoPath.resolve("slf4j-simple-1.7.30.pom")).exists();
        Assertions.assertThat((Path)artifactRepoPath.resolve("slf4j-simple-1.7.30.jar")).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deployFtp() throws FtpException, IOException {
        Path srvHome = Files.createDirectories(Paths.get(System.getProperty("user.home"), new String[0]), new FileAttribute[0]);
        Path ftp = Files.createDirectories(srvHome.resolve("ftp"), new FileAttribute[0]);
        File artifactFile = ftp.resolve(IGNITE_EXTDATA_P2P_2_10).toFile();
        if (!artifactFile.exists()) {
            U.downloadUrl((URL)new URL("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"), (File)artifactFile);
        }
        String user = "test";
        String pass = "test";
        FtpServer srv = TestServers.startFtpServer(srvHome, (T2<String, String>)new T2((Object)user, (Object)pass));
        try {
            int port = ((DefaultFtpServer)srv).getListener("default").getPort();
            String coordinate = "ftp://" + user + ":" + pass + "@127.0.0.1:" + port + "/ftp/" + IGNITE_EXTDATA_P2P_2_10;
            this.assertTaskIsDeployedAndExecuted(coordinate);
        }
        finally {
            srv.stop();
            U.delete((Path)ftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deploySftp() throws Exception {
        Path srvHome = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        Path ftp = Files.createDirectories(srvHome.resolve("ftp"), new FileAttribute[0]);
        File artifactFile = ftp.resolve(IGNITE_EXTDATA_P2P_2_10).toFile();
        if (!artifactFile.exists()) {
            U.downloadUrl((URL)new URL("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"), (File)artifactFile);
        }
        String user = "test";
        String pass = "test";
        try (SshServer srv = TestServers.startSftpServer(srvHome, (T2<String, String>)new T2((Object)user, (Object)pass));){
            String coordinate = "sftp://" + user + ":" + pass + "@127.0.0.1:" + srv.getPort() + "/ftp/" + IGNITE_EXTDATA_P2P_2_10;
            this.assertTaskIsDeployedAndExecuted(coordinate);
        }
        finally {
            U.delete((Path)ftp);
        }
    }

    @Test
    public void mavenRepositories() {
        Request emptyListReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.cluster.localNode().id())).setAction("CodeDeploymentActions.listMavenRepositories");
        this.executeAction((AbstractRequest)emptyListReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            List<MavenRepositoryConfiguration> actual = this.result(r, new TypeReference<List<MavenRepositoryConfiguration>>(){});
            List<MavenRepositoryConfiguration> exp = Collections.singletonList(new MavenRepositoryConfiguration().setName("Maven Central").setUrl("https://repo.maven.apache.org/maven2/"));
            Assert.assertEquals(exp, actual);
            return true;
        });
        Request editReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.cluster.localNode().id())).setAction("CodeDeploymentActions.mavenRepositories").setArgument(Collections.singletonList(new MavenRepositoryConfiguration().setName("Test").setUrl("http://repo.maven.org")));
        this.executeActionAndWaitCompleted((AbstractRequest)editReq);
        Request updateListReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.cluster.localNode().id())).setAction("CodeDeploymentActions.listMavenRepositories");
        this.executeAction((AbstractRequest)updateListReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            List<MavenRepositoryConfiguration> actual = this.result(r, new TypeReference<List<MavenRepositoryConfiguration>>(){});
            List<MavenRepositoryConfiguration> exp = Collections.singletonList(new MavenRepositoryConfiguration().setName("Test").setUrl("http://repo.maven.org"));
            Assert.assertEquals(exp, actual);
            return true;
        });
    }

    @Test
    public void storeAllVersions() {
        String depId = UUID.randomUUID().toString();
        String verId1 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        String verId2 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        this.checkDeploymentUnitList(actual -> {
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setVersionId(verId2).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId1).setStatus(DeploymentUnitStatus.RETIRING).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.RETIRING))))});
            return true;
        });
    }

    @Test
    public void remove() throws IgniteCheckedException {
        String depId = UUID.randomUUID().toString();
        String verId1 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        String verId2 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        System.gc();
        this.checkDeploymentUnitList(actual -> {
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setVersionId(verId2).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId1).setStatus(DeploymentUnitStatus.DECOMMISSIONED).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.DECOMMISSIONED))))});
            return true;
        });
        Request destroyReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.remove").setArgument((Object)depId);
        this.executeActionAndWaitCompleted((AbstractRequest)destroyReq);
        Serializable rmv = ((IgniteEx)this.cluster.ignite()).context().distributedMetastorage().read(ManagedDeploymentSpi.makeMetastorageKey((String)depId));
        Assert.assertNull((Object)rmv);
        IgniteEx client = this.startClient();
        IgniteException ex = (IgniteException)Assert.assertThrows(IgniteException.class, () -> Assert.assertNull((Object)client.compute().execute(TEST_TASK, (Object)this.ignite(0).localNode())));
        Assert.assertTrue((boolean)X.hasCause((Throwable)ex, (Class[])new Class[]{IgniteDeploymentException.class}));
        this.checkDeploymentUnitList(actual -> {
            Assert.assertEquals(Collections.emptyList(), (Object)actual);
            return true;
        });
    }

    @Test
    public void rename() {
        String depId = UUID.randomUUID().toString();
        String verId1 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        String verId2 = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        Request renReq = new Request().setId(UUID.randomUUID()).setAction("CodeDeploymentActions.rename").setArgument((Object)new RenameDeploymentUnitArgument().setDeploymentId(depId).setName("Renamed deployment"));
        this.executeActionAndWaitCompleted((AbstractRequest)renReq);
        this.checkDeploymentUnitList(actual -> {
            if (this.isDownloadingInProgress((List<DeploymentUnitResponse>)actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Renamed deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setVersionId(verId2).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId1).setStatus(DeploymentUnitStatus.RETIRING).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.RETIRING))))});
            return true;
        });
    }

    @Test
    public void shouldKeepStatusOfFailedDeploymentUnits() {
        String brokenArtifactUrl = "https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jarINVALID_URL_PART";
        String depId = UUID.randomUUID().toString();
        String verIdFailed = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.EXTERNAL_LINK, brokenArtifactUrl));
        String verIdDeployed = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.externalTestArtifact());
        this.checkDeploymentUnitList(actual -> {
            if (this.isDownloadingInProgress((List<DeploymentUnitResponse>)actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.failReason"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setVersionId(verIdDeployed).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate("https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verIdFailed).setStatus(DeploymentUnitStatus.FAILED_TO_DEPLOY).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate(brokenArtifactUrl))).setStatusDetails(this.allStatus(DeploymentUnitStatus.FAILED_TO_DEPLOY))))});
            return true;
        });
    }

    @Test
    public void shouldRemoveDeploymentUnitVersions() {
        String verIdInvalid = UUID.randomUUID().toString();
        String depId = UUID.randomUUID().toString();
        String verIdDraftStay = this.prepareDraft(depId);
        String verIdDraftRmv = this.prepareDraft(depId);
        String verIdRetiringRmv = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        String verIdAvailable = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.mavenTestArtifact());
        this.checkDeploymentUnitList(actual -> {
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdAvailable).setVersion(Integer.valueOf(2)).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdRetiringRmv).setVersion(Integer.valueOf(1)).setStatus(DeploymentUnitStatus.RETIRING).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.RETIRING)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdDraftRmv).setStatus(DeploymentUnitStatus.DRAFT).setArtifacts(Collections.emptyList()).setStatusDetails(Collections.emptyList()), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdDraftStay).setStatus(DeploymentUnitStatus.DRAFT).setArtifacts(Collections.emptyList()).setStatusDetails(Collections.emptyList())))});
            return true;
        });
        Request deployReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.removeVersion").setArgument((Object)new CodeDeploymentIdsRequest().setDeploymentId(depId).setVersionIds(Arrays.asList(verIdInvalid, verIdDraftRmv, verIdRetiringRmv)));
        this.executeAction((AbstractRequest)deployReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return this.isCompleted(r);
        });
        this.checkDeploymentUnitList(actual -> {
            ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt"})).containsExactly((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdAvailable).setVersion(Integer.valueOf(2)).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singleton(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate("org.apache.ignite:ignite-extdata-p2p:2.9.0"))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersionId(verIdDraftStay).setStatus(DeploymentUnitStatus.DRAFT).setArtifacts(Collections.emptyList()).setStatusDetails(Collections.emptyList())))});
            return true;
        });
    }

    private String prepareDraft(String depId) {
        return this.prepareDraft(depId, "Test deployment");
    }

    private String prepareDraft(String depId, String duName) {
        Request deployReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.create").setArgument((Object)new CreateCodeDeploymentRequest().setDeploymentId(depId).setName(duName));
        AtomicReference verIdRef = new AtomicReference();
        this.executeAction((AbstractRequest)deployReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            CodeDeploymentIdResponse actual = this.result(r, new TypeReference<CodeDeploymentIdResponse>(){});
            Assertions.assertThat((String)actual.getDeploymentId()).isEqualTo(depId);
            verIdRef.set(actual.getVersionId());
            return true;
        });
        return (String)verIdRef.get();
    }

    private String prepareDeployedDeploymentUnit(String depId, org.gridgain.control.agent.dto.action.deployment.ArtifactRequest ... artifacts) {
        String verId = this.prepareDraft(depId);
        this.updateDraftArtifacts(depId, verId, artifacts);
        this.deployDraft(depId, verId);
        return verId;
    }

    private void deployDraft(String depId, String verId) {
        Request deployReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.deploy").setArgument((Object)new CodeDeploymentIdRequest().setDeploymentId(depId).setVersionId(verId));
        this.executeActionAndWaitCompleted((AbstractRequest)deployReq);
    }

    private <T> T stubForBlockingResolveArtifactMethod(T instance) {
        if (instance instanceof RepositorySystem) {
            return (T)this.repoSys;
        }
        return instance;
    }

    private void checkExpectedDeploymentFailure(String depId, String verId, String coordinate) {
        Request listReq = new Request().setId(UUID.randomUUID()).setAction("CodeDeploymentActions.list");
        this.executeAction((AbstractRequest)listReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            List<DeploymentUnitResponse> actual = this.result(r, new TypeReference<List<DeploymentUnitResponse>>(){});
            if (this.isDownloadingInProgress(actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat(actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.artifacts", "versions.statusDetails"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Collections.singletonList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId).setStatus(DeploymentUnitStatus.FAILED_TO_DEPLOY).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate(coordinate))).setStatusDetails(Collections.singleton(new NodeStatusDetailsResponse(this.cluster.id(), DeploymentUnitStatus.FAILED_TO_DEPLOY)))))});
            return true;
        });
    }

    private void assertTaskIsDeployedAndExecuted(String coordinate) {
        Duration delay = Duration.ofSeconds(4L);
        Duration timeout = Duration.ofSeconds(20L);
        String depId = UUID.randomUUID().toString();
        String verId = this.prepareDeployedDeploymentUnit(depId, DeploymentUnitTestUtils.customTestArtifact(ArtifactType.EXTERNAL_LINK, coordinate));
        Request listReq = new Request().setId(UUID.randomUUID()).setAction("CodeDeploymentActions.list");
        this.executeAction(listReq, delay, timeout, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (!this.isCompleted(r)) {
                return false;
            }
            List<DeploymentUnitResponse> actual = this.result(r, new TypeReference<List<DeploymentUnitResponse>>(){});
            if (this.isDownloadingInProgress(actual)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat(actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.createdAt", "versions.deployedAt", "versions.statusDetails.nodeId"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Collections.singletonList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setVersionId(verId).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate(coordinate))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE))))});
            return true;
        });
        Collection<NodeStatusDetailsResponse> serverNodeStatus = this.allStatus(DeploymentUnitStatus.AVAILABLE);
        try (IgniteEx client = this.startClient();){
            this.checkDeploymentUnitList(actual -> {
                ((ListAssert)Assertions.assertThat((List)actual).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"versions.verId", "versions.createdAt", "versions.deployedAt", "versions.statusDetails"})).containsExactlyInAnyOrder((Object[])new DeploymentUnitResponse[]{new DeploymentUnitResponse().setDeploymentId(depId).setName("Test deployment").setVersions(Arrays.asList(new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(2)).setStatus(DeploymentUnitStatus.AVAILABLE).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate(coordinate))).setStatusDetails(this.allStatus(DeploymentUnitStatus.AVAILABLE)), new DeploymentUnitResponse.DeploymentUnitVersionResponse().setVersion(Integer.valueOf(1)).setStatus(DeploymentUnitStatus.RETIRING).setArtifacts(Collections.singletonList(new Artifact().setType(ArtifactType.EXTERNAL_LINK).setCoordinate(coordinate))).setStatusDetails(serverNodeStatus)))});
                return true;
            });
            Assert.assertNull((Object)client.compute().execute(TEST_TASK, (Object)this.ignite(0).localNode()));
        }
    }

    private boolean isDownloadingInProgress(List<DeploymentUnitResponse> du) {
        return du.stream().flatMap(r -> r.getVersions().stream()).map(DeploymentUnitResponse.DeploymentUnitVersionResponse::getStatus).anyMatch(arg_0 -> DeploymentUnitStatus.DOWNLOADING.equals(arg_0));
    }

    private Collection<NodeStatusDetailsResponse> allStatus(DeploymentUnitStatus status) {
        return this.cluster.nodes().stream().map(ClusterNode::id).map(nid -> new NodeStatusDetailsResponse(nid, status)).sorted(Comparator.comparing(NodeStatusDetailsResponse::getNodeId)).collect(Collectors.toList());
    }

    private void updateDraftArtifacts(String depId, String verId, org.gridgain.control.agent.dto.action.deployment.ArtifactRequest ... artifacts) {
        if (F.isEmpty((Object[])artifacts)) {
            return;
        }
        Request updateReq = new Request().setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setAction("CodeDeploymentActions.updateArtifacts").setArgument((Object)new UpdateCodeDeploymentArtifactRequest().setDeploymentId(depId).setVersionId(verId).setArtifacts(Arrays.asList(artifacts)));
        this.executeActionAndWaitCompleted((AbstractRequest)updateReq);
    }

    private void checkDeploymentUnitList(Function<List<DeploymentUnitResponse>, Boolean> assertFn) {
        TestUtils.assertWithPoll(() -> {
            AtomicBoolean checkRes = new AtomicBoolean(false);
            this.executeAction((AbstractRequest)new Request().setId(UUID.randomUUID()).setAction("CodeDeploymentActions.list"), res -> {
                JobResponse r = (JobResponse)F.first((List)res);
                if (!this.isCompleted(r)) {
                    return false;
                }
                List<DeploymentUnitResponse> actual = this.result(r, new TypeReference<List<DeploymentUnitResponse>>(){});
                try {
                    checkRes.set((Boolean)assertFn.apply(actual));
                }
                catch (Throwable ignored) {
                    checkRes.set(false);
                }
                return true;
            });
            return checkRes.get();
        });
    }
}

