/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.DrCachesArgument;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.memory.DrSenderInMemoryStore;
import org.gridgain.grid.internal.GridPluginUtils;
import org.junit.Test;

public class CacheDrActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final String ADMIN_OPS_ACCOUNT = "adminOps";

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(1);
        creds.put(new SecurityCredentials(ADMIN_OPS_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_OPS]    }}");
        return creds;
    }

    @Test
    public void shouldPerformDrActionsWithAdminOpsAccount() {
        this.checkSecureDrActions(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailDrActionsWithNoAccessAccount() {
        this.checkSecureDrActions("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    private void checkSecureDrActions(String acc, String pwd, Predicate<JobResponse> resChecker) {
        this.stopGrid(0);
        DrSenderConfiguration sndCfg = new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)5).setReceiverAddresses(new String[]{"127.0.0.1"}).setStore((DrSenderStore)new DrSenderInMemoryStore())});
        IgniteConfiguration cfg = this.getConfiguration(this.instanceName(0));
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)cfg).setDataCenterId((byte)15).setDrSenderConfiguration(sndCfg);
        IgniteEx ignite = this.startGrid(cfg);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.cluster = ignite.cluster();
        CacheConfiguration cacheCfg = new CacheConfiguration("DEFAULT_CACHE_NAME").setPluginConfigurations(new CachePluginConfiguration[]{new GridGainCacheConfiguration().setDrSenderConfiguration(new CacheDrSenderConfiguration())});
        IgniteCache cache = this.cluster.ignite().getOrCreateCache(cacheCfg);
        cache.put((Object)1, (Object)2);
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.pauseIncrementalDataReplication").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList("DEFAULT_CACHE_NAME")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.resumeIncrementalDataReplication").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList("DEFAULT_CACHE_NAME")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.startFullStateTransfer").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList("DEFAULT_CACHE_NAME")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.stopFullStateTransfer").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList("DEFAULT_CACHE_NAME")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }
}

