/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action;

import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.ignite.IgniteAuthenticationException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.action.Session;
import org.gridgain.control.agent.action.SessionRegistry;
import org.gridgain.control.agent.configuration.ControlCenterAgentConfiguration;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.passcode.AuthenticationAclBasicProvider;
import org.gridgain.grid.security.passcode.AuthenticationAclProvider;
import org.gridgain.grid.security.passcode.PasscodeAuthenticator;
import org.junit.Assert;
import org.junit.Test;

public class SessionRegistryWithSecurityTest
extends AgentCommonAbstractTest {
    private IgniteEx ignite;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.ignite = this.startGrid();
        this.ignite.cluster().state(ClusterState.ACTIVE);
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        ControlCenterAgentConfiguration testCfg = agent.configuration().setSecuritySessionExpirationTimeout(100L);
        agent.configuration(testCfg);
    }

    @Test
    public void shouldUpdateLastInvalidateTime() throws Exception {
        SessionRegistry registry = AgentUtils.ggccAgent((IgniteEx)this.ignite).sessionRegistry();
        Session ses = Session.random();
        ses.credentials(new SecurityCredentials("server", "123456"));
        ses.address(new InetSocketAddress(8080));
        long oldLastInvalidateTime = ses.lastInvalidateTime();
        registry.saveSession(ses);
        Thread.sleep(110L);
        Assert.assertTrue((oldLastInvalidateTime < registry.getSession(ses.id()).lastInvalidateTime() ? 1 : 0) != 0);
    }

    @Test
    public void shouldRemoveSessionAfterInvalidateSessionWithoutCredentials() throws Exception {
        SessionRegistry registry = AgentUtils.ggccAgent((IgniteEx)this.ignite).sessionRegistry();
        Session ses = Session.random();
        registry.saveSession(ses);
        Thread.sleep(110L);
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAuthenticationException.class, "Failed to authenticate remote client (invalid credentials?): " + ses.id());
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAuthenticationException.class, "Session not found for ID: " + ses.id());
    }

    @Test
    public void shouldRemoveSessionAfterInvalidateSessionWithIncorrectCredentials() throws Exception {
        SessionRegistry registry = AgentUtils.ggccAgent((IgniteEx)this.ignite).sessionRegistry();
        Session ses = Session.random();
        ses.credentials(new SecurityCredentials("server", "1234567"));
        ses.address(new InetSocketAddress(8080));
        registry.saveSession(ses);
        Thread.sleep(110L);
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAuthenticationException.class, "Failed to authenticate remote client (invalid credentials?): " + ses.id());
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAuthenticationException.class, "Session not found for ID: " + ses.id());
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        try {
            HashMap<SecurityCredentials, String> acls = new HashMap<SecurityCredentials, String>();
            acls.put(new SecurityCredentials("server", "123456"), this.getServerPerms());
            PasscodeAuthenticator authenticator = new PasscodeAuthenticator();
            authenticator.setAclProvider((AuthenticationAclProvider)new AuthenticationAclBasicProvider(acls));
            cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setAuthenticator((Authenticator)authenticator).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("server", "123456")))});
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        return cfg;
    }

    private String getServerPerms() {
        return "{ defaultAllow: true }";
    }
}

