/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Test;

public class ActionAuditWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    @Override
    protected int clusterSize() {
        return 2;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        cfg.setIncludeEventTypes(new int[]{27, 1001});
        return cfg;
    }

    @Test
    public void testCalledControlCenterEventMustBeRecordedWithLoginOfClient() {
        ConcurrentHashMap events = new ConcurrentHashMap();
        IgniteEx crdNode = (IgniteEx)this.cluster.ignite();
        crdNode.events().remoteListen((IgniteBiPredicate & Serializable)(nodeId, evt) -> {
            List eventsByNode = events.computeIfAbsent(nodeId, k -> new ArrayList());
            eventsByNode.add(evt);
            return true;
        }, null, new int[]{27, 1001});
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionControllerWithSecurity.adminAction").setArgument((Object)10).setSessionId(sesId).setNodeIds(this.nonCrdNodeIds).setCcUsername("user@example.com");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r.getStatus() == Status.COMPLETED;
        });
        UUID crdNodeId = crdNode.localNode().id();
        Assertions.assertThat((List)((List)events.get(crdNodeId))).satisfiesExactly(new ThrowingConsumer[]{actionEvent -> Assertions.assertThat((Comparable)actionEvent).extracting(new String[]{"type", "actionName", "actionClassName", "ccUsername"}).containsExactly(new Object[]{27, "SecurityActions.authenticate", "org.gridgain.control.agent.action.controller.SecurityActionsController", "user@example.com"}), authEvent -> Assertions.assertThat((Comparable)authEvent).extracting(new String[]{"type", "login"}).containsExactly(new Object[]{1001, "admin"})});
        events.remove(crdNodeId);
        Assertions.assertThat(events.values().stream().flatMap(Collection::stream)).extracting(new String[]{"type", "actionName", "actionClassName", "ccUsername"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{27, "TestActionControllerWithSecurity.adminAction", "org.gridgain.control.agent.action.controller.TestActionControllerWithSecurity", "user@example.com"})});
    }
}

