::
:: Copyright (C) GridGain Systems. All Rights Reserved.
:: _________        _____ __________________        _____
:: __  ____/___________(_)______  /__  ____/______ ____(_)_______
:: _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
:: / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
:: \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
::

::
:: SSL certificates generation.
::

::
:: Preconditions:
::  1. If needed, download Open SSL for Windows from "https://wiki.openssl.org/index.php/Binaries".
::   and unpack it to some folder.
::  2. If needed, install JDK 8 or newer. We need "keytool" from "JDK/bin."
::  3. Create "openssl.cnf" in some folder.
::     You may use "https://github.com/openssl/openssl/blob/master/apps/openssl.cnf" as template.
::  4. If needed, add "opensll" & "keytool" to PATH variable.
::
::  NOTE: In case of custom SERVER_DOMAIN_NAME you may need to tweak your "etc/hosts" file.
::

:: Set paths.
set PATH_TO_OPEN_SSL=_path_where_open_ssl_was_unpacked_
set PATH_TO_JDK_KEYTOOL=_path_to_JDK_keytool_

:: Set Open SSL variables.
set RANDFILE=%PATH_TO_OPEN_SSL%\.rnd
set OPENSSL_CONF=%PATH_TO_OPEN_SSL%\openssl.cnf

:: Certificates password.
set PWD=123456

:: Server.
set SERVER_DOMAIN_NAME=localhost
set SERVER_EMAIL=support@test.com

:: Client.
set CLIENT_DOMAIN_NAME=localhost
set CLIENT_EMAIL=client@test.com

:: Control Center.
set CONTROL_DOMAIN_NAME=control.gridgain.com
set CONTROL_EMAIL=control@gridgain.com

:: Cleanup.
del server.*
del client.*
del ca.*
del control.*

:: Generate server config.
(
echo [req]
echo prompt                 = no
echo distinguished_name     = dn
echo req_extensions         = req_ext

echo [ dn ]
echo countryName            = RU
echo stateOrProvinceName    = Test
echo localityName           = Test
echo organizationName       = Apache
echo commonName             = %SERVER_DOMAIN_NAME%
echo organizationalUnitName = IT
echo emailAddress           = %SERVER_EMAIL%

echo [ req_ext ]
echo subjectAltName         = @alt_names

echo [ alt_names ]
echo DNS.1                  = %SERVER_DOMAIN_NAME%
echo DNS.2                  = host.docker.internal
echo DNS.3                  = host.testcontainers.internal
) > "server.cnf"

:: Generate client config.
(
echo [req]
echo prompt                 = no
echo distinguished_name     = dn
echo req_extensions         = req_ext

echo [ dn ]
echo countryName            = RU
echo stateOrProvinceName    = Test
echo localityName           = Test
echo organizationName       = Apache
echo commonName             = %CLIENT_DOMAIN_NAME%
echo organizationalUnitName = IT
echo emailAddress           = %CLIENT_EMAIL%

echo [ req_ext ]
echo subjectAltName         = @alt_names

echo [ alt_names ]
echo DNS.1                  = %CLIENT_DOMAIN_NAME%
echo DNS.2                  = host.docker.internal
echo DNS.3                  = host.testcontainers.internal
) > "client.cnf"

:: Generate Control Center config.
(
echo [req]
echo prompt                 = no
echo distinguished_name     = dn
echo req_extensions         = req_ext
echo [ dn ]
echo countryName            = RU
echo stateOrProvinceName    = Moscow
echo localityName           = Moscow
echo organizationName       = test
echo commonName             = %CONTROL_DOMAIN_NAME%
echo organizationalUnitName = IT
echo emailAddress           = %CONTROL_EMAIL%

echo [ req_ext ]
echo subjectAltName         = @alt_names

echo [ alt_names ]
echo DNS.1                  = %CONTROL_DOMAIN_NAME%
) > "control.cnf"

:: Generate certificates.
%PATH_TO_OPEN_SSL%\openssl genrsa -des3 -passout pass:%PWD% -out server.key 1024
%PATH_TO_OPEN_SSL%\openssl req -new -passin pass:%PWD% -key server.key -config server.cnf -out server.csr

%PATH_TO_OPEN_SSL%\openssl genrsa -des3 -passout pass:%PWD% -out server-outdated.key 1024
%PATH_TO_OPEN_SSL%\openssl req -new -passin pass:%PWD% -key server-outdated.key -config server.cnf -out server-outdated.csr

%PATH_TO_OPEN_SSL%\openssl req -new -newkey rsa:1024 -nodes -keyout ca.key -x509 -days 3650 -config server.cnf -out ca.crt
%PATH_TO_OPEN_SSL%\openssl req -new -newkey rsa:1024 -nodes -keyout ca-other.key -x509 -days 3650 -config server.cnf -out ca-other.crt

%PATH_TO_OPEN_SSL%\openssl x509 -req -days 3650 -in server.csr -CA ca.crt -CAkey ca.key -set_serial 01 -extensions req_ext -extfile server.cnf -out server.crt
%PATH_TO_OPEN_SSL%\openssl x509 -req -days 1 -in server-outdated.csr -CA ca.crt -CAkey ca.key -set_serial 02 -extensions req_ext -extfile server.cnf -out server-outdated.crt

%PATH_TO_OPEN_SSL%\openssl req -new -utf8 -nameopt multiline,utf8 -newkey rsa:1024 -nodes -keyout client.key -config client.cnf -out client.csr
%PATH_TO_OPEN_SSL%\openssl x509 -req -days 3650 -in client.csr -CA ca.crt -CAkey ca.key -set_serial 03 -out client.crt

%PATH_TO_OPEN_SSL%\openssl req -new -sha256 -utf8 -nameopt multiline,utf8 -newkey rsa:1024 -nodes -keyout control.key -config control.cnf -out control.csr
%PATH_TO_OPEN_SSL%\openssl x509 -req -days 3650 -in control.csr -CA ca.crt -CAkey ca.key -set_serial 04 -out control.crt

%PATH_TO_OPEN_SSL%\openssl pkcs12 -export -in server.crt -inkey server.key -certfile ca.crt -out server.p12 -passin pass:%PWD% -passout pass:%PWD%
%PATH_TO_OPEN_SSL%\openssl pkcs12 -export -in server-outdated.crt -inkey server-outdated.key -certfile ca.crt -out server-outdated.p12 -passin pass:%PWD% -passout pass:%PWD%
%PATH_TO_OPEN_SSL%\openssl pkcs12 -export -in client.crt -inkey client.key -certfile ca.crt -out client.p12 -passout pass:%PWD%
%PATH_TO_OPEN_SSL%\openssl pkcs12 -export -in ca.crt -inkey ca.key -certfile ca.crt -out ca.p12 -passout pass:%PWD%
%PATH_TO_OPEN_SSL%\openssl pkcs12 -export -in ca-other.crt -inkey ca-other.key -certfile ca-other.crt -out ca-other.p12 -passout pass:%PWD%
%PATH_TO_OPEN_SSL%\openssl pkcs12 -export -in control.crt -inkey control.key -certfile ca.crt -out control.p12 -passin pass:%PWD% -passout pass:%PWD%

%PATH_TO_JDK_KEYTOOL% -import -alias cacrt -file ca.crt -storetype PKCS12 -noprompt -storepass %PWD% -keystore ca.p12
%PATH_TO_JDK_KEYTOOL% -import -alias cacrt -file ca-other.crt -storetype PKCS12 -noprompt -storepass %PWD% -keystore ca-other.p12

:: Cleanup.
del *.cnf
del ca-other.crt
del server*.crt
del client.crt
del control.crt
del ca-other.key
del server*.key
del client.key
del control.key
del *.csr
