/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.oidc;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.gridgain.control.agent.AbstractSelfTest;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.composite.CompositeAuthenticator;
import org.gridgain.grid.security.oidc.OpenIdAuthenticator;
import org.gridgain.grid.security.passcode.AuthenticationAclBasicProvider;
import org.gridgain.grid.security.passcode.AuthenticationAclProvider;
import org.gridgain.grid.security.passcode.PasscodeAuthenticator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.Times;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;

public class OpenIdAuthenticatorTest
extends AbstractSelfTest {
    private static ClientAndServer mockServer;
    private static IgniteEx ignite;

    @Before
    public void setup() {
        this.cleanPersistenceDir();
        mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[0]);
        ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
    }

    @After
    public void teardown() {
        this.stopAllGrids();
        mockServer.stop();
    }

    @Test
    public void shouldUseDefaultRole() throws Exception {
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/userinfo").withHeader("Authorization", new String[]{"Bearer access_token"}), Times.exactly((int)1)).respond(HttpResponse.response((String)"{\"sub\": \"id\", \"gg-role\": \"readOnly\"}").withStatusCode(Integer.valueOf(200)));
        SecurityCredentials creds = new SecurityCredentials();
        creds.setUserObject((Object)F.asMap((Object)"accessToken", (Object)"access_token"));
        SecurityContext subjCtx = this.authenticate(creds);
        Assert.assertNotNull((Object)subjCtx);
        Assert.assertTrue((boolean)subjCtx.cacheOperationAllowed("test", SecurityPermission.CACHE_READ));
        Assert.assertFalse((boolean)subjCtx.cacheOperationAllowed("test", SecurityPermission.CACHE_PUT));
    }

    @Test
    public void shouldUseClusterRole() throws Exception {
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/userinfo").withHeader("Authorization", new String[]{"Bearer access_token"}), Times.exactly((int)1)).respond(HttpResponse.response((String)("{\"sub\": \"id\", \"gg-role\": \"readOnly\", \"gg-role-" + ignite.cluster().id() + "\": \"write\"}")).withStatusCode(Integer.valueOf(200)));
        SecurityCredentials creds = new SecurityCredentials();
        creds.setUserObject((Object)F.asMap((Object)"accessToken", (Object)"access_token"));
        SecurityContext subjCtx = this.authenticate(creds);
        Assert.assertNotNull((Object)subjCtx);
        Assert.assertTrue((boolean)subjCtx.cacheOperationAllowed("test", SecurityPermission.CACHE_READ));
        Assert.assertTrue((boolean)subjCtx.cacheOperationAllowed("test", SecurityPermission.CACHE_PUT));
    }

    @Test
    public void shouldBlockAccessIfTokenIsInvalid() throws Exception {
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/userinfo"), Times.exactly((int)1)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(401)));
        SecurityCredentials creds = new SecurityCredentials();
        creds.setUserObject((Object)F.asMap((Object)"accessToken", (Object)"access_token"));
        SecurityContext subjCtx = this.authenticate(creds);
        Assert.assertNull((Object)subjCtx);
    }

    @Test
    public void shouldBlockAccessIfRoleIsMissing() throws Exception {
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/userinfo").withHeader("Authorization", new String[]{"Bearer access_token"}), Times.exactly((int)1)).respond(HttpResponse.response((String)"{\"sub\": \"id\"}").withStatusCode(Integer.valueOf(200)));
        SecurityCredentials creds = new SecurityCredentials();
        creds.setUserObject((Object)F.asMap((Object)"accessToken", (Object)"access_token"));
        SecurityContext subjCtx = this.authenticate(creds);
        Assert.assertNull((Object)subjCtx);
    }

    @Test
    public void shouldBlockAccessIfPermissionsAreMissing() throws Exception {
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/userinfo").withHeader("Authorization", new String[]{"Bearer access_token"}), Times.exactly((int)1)).respond(HttpResponse.response((String)"{\"sub\": \"id\", \"gg-role\": \"non-existing\"}").withStatusCode(Integer.valueOf(200)));
        SecurityCredentials creds = new SecurityCredentials();
        creds.setUserObject((Object)F.asMap((Object)"accessToken", (Object)"access_token"));
        SecurityContext subjCtx = this.authenticate(creds);
        Assert.assertNull((Object)subjCtx);
    }

    @Test
    public void shouldReturnNullIfAuthenticationDidNotPass() throws Exception {
        Assert.assertNull((Object)this.authenticate(null));
    }

    private SecurityContext authenticate(SecurityCredentials creds) throws IgniteCheckedException {
        AuthenticationContext authCtx = new AuthenticationContext();
        authCtx.subjectType(SecuritySubjectType.REMOTE_CLIENT);
        authCtx.subjectId(UUID.randomUUID());
        authCtx.nodeAttributes(Collections.emptyMap());
        authCtx.credentials(creds);
        return ignite.context().security().authenticate(authCtx);
    }

    private IgniteConfiguration getConfiguration(String instanceName, GridGainConfiguration gCfg) {
        return super.getConfiguration(instanceName).setPluginConfigurations(new PluginConfiguration[]{gCfg});
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        try {
            SecurityCredentials cred = new SecurityCredentials("login", "pass");
            PasscodeAuthenticator passCodeAuth = new PasscodeAuthenticator();
            passCodeAuth.setAclProvider((AuthenticationAclProvider)new AuthenticationAclBasicProvider(F.asMap((Object)cred, (Object)"{defaultAllow:true}")));
            OpenIdAuthenticator openIdAuth = new OpenIdAuthenticator().setUserInfoUrl("http://localhost:" + mockServer.getLocalPort() + "/userinfo").setPermissionsJson(F.asMap((Object)"readOnly", (Object)"{defaultAllow:true, {cache:'test',permissions:[CACHE_READ]}}", (Object)"write", (Object)"{defaultAllow:true, {cache:'test',permissions:[CACHE_READ, CACHE_PUT]}}"));
            return this.getConfiguration(instanceName, new GridGainConfiguration().setAuthenticator((Authenticator)new CompositeAuthenticator().setAuthenticators((Collection)F.asList((Object[])new Authenticator[]{passCodeAuth, openIdAuth}))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(cred)));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }
}

