/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.utils;

import java.util.List;
import org.apache.ignite.internal.util.GridUnsafe;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.utils.MetricUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetricUtilsTest {
    @Test
    public void shouldMatchMetricTemplate() {
        Assert.assertTrue((boolean)MetricUtils.matchMetricTemplate((String)"cache", (String)"cache"));
        Assert.assertTrue((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"cache.Person.consistentId"));
        Assert.assertTrue((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"cache.*.consistentId"));
        Assert.assertTrue((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"*.Person.consistentId"));
        Assert.assertTrue((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"*.Person.*"));
        Assert.assertTrue((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"*.*.*"));
        Assert.assertFalse((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"cache.Person2.consistentId"));
        Assert.assertFalse((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"cache2.Person.consistentId"));
        Assert.assertFalse((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person2.consistentId", (String)"cache.Person.*"));
        Assert.assertFalse((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"cache.Person"));
        Assert.assertFalse((boolean)MetricUtils.matchMetricTemplate((String)"cache.Person.consistentId", (String)"cache.*"));
    }

    @Test
    public void shouldBeLittleEndian() {
        this.checkStoringInLE(Long.MAX_VALUE);
        this.checkStoringInLE(Long.MIN_VALUE);
        this.checkStoringInLE(0L);
        this.checkStoringInLE(1000L);
        this.checkStoringInLE(-1000L);
    }

    @Test
    public void shouldSplitMetricName() {
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"cache.com.moc.cache.EstimatedRebalancingKeys")).containsExactly((Object[])new String[]{"cache", "com.moc.cache", "EstimatedRebalancingKeys"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"cache.Person.EstimatedRebalancingKeys")).containsExactly((Object[])new String[]{"cache", "Person", "EstimatedRebalancingKeys"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"cacheGroups.com.moc.cache.IndexBuildCountPartitionsLeft")).containsExactly((Object[])new String[]{"cacheGroups", "com.moc.cache", "IndexBuildCountPartitionsLeft"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"cacheGroups.Person.IndexBuildCountPartitionsLeft")).containsExactly((Object[])new String[]{"cacheGroups", "Person", "IndexBuildCountPartitionsLeft"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.statistics.cacheGroups.com.moc.cache.LOGICAL_READS")).containsExactly((Object[])new String[]{"io", "statistics", "cacheGroups", "com.moc.cache", "LOGICAL_READS"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.statistics.cacheGroups.Person.LOGICAL_READS")).containsExactly((Object[])new String[]{"io", "statistics", "cacheGroups", "Person", "LOGICAL_READS"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.statistics.hashIndexes.com.moc.cache._key_PK.LOGICAL_READS_INNER")).containsExactly((Object[])new String[]{"io", "statistics", "hashIndexes", "com.moc.cache", "_key_PK", "LOGICAL_READS_INNER"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.statistics.hashIndexes.Person.HASH_PK.LOGICAL_READS_INNER")).containsExactly((Object[])new String[]{"io", "statistics", "hashIndexes", "Person", "HASH_PK", "LOGICAL_READS_INNER"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.statistics.sortedIndexes.com.moc.cache._key_PK.LOGICAL_READS_INNER")).containsExactly((Object[])new String[]{"io", "statistics", "sortedIndexes", "com.moc.cache", "_key_PK", "LOGICAL_READS_INNER"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.statistics.sortedIndexes.Person._key_PK.LOGICAL_READS_INNER")).containsExactly((Object[])new String[]{"io", "statistics", "sortedIndexes", "Person", "_key_PK", "LOGICAL_READS_INNER"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.statistics.sortedIndexes.*._key_PK.LOGICAL_READS_INNER")).containsExactly((Object[])new String[]{"io", "statistics", "sortedIndexes", "*", "_key_PK", "LOGICAL_READS_INNER"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"cache.LastDataVersion")).containsExactly((Object[])new String[]{"cache", "LastDataVersion"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.receiver.MessageQueueSizeBytes")).containsExactly((Object[])new String[]{"dr", "receiver", "MessageQueueSizeBytes"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"io.dataregion.com.moc.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"io", "dataregion", "com.moc.cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.receiver.com.moc.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "receiver", "com.moc.cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.receiver.dc1.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "receiver", "dc1", "cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.receiver.dc1.com.moc.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "receiver", "dc1", "com.moc.cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "sender", "cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.*.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "sender", "*", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.com.moc.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "sender", "com.moc.cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.dc1.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "sender", "dc1", "cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.*.*.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "sender", "*", "*", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.dc1.com.moc.cache.PhysicalMemorySize")).containsExactly((Object[])new String[]{"dr", "sender", "dc1", "com.moc.cache", "PhysicalMemorySize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.store.dc1.StoreSize")).containsExactly((Object[])new String[]{"dr", "sender", "store", "dc1", "StoreSize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.store.global.StoreSize")).containsExactly((Object[])new String[]{"dr", "sender", "store", "global", "StoreSize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"dr.sender.buffer.global.StoreSize")).containsExactly((Object[])new String[]{"dr", "sender", "buffer", "global", "StoreSize"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"threadPools.cache.ActiveCount")).containsExactly((Object[])new String[]{"threadPools", "cache", "ActiveCount"});
        Assertions.assertThat((List)MetricUtils.splitToTiers((String)"threadPools.com.moc.cache.ActiveCount")).containsExactly((Object[])new String[]{"threadPools", "com.moc.cache", "ActiveCount"});
    }

    private void checkStoringInLE(Long num) {
        byte[] arr = new byte[8];
        MetricUtils.putShortLE((byte[])arr, (long)0L, (short)num.shortValue());
        Assert.assertEquals((long)num.shortValue(), (long)GridUnsafe.getShort((byte[])arr, (long)0L));
        Assert.assertEquals((long)num.shortValue(), (long)MetricUtils.getShortLE((byte[])arr, (long)0L));
        MetricUtils.putIntLE((byte[])arr, (long)0L, (int)num.intValue());
        Assert.assertEquals((long)num.intValue(), (long)GridUnsafe.getInt((byte[])arr, (long)0L));
        Assert.assertEquals((long)num.intValue(), (long)MetricUtils.getIntLE((byte[])arr, (long)0L));
        MetricUtils.putLongLE((byte[])arr, (long)0L, (long)num);
        Assert.assertEquals((long)num, (long)GridUnsafe.getLong((byte[])arr, (long)0L));
        Assert.assertEquals((long)num, (long)MetricUtils.getLongLE((byte[])arr, (long)0L));
    }
}

