/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.utils;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.X;
import org.gridgain.control.agent.utils.LogListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListeningTestLogger
implements IgniteLogger {
    private final IgniteLogger echo;
    private final Collection<Consumer<String>> lsnrs = new CopyOnWriteArraySet<Consumer<String>>();

    public ListeningTestLogger(@Nullable IgniteLogger echo) {
        this.echo = echo;
    }

    public ListeningTestLogger(@Nullable IgniteLogger echo, LogListener ... lsnrs) {
        this(echo);
        for (LogListener lsnr : lsnrs) {
            this.registerListener(lsnr);
        }
    }

    public void registerListener(@NotNull LogListener lsnr) {
        lsnr.reset();
        this.lsnrs.add(lsnr);
    }

    public void registerAllListeners(LogListener ... lsnrs) {
        for (LogListener lsnr : lsnrs) {
            lsnr.reset();
            this.lsnrs.add(lsnr);
        }
    }

    public void registerListener(@NotNull Consumer<String> lsnr) {
        this.lsnrs.add(lsnr);
    }

    public void unregisterListener(@NotNull Consumer<String> lsnr) {
        this.lsnrs.remove(lsnr);
    }

    public void clearListeners() {
        this.lsnrs.clear();
    }

    public ListeningTestLogger getLogger(Object ctgr) {
        return this;
    }

    public void trace(String msg) {
        if (this.echo != null) {
            this.echo.trace(msg);
        }
        this.applyListeners(msg);
    }

    public void debug(String msg) {
        if (this.echo != null) {
            this.echo.debug(msg);
        }
        this.applyListeners(msg);
    }

    public void info(String msg) {
        if (this.echo != null) {
            this.echo.info(msg);
        }
        this.applyListeners(msg);
    }

    public void warning(String msg, @Nullable Throwable t) {
        if (this.echo != null) {
            this.echo.warning(msg, t);
        }
        this.applyListeners(msg);
        if (t != null) {
            this.applyListeners(X.getFullStackTrace((Throwable)t));
        }
    }

    public void error(String msg, @Nullable Throwable t) {
        if (this.echo != null) {
            this.echo.error(msg, t);
        }
        this.applyListeners(msg);
        if (t != null) {
            this.applyListeners(X.getFullStackTrace((Throwable)t));
        }
    }

    public boolean isTraceEnabled() {
        return this.echo != null && this.echo.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.echo != null && this.echo.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isQuiet() {
        return false;
    }

    public String fileName() {
        return null;
    }

    private void applyListeners(String msg) {
        if (msg == null) {
            return;
        }
        for (Consumer<String> lsnr : this.lsnrs) {
            lsnr.accept(msg);
        }
    }
}

