/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.utils;

import java.net.URI;
import java.util.UUID;
import org.gridgain.control.agent.AbstractSelfTest;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Assert;
import org.junit.Test;

public class AgentUtilsTest
extends AbstractSelfTest {
    @Test
    public void shouldBuildMonitoringUri() {
        String tok = UUID.randomUUID().toString();
        URI expUri = URI.create("http://host:80/go/" + tok);
        URI uriWithTrailingSlash = AgentUtils.monitoringUri((String)"http://host:80/", (String)tok);
        Assert.assertEquals((Object)expUri, (Object)uriWithTrailingSlash);
        URI uriWithoutTrailingSlash = AgentUtils.monitoringUri((String)"http://host:80", (String)tok);
        Assert.assertEquals((Object)expUri, (Object)uriWithoutTrailingSlash);
        URI uriWithTrailingSlashes = AgentUtils.monitoringUri((String)"http://host:80///", (String)tok);
        Assert.assertEquals((Object)expUri, (Object)uriWithTrailingSlashes);
        TestUtils.assertThrows(() -> AgentUtils.monitoringUri((String)"http://host super:80", (String)tok), IllegalStateException.class, "Could not create URI object: Illegal character in authority at index 7: http://host super:80/go/" + tok);
    }
}

