/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gridgain.control.agent.AbstractSelfTest;
import org.gridgain.control.agent.configuration.ControlCenterAgentConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class AgentConfigurationTest
extends AbstractSelfTest {
    @Test
    public void shouldValidlyConvertConfiguration() {
        boolean enabled = false;
        List<String> uris = Collections.singletonList("Test URI");
        List<String> cipherSuites = Collections.singletonList("Test suite");
        long securitySesTimeout = Long.MAX_VALUE;
        long securitySesExpTimeout = Long.MIN_VALUE;
        long qryIdleTimeout = 0x7FFFFFFFFFFFFFFEL;
        String keyStoreType = "Key store type";
        String keyStore = "Key store";
        String keyStorePas = "Key store password";
        String trustStoreType = "Trust store type";
        String trustStore = "Trust store";
        String trustStorePas = "Trust store password";
        ControlCenterAgentConfiguration cfg = new ControlCenterAgentConfiguration().setEnabled(enabled).setUris(uris).setCipherSuites(cipherSuites).setSecuritySessionTimeout(securitySesTimeout).setSecuritySessionExpirationTimeout(securitySesExpTimeout).setKeyStoreType(keyStoreType).setKeyStore(keyStore).setKeyStorePassword(keyStorePas).setTrustStoreType(trustStoreType).setTrustStore(trustStore).setTrustStorePassword(trustStorePas).setQueryIdleTimeout(qryIdleTimeout);
        HashMap<String, Object> cfgMap = new HashMap<String, Object>();
        cfgMap.put("enabled", enabled);
        cfgMap.put("uris", uris);
        cfgMap.put("cipherSuites", cipherSuites);
        cfgMap.put("securitySesTimeout", securitySesTimeout);
        cfgMap.put("securitySesExpirationTimeout", securitySesExpTimeout);
        cfgMap.put("keyStoreType", keyStoreType);
        cfgMap.put("keyStore", keyStore);
        cfgMap.put("keyStorePass", keyStorePas);
        cfgMap.put("trustStoreType", trustStoreType);
        cfgMap.put("trustStore", trustStore);
        cfgMap.put("trustStorePass", trustStorePas);
        cfgMap.put("queryIdleTimeout", qryIdleTimeout);
        Assert.assertEquals((Object)cfg, (Object)ControlCenterAgentConfiguration.configFromMap(cfgMap));
        Assert.assertEquals(cfgMap, (Object)ControlCenterAgentConfiguration.configToMap((ControlCenterAgentConfiguration)cfg));
    }
}

