/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.transport.ws;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.assertj.core.api.Assertions;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientSocket;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.test.TestLogger;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Test;
import org.junit.jupiter.api.BeforeEach;

public class ControlCenterAgentWebSocketTest
extends AgentCommonAbstractTest {
    protected static final String CONNECTION_DISCONNECTED_MSG = "Control Center agent disconnected.";

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration("src/test/resources/ignite-cfg-without-agent.xml", instanceName);
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        Class<GrizzlyClientSocket> clazz = GrizzlyClientSocket.class;
        Method method = clazz.getDeclaredMethod("closeSharedTransport", new Class[0]);
        method.setAccessible(true);
        method.invoke(null, new Object[0]);
        this.checkWsThreads();
    }

    @Test
    public void shouldCreateNewPoolEverytimeIfNotShared() throws InterruptedException {
        boolean isShared = false;
        System.setProperty("AGENT_WS_USE_SHARED_THREAD_POOL", String.valueOf(isShared));
        System.setProperty("AGENT_WS_SHARED_THREAD_POOL_TIMEOUT_SECONDS", String.valueOf(5));
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "ignite-1");
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        Set<String> wsThreadsOnStart = this.agentWsThreads();
        log.clear();
        this.management(ignite, Collections.singletonList("--off"));
        TestUtils.assertWithPoll(() -> log.contains(CONNECTION_DISCONNECTED_MSG));
        Set<String> wsThreadsAfterManagementOff = this.agentWsThreads();
        Assertions.assertThat((boolean)wsThreadsOnStart.equals(wsThreadsAfterManagementOff)).isEqualTo(isShared);
        log.clear();
        this.management(ignite, Collections.singletonList("--on"));
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        Set<String> wsThreadsAfterManagementOn = this.agentWsThreads();
        Assertions.assertThat((boolean)wsThreadsAfterManagementOn.equals(wsThreadsAfterManagementOff)).isEqualTo(isShared);
        log.clear();
        this.management(ignite, Collections.singletonList("--off"));
        TestUtils.assertWithPoll(() -> log.contains(CONNECTION_DISCONNECTED_MSG));
        Set<String> wsThreadsAfterSecondManagementOff = this.agentWsThreads();
        Assertions.assertThat((boolean)wsThreadsAfterSecondManagementOff.equals(wsThreadsAfterManagementOn)).isEqualTo(isShared);
        Thread.sleep(6000L);
        log.clear();
        this.management(ignite, Collections.singletonList("--on"));
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        Set<String> wsThreadsAfterSecondManagementOn = this.agentWsThreads();
        Assertions.assertThat(wsThreadsAfterSecondManagementOn).isNotEmpty();
        Assertions.assertThat((boolean)wsThreadsAfterSecondManagementOn.equals(wsThreadsAfterManagementOn)).isFalse();
        ignite.close();
    }

    @Test
    public void shouldReusePoolOnMultipleAgentReconnectsWhenShared() {
        System.setProperty("AGENT_WS_USE_SHARED_THREAD_POOL", String.valueOf(true));
        System.setProperty("AGENT_WS_SHARED_THREAD_POOL_TIMEOUT_SECONDS", String.valueOf(5));
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "ignite-1");
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        Set<String> wsThreadsOnStart = this.agentWsThreads();
        for (int i = 0; i < 5; ++i) {
            this.management(ignite, Collections.singletonList("--on"));
            TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
            this.management(ignite, Collections.singletonList("--off"));
            TestUtils.assertWithPoll(() -> log.contains(CONNECTION_DISCONNECTED_MSG));
        }
        Assertions.assertThat((boolean)wsThreadsOnStart.equals(this.agentWsThreads())).isTrue();
        ignite.close();
    }
}

