/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.test;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cluster.ClusterProcessor;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.gridgain.control.agent.ControlCenterAgentProvider;

public class TestGridKernalContext
extends StandaloneGridKernalContext {
    private static IgniteLogger log = new NullLogger();
    private final ClusterProcessor clusterProc;
    private final GridIoManager io;
    private final GridInternalSubscriptionProcessor internalSubscriptionProcessor = new GridInternalSubscriptionProcessor((GridKernalContext)this);

    public TestGridKernalContext() throws IgniteCheckedException {
        super(log, null, null);
        this.clusterProc = new ClusterProcessor((GridKernalContext)this);
        this.io = new TestGridIoManager((GridKernalContext)this);
    }

    public GridInternalSubscriptionProcessor internalSubscriptionProcessor() {
        return this.internalSubscriptionProcessor;
    }

    public ClusterProcessor cluster() {
        return this.clusterProc;
    }

    public GridIoManager io() {
        return this.io != null ? this.io : super.io();
    }

    public PluginProvider pluginProvider(String name) throws PluginNotFoundException {
        if ("ControlCenterAgent".equals(name)) {
            return new ControlCenterAgentProvider();
        }
        return null;
    }

    private static class TestGridIoManager
    extends GridIoManager {
        private Map<GridTopic, GridMessageListener> lsnrMap = new EnumMap<GridTopic, GridMessageListener>(GridTopic.class);

        public TestGridIoManager(GridKernalContext ctx) {
            super(ctx);
        }

        public void addMessageListener(GridTopic topic, GridMessageListener lsnr) {
            this.lsnrMap.put(topic, lsnr);
        }

        public void sendToGridTopic(UUID nodeId, GridTopic topic, Message msg, byte plc) throws IgniteCheckedException {
            GridMessageListener lsnr = this.lsnrMap.get(topic);
            if (lsnr != null) {
                lsnr.onMessage(nodeId, (Object)msg, plc);
            }
        }
    }
}

