/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;

public class MetricTreeFixture {
    private static final String NAME_PREF = "metric.name.";
    private static final String GRP_PREF = "grp.";

    public static Map<String, MetricRegistry> defaultTestData() {
        HashMap<String, MetricRegistry> registries = new HashMap<String, MetricRegistry>();
        HashMap<String, AtomicLongMetric> metrics1 = new HashMap<String, AtomicLongMetric>();
        metrics1.put("aaa.aaa.aaa", new AtomicLongMetric("aaa.aaa.aaa", null));
        metrics1.put("aaa.bbb.aaa", new AtomicLongMetric("aaa.bbb.aaa", null));
        metrics1.put("aaa.aaa.bbb", new AtomicLongMetric("aaa.aaa.bbb", null));
        metrics1.put("zzz.aaa.kkk", new AtomicLongMetric("zzz.aaa.kkk", null));
        metrics1.put("zzz.aaa.bbb", new AtomicLongMetric("zzz.aaa.bbb", null));
        MetricRegistry registry1 = new MetricRegistry("test1", "test1", null, null, (IgniteLogger)new NullLogger(), metrics1);
        HashMap<String, AtomicLongMetric> metrics2 = new HashMap<String, AtomicLongMetric>();
        metrics2.put("kkk.kkk.kkk", new AtomicLongMetric("kkk.kkk.kkk", null));
        metrics2.put("aaa.bbb.aaa", new AtomicLongMetric("aaa.bbb.aaa", null));
        metrics2.put("aaa.aaa.bbb", new AtomicLongMetric("aaa.aaa.bbb", null));
        metrics2.put("aaa.bbb.lll", new AtomicLongMetric("aaa.bbb.lll", null));
        MetricRegistry registry2 = new MetricRegistry("test2", "test2", null, null, (IgniteLogger)new NullLogger(), metrics2);
        registries.put(registry1.name(), registry1);
        registries.put(registry2.name(), registry2);
        return registries;
    }

    public static List<MetricRegistry> generateMetrics() {
        ArrayList<MetricRegistry> metrics = new ArrayList<MetricRegistry>();
        for (int i = 0; i < 4; ++i) {
            metrics.add(MetricTreeFixture.generateMetricRegistry(i));
        }
        return metrics;
    }

    public static MetricRegistry generateMetricRegistry(int idx) {
        String grpName = GRP_PREF + idx;
        MetricRegistry reg = new MetricRegistry(grpName, grpName, name -> null, name -> null, (IgniteLogger)new NullLogger());
        int j = 0;
        while (j < 14) {
            reg.booleanMetric("metric.name.bool." + j++, "description");
            reg.intMetric("metric.name.int." + j++, "description");
            reg.longMetric("metric.name.long." + j++, "description");
            reg.doubleMetric("metric.name.double." + j++, "description");
            reg.hitRateMetric("metric.name.hitrate." + j++, "description", 60000L, 10);
            reg.longAdderMetric("metric.name.longadder." + j++, "description");
            reg.histogram("metric.name.histogram." + j++, new long[]{60000L}, "description");
        }
        return reg;
    }

    public static Collection<String> presentTemplate() {
        return Collections.singletonList("aaa.aaa.aaa");
    }

    public static Collection<String> absentTemplate() {
        return Collections.singletonList("test.test.absent");
    }

    public static Collection<String> allTemplateByEmptyCollection() {
        return Collections.emptyList();
    }

    public static Map<String, ReadOnlyMetricRegistry> defaultReadOnlyRegistryTestData() {
        return MetricTreeFixture.defaultTestData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

