/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.test;

import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.gridgain.control.agent.dto.action.deployment.ArtifactRequest;
import org.gridgain.control.agent.processor.deployment.ArtifactType;

public class DeploymentUnitTestUtils {
    public static final String TEST_MAVEN_DEPENDENCY_ID = "org.apache.ignite:ignite-extdata-p2p:2.9.0";
    public static final String TEST_MAVEN_DEPENDENCY_LOCAL_PART_URL = ".m2/repository/org/apache/ignite/ignite-extdata-p2p/2.9.0/ignite-extdata-p2p-2.9.0.jar";
    public static final String TEST_EXTERNAL_DEPENDENCY_URL = "https://repo1.maven.org/maven2/org/apache/ignite/ignite-extdata-p2p/2.10.0/ignite-extdata-p2p-2.10.0.jar";
    public static final String TEST_UPLOADED_ARTIFACT_COORDINATE = "/api/v1/resources/download/ignite-extdata-p2p-2.10.0.jar";
    public static final String TEST_DEPLOYMENT_UNIT_NAME = "Test deployment";

    public static ArtifactRequest mavenTestArtifact() {
        return new ArtifactRequest().setType(ArtifactType.MAVEN_ARTIFACT).setCoordinate(TEST_MAVEN_DEPENDENCY_ID);
    }

    public static ArtifactRequest externalTestArtifact() {
        return new ArtifactRequest().setType(ArtifactType.EXTERNAL_LINK).setCoordinate(TEST_EXTERNAL_DEPENDENCY_URL);
    }

    public static ArtifactRequest uploadedTestArtifact() {
        return new ArtifactRequest().setType(ArtifactType.UPLOADED_ARTIFACT).setCoordinate(TEST_UPLOADED_ARTIFACT_COORDINATE);
    }

    public static ArtifactRequest customTestArtifact(ArtifactType type, String coordinate) {
        return new ArtifactRequest().setType(type).setCoordinate(coordinate);
    }

    public static RepositorySystem testRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

