/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export.task;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatus;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatusSnapshot;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.assertj.core.api.AssertionsForClassTypes;
import org.gridgain.control.agent.configuration.DistributedTaskExporterConfiguration;
import org.gridgain.control.agent.dto.compute.TaskInfo;
import org.gridgain.control.agent.processor.export.task.TaskInfoMapper;
import org.jetbrains.annotations.Nullable;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TaskInfoMapperTest {
    private static final String TEST_TASK_NAME = "test_task_name";
    private static final String TEST_PRIORITY_ATTRIBUTE = "grid.task.priority";
    private TaskInfoMapper taskInfoMapper;

    @Before
    public void init() {
        DistributedTaskExporterConfiguration taskExportCfg = (DistributedTaskExporterConfiguration)Mockito.mock(DistributedTaskExporterConfiguration.class);
        Mockito.when((Object)taskExportCfg.maxAttributeSize()).thenReturn((Object)255);
        Mockito.when((Object)taskExportCfg.taskBatchSize()).thenReturn((Object)100);
        GridKernalContext ctx = (GridKernalContext)Mockito.mock(GridKernalContext.class);
        Mockito.when((Object)ctx.config()).thenReturn((Object)new IgniteConfiguration());
        this.taskInfoMapper = new TaskInfoMapper(ctx, taskExportCfg);
    }

    @Test
    public void shouldNotReturnTaskPriority() {
        int testPri = 99;
        ComputeTaskStatusSnapshot snapshot = this.computeTaskStatusSnapshot(U.map((Object)TEST_PRIORITY_ATTRIBUTE, (Object)99));
        TaskInfo taskInfo = this.taskInfoMapper.toTask(0L, snapshot);
        AssertionsForClassTypes.assertThat((Integer)taskInfo.getPriority()).isNull();
    }

    private ComputeTaskStatusSnapshot computeTaskStatusSnapshot(@Nullable Map<Object, Object> attrs) {
        return ComputeTaskStatus.snapshot((GridTaskSessionImpl)new GridTaskSessionImpl(UUID.randomUUID(), TEST_TASK_NAME, null, TEST_TASK_NAME, IgniteUuid.randomUuid(), null, null, 12345L, 123456L, Collections.emptyList(), attrs, (GridKernalContext)Mockito.mock(GridKernalContext.class), true, false, UUID.randomUUID(), null, null));
    }
}

