/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export.metric;

import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.logger.java.JavaLogger;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.gridgain.control.agent.configuration.DistributedMetricExporterConfiguration;
import org.gridgain.control.agent.dto.metric.MetricRequest;
import org.gridgain.control.agent.dto.metric.MetricResponse;
import org.gridgain.control.agent.processor.MetricRegistryProcessor;
import org.gridgain.control.agent.processor.export.metric.LocalMetricExportTask;
import org.gridgain.control.agent.processor.export.metric.MetricMapper;
import org.gridgain.control.agent.structures.TiersMetricTree;
import org.gridgain.control.agent.test.MetricTreeFixture;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LocalMetricExportTaskTest {
    private static final UUID CLUSTER_ID = UUID.randomUUID();
    private static final UUID CLUSTER_NODE_ID = UUID.randomUUID();
    private static final String CLUSTER_TAG = "test_tag";
    private static final byte PLC = 0;
    private final Clock clock = (Clock)Mockito.mock(Clock.class);
    private final GridIoManager io = (GridIoManager)Mockito.mock(GridIoManager.class);
    private final DistributedMetricExporterConfiguration cfg = (DistributedMetricExporterConfiguration)Mockito.mock(DistributedMetricExporterConfiguration.class);
    private final MetricRegistryProcessor metricRegistryProcessor = (MetricRegistryProcessor)Mockito.mock(MetricRegistryProcessor.class);
    private final Map<String, ReadOnlyMetricRegistry> registry = MetricTreeFixture.defaultReadOnlyRegistryTestData();

    @Before
    public void setUp() {
        TiersMetricTree tree = new TiersMetricTree(this.registry);
        Mockito.when((Object)this.clock.millis()).thenAnswer(ans -> System.currentTimeMillis());
        Mockito.when((Object)this.metricRegistryProcessor.loadMetricsByTemplate((Collection)ArgumentMatchers.any())).thenAnswer(ans -> F.isEmpty((Collection)((Collection)ans.getArgument(0))) ? tree.findAll() : tree.findAllBy((Collection)ans.getArgument(0)));
        Mockito.when((Object)this.cfg.getMetricCacheTTL()).thenReturn((Object)0);
    }

    @After
    public void tearDown() {
        Mockito.reset((Object[])new Object[]{this.clock, this.io, this.cfg, this.metricRegistryProcessor});
        this.registry.clear();
    }

    @Test
    public void shouldSendScheamOnFirstRequest() throws IgniteCheckedException {
        Mockito.when((Object)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated()).thenReturn((Object)true);
        MetricRequest req = new MetricRequest(Long.valueOf(this.clock.millis()), MetricTreeFixture.absentTemplate());
        this.task(req).run();
        ArgumentCaptor msgs = ArgumentCaptor.forClass(MetricResponse.class);
        ((GridIoManager)Mockito.verify((Object)this.io, (VerificationMode)Mockito.times((int)1))).sendToGridTopic((UUID)ArgumentMatchers.eq((Object)CLUSTER_NODE_ID), (GridTopic)ArgumentMatchers.eq((Object)GridTopic.TOPIC_METRICS), (Message)msgs.capture(), ArgumentMatchers.eq((byte)0));
        MetricResponse resp = (MetricResponse)msgs.getValue();
        Assertions.assertEquals((int)resp.dataSize(), (int)0);
    }

    @Test
    public void shouldSendOnlyMetrics() throws Exception {
        MetricRequest req = new MetricRequest(Long.valueOf(this.clock.millis()), MetricTreeFixture.allTemplateByEmptyCollection());
        this.task(req).run();
        ArgumentCaptor msgs = ArgumentCaptor.forClass(MetricResponse.class);
        ((GridIoManager)Mockito.verify((Object)this.io, (VerificationMode)Mockito.times((int)1))).sendToGridTopic((UUID)ArgumentMatchers.eq((Object)CLUSTER_NODE_ID), (GridTopic)ArgumentMatchers.eq((Object)GridTopic.TOPIC_METRICS), (Message)msgs.capture(), ArgumentMatchers.eq((byte)0));
        MetricResponse resp = (MetricResponse)msgs.getValue();
        Assertions.assertNotEquals((int)resp.dataSize(), (int)0);
    }

    @Test
    public void shouldSendSchemaAndMetricsOnFirstRequest() throws Exception {
        Mockito.when((Object)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated()).thenReturn((Object)true);
        MetricRequest req = new MetricRequest(Long.valueOf(this.clock.millis()), MetricTreeFixture.presentTemplate());
        this.task(req).run();
        ArgumentCaptor msgs = ArgumentCaptor.forClass(MetricResponse.class);
        ((GridIoManager)Mockito.verify((Object)this.io, (VerificationMode)Mockito.times((int)2))).sendToGridTopic((UUID)ArgumentMatchers.eq((Object)CLUSTER_NODE_ID), (GridTopic)ArgumentMatchers.eq((Object)GridTopic.TOPIC_METRICS), (Message)msgs.capture(), ArgumentMatchers.eq((byte)0));
        List responses = msgs.getAllValues();
        Assertions.assertEquals((int)LocalMetricExportTaskTest.schemaOnly(responses).size(), (int)1);
        Assertions.assertEquals((int)LocalMetricExportTaskTest.dataOnly(responses).size(), (int)1);
    }

    @Test
    public void shouldNotSendAnythink() throws Exception {
        MetricRequest req = new MetricRequest(Long.valueOf(this.clock.millis()), MetricTreeFixture.absentTemplate());
        Mockito.when((Object)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated()).thenReturn((Object)false);
        this.task(req).run();
        ((GridIoManager)Mockito.verify((Object)this.io, (VerificationMode)Mockito.never())).sendToGridTopic((UUID)ArgumentMatchers.eq((Object)CLUSTER_NODE_ID), (GridTopic)ArgumentMatchers.eq((Object)GridTopic.TOPIC_METRICS), (Message)ArgumentMatchers.any(), ArgumentMatchers.eq((byte)0));
    }

    @Test
    public void shouldSendScheamMessageWhenGetNewMetric() throws Exception {
        MetricRequest req = new MetricRequest(Long.valueOf(this.clock.millis()), MetricTreeFixture.absentTemplate());
        Mockito.when((Object)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated()).thenReturn((Object)true);
        this.task(req).run();
        ArgumentCaptor msgs = ArgumentCaptor.forClass(MetricResponse.class);
        ((GridIoManager)Mockito.verify((Object)this.io, (VerificationMode)Mockito.times((int)1))).sendToGridTopic((UUID)ArgumentMatchers.eq((Object)CLUSTER_NODE_ID), (GridTopic)ArgumentMatchers.eq((Object)GridTopic.TOPIC_METRICS), (Message)msgs.capture(), ArgumentMatchers.eq((byte)0));
        MetricResponse resp = (MetricResponse)msgs.getValue();
        Assertions.assertEquals((int)resp.dataSize(), (int)0);
    }

    private LocalMetricExportTask task(MetricRequest req) {
        return new LocalMetricExportTask((IgniteLogger)new JavaLogger(), this.io, new MetricMapper(), this.metricRegistryProcessor, new LocalMetricExportTask.MetricExportTaskArgument(req, CLUSTER_ID, CLUSTER_TAG, CLUSTER_NODE_ID.toString(), CLUSTER_NODE_ID, 0, System.currentTimeMillis()));
    }

    private static Collection<MetricResponse> schemaOnly(Collection<MetricResponse> in) {
        return in.stream().filter(d -> d.dataSize() == 0).collect(Collectors.toList());
    }

    private static Collection<MetricResponse> dataOnly(Collection<MetricResponse> in) {
        return in.stream().filter(d -> d.dataSize() != 0).collect(Collectors.toList());
    }
}

