/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.apache.ignite.ssl.SslContextFactory;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpi;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpiSelfTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.dto.NodeConfiguration;
import org.gridgain.control.agent.processor.AbstractServiceTest;
import org.gridgain.control.agent.processor.export.NodesConfigurationExporter;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.services.kms.KmsClient;

public class NodesConfigurationExporterTest
extends AbstractServiceTest {
    private final GridKernalContext ctx = this.getMockContext(new IgniteConfiguration().setConnectorConfiguration(new ConnectorConfiguration().setSecretKey("test")).setSslContextFactory(NodesConfigurationExporterTest.getTestSslContextFactory()).setEncryptionSpi(this.keystoreEncSpi()));

    @Test
    public void shouldSendToTopic() throws JsonProcessingException {
        NodesConfigurationExporter exporter = new NodesConfigurationExporter(this.ctx);
        exporter.start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(NodeConfiguration.class);
        ((ControlCenterAgent)Mockito.verify((Object)AgentUtils.ggccAgent((GridKernalContext)this.ctx), (VerificationMode)Mockito.timeout((long)100L).times(1))).sendToAgentCoordinator((String)ArgumentMatchers.eq((Object)"control-center-agent-topic"), (Message)captor.capture());
        NodeConfiguration nodeConfiguration = (NodeConfiguration)captor.getValue();
        Assert.assertEquals((Object)this.ctx.grid().cluster().localNode().consistentId().toString(), (Object)nodeConfiguration.getConsistentId());
        JsonNode node = AgentObjectMapperFactory.jsonMapper().readTree(nodeConfiguration.getJson());
        Assert.assertFalse((boolean)node.get("connectorConfiguration").has("secretKey"));
        Assert.assertEquals((Object)"path", (Object)node.get("sslContextFactory").get("keyStoreFilePath").asText());
        Assert.assertFalse((boolean)node.get("sslContextFactory").has("keyStorePassword"));
        Assert.assertEquals((Object)"path", (Object)node.get("sslContextFactory").get("trustStoreFilePath").asText());
        Assert.assertFalse((boolean)node.get("encryptionSpi").has("spiContext"));
        Assert.assertFalse((boolean)node.get("sslContextFactory").has("trustStorePassword"));
        Assert.assertFalse((boolean)node.get("encryptionSpi").has("keyStorePwd"));
        Assert.assertFalse((boolean)node.get("encryptionSpi").has("spiContext"));
    }

    @Test
    public void shouldSendToTopicWithAwsKmsTde() throws JsonProcessingException {
        AwsKmsEncryptionSpi encryptionSpi = AwsKmsEncryptionSpiSelfTest.spi((KmsClient)Mockito.mock(KmsClient.class));
        GridKernalContext ctx = this.getMockContext(new IgniteConfiguration().setConnectorConfiguration(new ConnectorConfiguration().setSecretKey("test")).setSslContextFactory(NodesConfigurationExporterTest.getTestSslContextFactory()).setEncryptionSpi((EncryptionSpi)encryptionSpi));
        NodesConfigurationExporter exporter = new NodesConfigurationExporter(ctx);
        exporter.start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(NodeConfiguration.class);
        ((ControlCenterAgent)Mockito.verify((Object)AgentUtils.ggccAgent((GridKernalContext)ctx), (VerificationMode)Mockito.timeout((long)100L).times(1))).sendToAgentCoordinator((String)ArgumentMatchers.eq((Object)"control-center-agent-topic"), (Message)captor.capture());
        NodeConfiguration nodeConfiguration = (NodeConfiguration)captor.getValue();
        Assert.assertEquals((Object)ctx.grid().cluster().localNode().consistentId().toString(), (Object)nodeConfiguration.getConsistentId());
        JsonNode node = AgentObjectMapperFactory.jsonMapper().readTree(nodeConfiguration.getJson());
        Assert.assertFalse((boolean)node.get("connectorConfiguration").has("secretKey"));
        Assert.assertEquals((Object)"path", (Object)node.get("sslContextFactory").get("keyStoreFilePath").asText());
        Assert.assertFalse((boolean)node.get("sslContextFactory").has("keyStorePassword"));
        Assert.assertEquals((Object)"path", (Object)node.get("sslContextFactory").get("trustStoreFilePath").asText());
        Assert.assertFalse((boolean)node.get("sslContextFactory").has("trustStorePassword"));
        Assert.assertFalse((boolean)node.get("encryptionSpi").has("spiContext"));
        Assert.assertEquals((Object)encryptionSpi.getMasterKeyName(), (Object)node.get("encryptionSpi").get("masterKeyName").asText());
        Assert.assertEquals((Object)encryptionSpi.getRoleArn(), (Object)node.get("encryptionSpi").get("roleArn").asText());
        Assert.assertEquals((Object)encryptionSpi.getExternalId(), (Object)node.get("encryptionSpi").get("externalId").asText());
    }

    private static Factory<SSLContext> getTestSslContextFactory() {
        SslContextFactory factory = new SslContextFactory();
        factory.setKeyStoreFilePath("path");
        factory.setKeyStorePassword("123456".toCharArray());
        factory.setTrustStoreFilePath("path");
        factory.setTrustStorePassword("123456".toCharArray());
        return factory;
    }

    private EncryptionSpi keystoreEncSpi() {
        KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
        encSpi.setKeyStorePath("KeyStorePath");
        encSpi.setKeyStorePassword("KeyStorePassword".toCharArray());
        return encSpi;
    }
}

