/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.deployment;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.processor.deployment.ArtifactUrlValidator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import sun.net.www.protocol.ftp.FtpURLConnection;

public class ArtifactUrlValidatorTest {
    private static MockableURLStreamHandler urlStreamHnd = (MockableURLStreamHandler)Mockito.mock(MockableURLStreamHandler.class);
    private static IgniteLogger mockLog = (IgniteLogger)Mockito.mock(IgniteLogger.class);
    private ArtifactUrlValidator artifactUrlValidator = new ArtifactUrlValidator(mockLog);

    @BeforeClass
    public static void setUrlStreamHandler() {
        URLStreamHandlerFactory urlStreamHndFactory = protocol -> urlStreamHnd;
        URL.setURLStreamHandlerFactory(urlStreamHndFactory);
    }

    @Test
    public void shouldThrowExceptionIfUrlIsRelatve() {
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate("www.gridgain.com"));
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate("/some/relative/url/of/artifact.jar"));
    }

    @Test
    public void shouldBeValidatedWhenHttpResponseCode200() throws IOException {
        HttpURLConnection httpURLConn = this.mockHttpConnection();
        Mockito.when((Object)httpURLConn.getResponseCode()).thenReturn((Object)200);
        Assertions.assertThatCode(() -> this.artifactUrlValidator.validate("https://www.gridgain.com/")).doesNotThrowAnyException();
    }

    @Test
    public void shouldNotBeValidatedWhenHttpResponseCode3xx() throws Exception {
        HttpURLConnection httpURLConn = this.mockHttpConnection();
        String coordinate = "https://www.gridgain.com/";
        Mockito.when((Object)httpURLConn.getResponseCode()).thenReturn((Object)301);
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate(coordinate));
        Mockito.when((Object)httpURLConn.getResponseCode()).thenReturn((Object)302);
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate(coordinate));
    }

    @Test
    public void shouldNotBeValidatedWhenHttpResponseCode4xx() throws Exception {
        HttpURLConnection httpURLConn = this.mockHttpConnection();
        String coordinate = "https://www.gridgain.com/";
        Mockito.when((Object)httpURLConn.getResponseCode()).thenReturn((Object)401);
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate(coordinate));
        Mockito.when((Object)httpURLConn.getResponseCode()).thenReturn((Object)403);
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate(coordinate));
        Mockito.when((Object)httpURLConn.getResponseCode()).thenReturn((Object)404);
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate(coordinate));
    }

    @Test
    public void shouldFtpBeValidatedSuccessfully() throws IOException {
        FtpURLConnection ftpURLConn = this.mockFtpConnection();
        ((FtpURLConnection)Mockito.doNothing().when((Object)ftpURLConn)).connect();
        Assertions.assertThatCode(() -> this.artifactUrlValidator.validate("ftp://www.gridgain.com/")).doesNotThrowAnyException();
    }

    @Test
    public void shouldNotFtpBeValidatedWhenNotConnected() throws IOException {
        FtpURLConnection ftpURLConn = this.mockFtpConnection();
        ((FtpURLConnection)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectException("Connection refused")}).when((Object)ftpURLConn)).connect();
        Assert.assertThrows(IgniteException.class, () -> this.artifactUrlValidator.validate("ftp://www.gridgain.com/"));
    }

    private HttpURLConnection mockHttpConnection() throws IOException {
        HttpURLConnection httpURLConn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)httpURLConn.getContentType()).thenReturn((Object)"text/html");
        Mockito.when((Object)urlStreamHnd.openConnection((URL)ArgumentMatchers.any(URL.class))).thenReturn((Object)httpURLConn);
        return httpURLConn;
    }

    private FtpURLConnection mockFtpConnection() throws IOException {
        FtpURLConnection ftpURLConn = (FtpURLConnection)Mockito.mock(FtpURLConnection.class);
        Mockito.when((Object)urlStreamHnd.openConnection((URL)ArgumentMatchers.any(URL.class))).thenReturn((Object)ftpURLConn);
        return ftpURLConn;
    }

    private static abstract class MockableURLStreamHandler
    extends URLStreamHandler {
        private MockableURLStreamHandler() {
        }

        @Override
        public abstract URLConnection openConnection(URL var1) throws IOException;
    }
}

