/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.action;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.AbstractOidcMockTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.action.SessionRegistry;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.gridgain.control.agent.processor.action.DistributedActionProcessor;
import org.gridgain.control.agent.processor.action.ExecuteActionTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DistributedActionProcessorOidcMockTest
extends AbstractOidcMockTest {
    @Mock
    private ComputeTaskFuture<TaskResponse> computeTaskFut;
    private DistributedActionProcessor proc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.proc = new DistributedActionProcessor(this.ctx);
        Mockito.when((Object)this.compute.executeAsync((ComputeTask)ArgumentMatchers.any(ExecuteActionTask.class), ArgumentMatchers.any(Request.class))).thenReturn(this.computeTaskFut);
    }

    @Test
    public void shouldSendAuthenticateActionWithoutAuthentication() throws IgniteCheckedException {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setArgument((Object)new AuthenticateCredentials().setCredentials(new SecurityCredentials(null, null, (Object)U.map((Object)"tokenType", (Object)"Bearer", (Object)"accessToken", (Object)"correct_token"))));
        this.proc.onActionRequest((AbstractRequest)req);
        Assert.assertNull((Object)req.getSessionId());
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.never())).withContext((SecurityContext)ArgumentMatchers.any(SecurityContext.class));
        ((SessionRegistry)Mockito.verify((Object)this.sesRegistry, (VerificationMode)Mockito.never())).getSession((UUID)ArgumentMatchers.any());
        ((ComputeTaskFuture)Mockito.verify(this.computeTaskFut, (VerificationMode)Mockito.times((int)1))).listen((IgniteInClosure)ArgumentMatchers.any());
    }

    @Test
    public void shouldAuthenticateWithOidc() throws IgniteCheckedException {
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionWithOidc.nodeIdAction").setCredentials(new SecurityCredentials(null, null, (Object)U.map((Object)"tokenType", (Object)"Bearer", (Object)"accessToken", (Object)"correct_token")));
        this.proc.onActionRequest((AbstractRequest)req);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AuthenticationContext.class);
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.times((int)1))).authenticate((AuthenticationContext)captor.capture());
        Assert.assertEquals((Object)((AuthenticationContext)captor.getValue()).credentials(), (Object)req.getCredentials());
        Assert.assertNull((Object)req.getSessionId());
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.times((int)1))).withContext((SecurityContext)ArgumentMatchers.any(SecurityContext.class));
        ((SessionRegistry)Mockito.verify((Object)this.sesRegistry, (VerificationMode)Mockito.never())).getSession((UUID)ArgumentMatchers.any());
        ((ComputeTaskFuture)Mockito.verify(this.computeTaskFut, (VerificationMode)Mockito.times((int)1))).listen((IgniteInClosure)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotAuthenticationWithOidc() throws IgniteCheckedException {
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionWithOidc.nodeIdAction").setCredentials(new SecurityCredentials(null, null, (Object)U.map((Object)"wrong-arg", (Object)"correct_token")));
        this.proc.onActionRequest((AbstractRequest)req);
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.never())).withContext((SecurityContext)ArgumentMatchers.any(SecurityContext.class));
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.never())).authenticate((AuthenticationContext)ArgumentMatchers.any());
        ArgumentCaptor taskRes = ArgumentCaptor.forClass(TaskResponse.class);
        ArgumentCaptor jobRes = ArgumentCaptor.forClass(JobResponse.class);
        ((ControlCenterAgent)Mockito.verify((Object)this.agent, (VerificationMode)Mockito.times((int)1))).sendToControlCenter((String)ArgumentMatchers.eq((Object)StompDestinationsUtils.buildActionTaskResponseDest((UUID)CLUSTER_ID)), taskRes.capture());
        ((ControlCenterAgent)Mockito.verify((Object)this.agent, (VerificationMode)Mockito.times((int)1))).sendToControlCenter((String)ArgumentMatchers.eq((Object)StompDestinationsUtils.buildActionJobResponseDest((UUID)CLUSTER_ID)), jobRes.capture());
        Assert.assertEquals((Object)Status.FAILED, (Object)((TaskResponse)taskRes.getValue()).getStatus());
        Assert.assertEquals((Object)Status.FAILED, (Object)((JobResponse)jobRes.getValue()).getStatus());
        Assertions.assertThat((String)((JobResponse)jobRes.getValue()).getError().getMessage()).startsWith((CharSequence)"Failed to authenticate, the session with provided sessionId");
    }

    @Test
    public void shouldThrowInvalidCredentials() throws IgniteCheckedException {
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionWithOidc.nodeIdAction").setCredentials(new SecurityCredentials(null, null, (Object)U.map((Object)"tokenType", (Object)"Bearer", (Object)"accessToken", (Object)"wrong")));
        this.proc.onActionRequest((AbstractRequest)req);
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.never())).withContext((SecurityContext)ArgumentMatchers.any(SecurityContext.class));
        ((IgniteSecurity)Mockito.verify((Object)this.security, (VerificationMode)Mockito.times((int)1))).authenticate((AuthenticationContext)ArgumentMatchers.any());
        ArgumentCaptor taskRes = ArgumentCaptor.forClass(TaskResponse.class);
        ArgumentCaptor jobRes = ArgumentCaptor.forClass(JobResponse.class);
        ((ControlCenterAgent)Mockito.verify((Object)this.agent, (VerificationMode)Mockito.times((int)1))).sendToControlCenter((String)ArgumentMatchers.eq((Object)StompDestinationsUtils.buildActionTaskResponseDest((UUID)CLUSTER_ID)), taskRes.capture());
        ((ControlCenterAgent)Mockito.verify((Object)this.agent, (VerificationMode)Mockito.times((int)1))).sendToControlCenter((String)ArgumentMatchers.eq((Object)StompDestinationsUtils.buildActionJobResponseDest((UUID)CLUSTER_ID)), jobRes.capture());
        Assert.assertEquals((Object)Status.FAILED, (Object)((TaskResponse)taskRes.getValue()).getStatus());
        Assert.assertEquals((Object)Status.FAILED, (Object)((JobResponse)jobRes.getValue()).getStatus());
        Assertions.assertThat((String)((JobResponse)jobRes.getValue()).getError().getMessage()).startsWith((CharSequence)"Failed to authenticate remote client (invalid credentials?)");
    }
}

