/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.configuration.AgentFeatures;
import org.gridgain.control.agent.dto.NodeConfiguration;
import org.gridgain.control.agent.dto.dr.SenderNodeRemoteConnections;
import org.gridgain.control.agent.dto.tracing.Span;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.memory.DrSenderInMemoryStore;
import org.gridgain.grid.internal.GridPluginUtils;
import org.junit.Assert;
import org.junit.Test;

public class MessagesProcessorTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldSendInitialSpans() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        ignite.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> this.inInterceptor.getPayload(StompDestinationsUtils.buildSaveSpanDest((UUID)cluster.id())) != null);
    }

    @Test
    public void shouldSendSpans() {
        IgniteEx ignite_1 = this.startGrid(0);
        this.changeAgentConfiguration(ignite_1);
        IgniteClusterEx cluster = ignite_1.cluster();
        this.attachCluster(cluster);
        ignite_1.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            List<Span> spans = this.inInterceptor.getListPayload(StompDestinationsUtils.buildSaveSpanDest((UUID)cluster.id()), Span.class);
            return spans != null && !spans.isEmpty();
        });
    }

    @Test
    public void shouldSendNodeConfiguration() {
        IgniteEx ignite = this.startGrid(0);
        this.changeAgentConfiguration(ignite);
        this.attachCluster(ignite.cluster());
        TestUtils.assertWithPoll(() -> {
            List<NodeConfiguration> cfg = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterNodeConfigurationDest((UUID)ignite.cluster().id()), NodeConfiguration.class);
            return cfg != null && cfg.size() == 1 && cfg.get(0).getConsistentId().equals(String.valueOf(ignite.localNode().consistentId()));
        });
    }

    @Test
    public void shouldSendDrSenderConfiguration() {
        DrSenderConfiguration sndCfg = new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)2).setReceiverAddresses(new String[]{"127.0.0.1"}).setStore((DrSenderStore)new DrSenderInMemoryStore())});
        IgniteConfiguration igniteCfg = this.getConfiguration(this.instanceName(0));
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)igniteCfg).setDataCenterId((byte)15).setDrSenderConfiguration(sndCfg);
        IgniteEx ignite = this.startGrid(igniteCfg);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.changeAgentConfiguration(ignite);
        this.attachCluster(ignite.cluster());
        TestUtils.assertWithPoll(() -> {
            List<SenderNodeRemoteConnections> cfg = this.inInterceptor.getListPayload(StompDestinationsUtils.buildDrSenderConnectionsDest((UUID)ignite.cluster().id()), SenderNodeRemoteConnections.class);
            return cfg != null && cfg.size() == 1 && cfg.get(0).getSenderHubNodeId().equals(String.valueOf(ignite.localNode().consistentId()));
        });
    }

    @Test
    public void shouldStartOnNextNodeWhenCoordinatorChanged() {
        IgniteEx ignite1 = this.startGrid(1);
        UUID clusterId = ignite1.cluster().id();
        this.changeAgentConfiguration(ignite1);
        this.attachCluster(ignite1.cluster());
        IgniteEx ignite2 = this.startGrid(2);
        this.stopGrid(1);
        this.changeAgentConfiguration(ignite2);
        IgniteEx ignite3 = this.startGrid(3);
        TestUtils.assertWithPoll(() -> {
            List<NodeConfiguration> cfg = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterNodeConfigurationDest((UUID)clusterId), NodeConfiguration.class);
            return cfg != null && cfg.size() == 1 && cfg.get(0).getConsistentId().equals(String.valueOf(ignite3.localNode().consistentId()));
        });
    }

    @Test
    public void shouldUseMessagingToSendToCoordinator() throws Exception {
        try (IgniteEx ignite = this.startGrid(0, AgentFeatures.CUSTOM_TOPIC);){
            this.changeAgentConfiguration(ignite);
            this.attachCluster(ignite.cluster());
            NodeConfigurationListener userMessageListener = new NodeConfigurationListener();
            ignite.message().localListen((Object)"control-center-agent-topic", (IgniteBiPredicate)userMessageListener);
            try (IgniteEx ignite1 = this.startGrid(1);){
                String consistentId = String.valueOf(ignite1.localNode().consistentId());
                TestUtils.assertWithPoll(() -> {
                    List<NodeConfiguration> cfgs = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterNodeConfigurationDest((UUID)ignite.cluster().id()), NodeConfiguration.class);
                    Optional<NodeConfiguration> cfg = AgentUtils.fromNullableCollection(cfgs).filter(c -> consistentId.equals(c.getConsistentId())).findFirst();
                    return cfg.isPresent();
                });
                Assert.assertEquals((String)"The message to the coordinator wasn't sent using Ignite messaging", (Object)ignite1.localNode().id(), (Object)userMessageListener.nid);
            }
        }
    }

    @Test
    public void shouldNotUseMessagingToSendToCoordinator() throws Exception {
        try (IgniteEx ignite = this.startGrid(0);){
            this.changeAgentConfiguration(ignite);
            this.attachCluster(ignite.cluster());
            NodeConfigurationListener userMessageListener = new NodeConfigurationListener();
            ignite.message().localListen((Object)"control-center-agent-topic", (IgniteBiPredicate)userMessageListener);
            try (IgniteEx ignite1 = this.startGrid(1);){
                String consistentId = String.valueOf(ignite1.localNode().consistentId());
                TestUtils.assertWithPoll(() -> {
                    List<NodeConfiguration> cfgs = this.inInterceptor.getListPayload(StompDestinationsUtils.buildClusterNodeConfigurationDest((UUID)ignite.cluster().id()), NodeConfiguration.class);
                    Optional<NodeConfiguration> cfg = AgentUtils.fromNullableCollection(cfgs).filter(c -> consistentId.equals(c.getConsistentId())).findFirst();
                    return cfg.isPresent();
                });
                Assert.assertNull((String)"The message to the coordinator was sent using Ignite messaging", (Object)userMessageListener.nid);
            }
        }
    }

    private class NodeConfigurationListener
    implements IgniteBiPredicate<UUID, Object> {
        private UUID nid;

        private NodeConfigurationListener() {
        }

        public boolean apply(UUID nid, Object msg) {
            if (msg instanceof NodeConfiguration) {
                this.nid = nid;
            }
            return true;
        }
    }
}

