/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.apache.ignite.transactions.Transaction;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.tracing.Span;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ControlCenterAgentSpanMessagesProcessorTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldSendInitialSpans() {
        IgniteEx ignite = this.startGrid();
        ignite.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> this.inInterceptor.getPayload(StompDestinationsUtils.buildSaveSpanDest((UUID)cluster.id())) != null);
    }

    @Test
    public void shouldSendSpansFromTwoNodes() {
        IgniteEx ignite = this.startGrid(0);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        ignite.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        IgniteEx ignite_2 = this.startGrid(1);
        ignite_2.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        TestUtils.assertWithPoll(() -> {
            List<Span> spans = this.getAllSpans(cluster.id());
            return !spans.isEmpty() && this.hasSpansFromSpecificNode(spans, ignite.localNode().id()) && this.hasSpansFromSpecificNode(spans, ignite_2.localNode().id());
        });
    }

    @Test
    public void shouldSendSpansFromFirstNodeWithTracing_And_NoSpansFromSecondNodeWithDisabledTracing() {
        IgniteEx ignite = this.startGrid(0);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        ignite.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        IgniteEx ignite_2 = this.startGrid(this.getConfigurationWithoutTracing("node-without-tracing"));
        TestUtils.assertWithPoll(() -> {
            List<Span> spans = this.getAllSpans(cluster.id());
            return !spans.isEmpty() && this.hasSpansFromSpecificNode(spans, ignite.localNode().id()) && !this.hasSpansFromSpecificNode(spans, ignite_2.localNode().id());
        });
    }

    @Test
    public void shouldSendSpansFromSecondNodeWithTracing_And_NoSpansFromFirstNodeWithDisabledTracing() {
        IgniteEx ignite = this.startGrid(this.getConfigurationWithoutTracing("node-without-tracing"));
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        IgniteEx ignite_2 = this.startGrid(1);
        ignite_2.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.TX).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = ignite_2.getOrCreateCache(this.cacheConfiguration("DEFAULT_CACHE_NAME").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(2));
        Transaction tx = ignite_2.transactions().txStart();
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        tx.commit();
        TestUtils.assertWithPoll(() -> {
            List<Span> spans = this.getAllSpans(cluster.id());
            if (spans.isEmpty()) {
                return false;
            }
            Assert.assertFalse((boolean)this.hasSpansFromSpecificNode(spans, ignite.localNode().id()));
            Assert.assertTrue((boolean)this.hasSpansFromSpecificNode(spans, ignite_2.localNode().id()));
            return true;
        });
    }

    @Test
    public void shouldNotSendSpansWithDisabledTracingOnAllNodes() throws Exception {
        IgniteEx ignite = this.startGrid(this.getConfigurationWithoutTracing("node-without-tracing-1"));
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        IgniteEx ignite_2 = this.startGrid(this.getConfigurationWithoutTracing("node-without-tracing-2"));
        TestUtils.assertWithPoll(this.spanListIsEmpty(cluster.id()));
        IgniteEx ignite_3 = this.startGrid(2);
        ignite_3.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.TX).build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).build());
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = ignite_3.getOrCreateCache(this.cacheConfiguration("DEFAULT_CACHE_NAME").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(2));
        Transaction tx = ignite_3.transactions().txStart();
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        cache.put((Object)3, (Object)3);
        tx.commit();
        TestUtils.assertWithPoll(() -> {
            List<Span> spans = this.getAllSpans(cluster.id());
            if (spans.isEmpty()) {
                return false;
            }
            Assert.assertFalse((boolean)this.hasSpansFromSpecificNode(spans, ignite.localNode().id()));
            Assert.assertFalse((boolean)this.hasSpansFromSpecificNode(spans, ignite_2.localNode().id()));
            Assert.assertTrue((boolean)this.hasSpansFromSpecificNode(spans, ignite_3.localNode().id()));
            return true;
        });
        this.stopGrid(ignite_3.name());
        Thread.sleep(6000L);
        this.inInterceptor.clearMessages();
        TestUtils.assertWithPoll(this.spanListIsEmpty(cluster.id()));
        this.startGrid(this.getConfigurationWithoutTracing("node-without-tracing-3"));
        TestUtils.assertWithPoll(this.spanListIsEmpty(cluster.id()));
    }

    private List<Span> getAllSpans(UUID clusterId) {
        return this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveSpanDest((UUID)clusterId), Span.class).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Callable<Boolean> spanListIsEmpty(UUID clusterId) {
        return () -> this.getAllSpans(clusterId).isEmpty();
    }

    private boolean hasSpansFromSpecificNode(List<Span> spans, UUID nid) {
        return spans.stream().anyMatch(s -> ((String)s.getTags().get("node.id")).equals(nid.toString()));
    }

    private IgniteConfiguration getConfigurationWithoutTracing(String instanceName) {
        return this.getConfiguration(instanceName).setTracingSpi(null);
    }
}

