/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.dto.metric;

import java.nio.charset.StandardCharsets;
import org.gridgain.control.agent.dto.metric.MetricRegistrySchema;
import org.gridgain.control.agent.dto.metric.MetricSchema;
import org.gridgain.control.agent.dto.metric.MetricSchemaItem;
import org.gridgain.control.agent.dto.metric.MetricType;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetricSchemaTest {
    private static final String ITEM_NAME_PREF = "item.name.";
    private static final String REG_PREF = "registry.";
    private static final int CNT = 4;
    private static final String DISALLOWED = "disallowed";
    private static final int ARR_EXPANDED_DELTA = 128;
    private static final int SCHEMA_OFF = 64;

    @Test
    public void testBuild() {
        MetricSchema.Builder bldr = MetricSchema.Builder.newInstance();
        int regSchemasSize = 0;
        int namesSize = 0;
        for (int i = 0; i < 4; ++i) {
            MetricRegistrySchema.Builder regBuilder = MetricRegistrySchema.Builder.newInstance();
            for (byte j = 0; j < 4; j = (byte)(j + 1)) {
                String name = ITEM_NAME_PREF + j;
                regBuilder.add(name, MetricType.findByType((byte)j));
            }
            MetricRegistrySchema regSchema = regBuilder.build();
            String pref = REG_PREF + i;
            regSchemasSize = regSchema.length();
            namesSize += pref.getBytes(StandardCharsets.UTF_8).length;
            bldr.add("regType", pref, regSchema);
        }
        MetricSchema schema = bldr.build();
        int exp = 32 + namesSize + regSchemasSize;
        Assert.assertEquals((long)exp, (long)schema.length());
        Assert.assertEquals((long)4L, (long)schema.items().size());
    }

    @Test
    public void testAddAfterBuild() {
        MetricSchema.Builder bldr = MetricSchema.Builder.newInstance();
        for (int i = 0; i < 4; ++i) {
            MetricRegistrySchema.Builder regBldr = MetricRegistrySchema.Builder.newInstance();
            for (byte j = 0; j < 4; j = (byte)(j + 1)) {
                regBldr.add(ITEM_NAME_PREF + j, MetricType.findByType((byte)j));
            }
            MetricRegistrySchema regSchema = regBldr.build();
            bldr.add("regType", REG_PREF + i, regSchema);
        }
        bldr.build();
        TestUtils.assertThrows(() -> bldr.add("regType", DISALLOWED, MetricRegistrySchema.Builder.newInstance().build()), IllegalStateException.class);
    }

    @Test
    public void testBuildAfterBuild() {
        MetricSchema.Builder bldr = MetricSchema.Builder.newInstance();
        for (int i = 0; i < 4; ++i) {
            MetricRegistrySchema.Builder regBldr = MetricRegistrySchema.Builder.newInstance();
            for (byte j = 0; j < 4; j = (byte)(j + 1)) {
                regBldr.add(ITEM_NAME_PREF + j, MetricType.findByType((byte)j));
            }
            MetricRegistrySchema regSchema = regBldr.build();
            bldr.add("regType", REG_PREF + i, regSchema);
        }
        bldr.build();
        TestUtils.assertThrows(() -> ((MetricSchema.Builder)bldr).build(), IllegalStateException.class);
    }

    @Test
    public void testSchemaItemsImmutable() {
        MetricSchema.Builder bldr = MetricSchema.Builder.newInstance();
        for (int i = 0; i < 4; ++i) {
            MetricRegistrySchema.Builder regBldr = MetricRegistrySchema.Builder.newInstance();
            for (byte j = 0; j < 4; j = (byte)(j + 1)) {
                regBldr.add(ITEM_NAME_PREF + j, MetricType.findByType((byte)j));
            }
            MetricRegistrySchema regSchema = regBldr.build();
            bldr.add("regType", REG_PREF + i, regSchema);
        }
        MetricSchema schema = bldr.build();
        TestUtils.assertThrows(() -> schema.items().add(new MetricSchemaItem(0, DISALLOWED)), UnsupportedOperationException.class);
    }

    @Test
    public void testSchemaToBytesFromBytes() {
        MetricSchema.Builder bldr = MetricSchema.Builder.newInstance();
        for (int i = 0; i < 4; ++i) {
            MetricRegistrySchema.Builder regBldr = MetricRegistrySchema.Builder.newInstance();
            for (byte j = 0; j < 4; j = (byte)(j + 1)) {
                regBldr.add(ITEM_NAME_PREF + j, MetricType.findByType((byte)j));
            }
            MetricRegistrySchema regSchema = regBldr.build();
            bldr.add("regType", REG_PREF + i, regSchema);
        }
        MetricSchema schema = bldr.build();
        byte[] arr = schema.toBytes();
        Assert.assertEquals((long)schema.length(), (long)arr.length);
        MetricSchema schema1 = MetricSchema.fromBytes((byte[])arr);
        Assert.assertEquals((long)schema.length(), (long)schema1.length());
        Assert.assertEquals((Object)schema.items(), (Object)schema1.items());
    }

    @Test
    public void testSchemaToBytesFromBytesInPlace() {
        MetricSchema.Builder bldr = MetricSchema.Builder.newInstance();
        for (int i = 0; i < 4; ++i) {
            MetricRegistrySchema.Builder regBldr = MetricRegistrySchema.Builder.newInstance();
            for (byte j = 0; j < 4; j = (byte)(j + 1)) {
                regBldr.add(ITEM_NAME_PREF + j, MetricType.findByType((byte)j));
            }
            MetricRegistrySchema regSchema = regBldr.build();
            bldr.add("regType", REG_PREF + i, regSchema);
        }
        MetricSchema schema = bldr.build();
        byte[] arr = new byte[schema.length() + 128];
        schema.toBytes(arr, 64);
        MetricSchema schema1 = MetricSchema.fromBytes((byte[])arr, (int)64, (int)schema.length());
        Assert.assertEquals((long)schema.length(), (long)schema1.length());
        Assert.assertEquals((Object)schema.items(), (Object)schema1.items());
    }
}

