/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.dto.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.InvalidRequest;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public class RequestDeserializerTest {
    private final ObjectMapper mapper = AgentObjectMapperFactory.binaryMapper();

    @Test
    public void deserializeWithInvalidAction() throws Exception {
        Request req = new Request().setAction("InvalidAction").setArgument((Object)false).setId(UUID.randomUUID());
        AbstractRequest deserializedReq = (AbstractRequest)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)req), AbstractRequest.class);
        Assert.assertTrue((boolean)(deserializedReq instanceof InvalidRequest));
    }

    @Test
    public void deserializeWithValidAction() throws Exception {
        Request req = new Request().setAction("IgniteTestActionController.action").setArgument((Object)true).setId(UUID.randomUUID());
        Request deserializedReq = (Request)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)req), Request.class);
        Assert.assertTrue((boolean)((Boolean)deserializedReq.getArgument()));
    }

    @Test
    public void deserializeWithInvalidArgument() throws Exception {
        Request req = new Request().setAction("ActionControllerForTests.numberAction").setArgument((Object)"number").setId(UUID.randomUUID());
        AbstractRequest deserializedReq = (AbstractRequest)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)req), AbstractRequest.class);
        Assert.assertTrue((boolean)(deserializedReq instanceof InvalidRequest));
    }

    @Test
    public void deserializeWithOidcCredentials() throws Exception {
        Request req = new Request().setAction("IgniteTestActionController.action").setArgument((Object)true).setCredentials(new SecurityCredentials(null, null, (Object)U.map((Object)"tokenType", (Object)"Bearer", (Object)"accessToken", (Object)"tokValue"))).setId(UUID.randomUUID());
        Request deserializedReq = (Request)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)req), Request.class);
        Assert.assertEquals((Object)req.getCredentials(), (Object)deserializedReq.getCredentials());
    }

    @Test
    public void deserializeWithRequestId() throws Exception {
        Request req = new Request().setAction("IgniteTestActionController.actionWithRequestId0").setId(UUID.randomUUID());
        Request deserializedReq = (Request)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)req), Request.class);
        Assert.assertNull((Object)deserializedReq.getArgument());
        req = new Request().setAction("IgniteTestActionController.actionWithRequestId1").setArgument((Object)true).setId(UUID.randomUUID());
        deserializedReq = (Request)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)req), Request.class);
        Assert.assertTrue((boolean)((Boolean)deserializedReq.getArgument()));
        req = new Request().setAction("IgniteTestActionController.actionWithRequestId2").setArgument((Object)true).setId(UUID.randomUUID());
        deserializedReq = (Request)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)req), Request.class);
        Assert.assertTrue((boolean)((Boolean)deserializedReq.getArgument()));
    }
}

