/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.control.agent.utils.AgentUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;

public class TestChannelInterceptor
extends ChannelInterceptorAdapter {
    private final ObjectMapper mapper;
    private final Map<String, List<Object>> messages = new ConcurrentHashMap<String, List<Object>>();
    private final Set<String> subscribedDests = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean chFrozen = new AtomicBoolean();

    public TestChannelInterceptor(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Message<?> preSend(Message<?> msg, MessageChannel ch) {
        this.waitIfChannelFrozen();
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap(msg);
        if (accessor.getCommand() == StompCommand.SEND) {
            String dest = SimpMessageHeaderAccessor.getDestination((Map)msg.getHeaders());
            this.messages.computeIfAbsent(dest, k -> new CopyOnWriteArrayList());
            this.messages.computeIfPresent(dest, (k, v) -> {
                v.add(msg.getPayload());
                return v;
            });
        }
        if (accessor.getCommand() == StompCommand.SUBSCRIBE) {
            this.subscribedDests.add(SimpMessageHeaderAccessor.getDestination((Map)msg.getHeaders()));
        }
        return msg;
    }

    public boolean isSubscribedOn(String dest) {
        return this.subscribedDests.contains(dest);
    }

    public <T> List<T> getAllPayloads(String dest, Class<T> clazz) {
        return AgentUtils.fromNullableCollection((Collection)this.messages.get(dest)).map(p -> this.mapPayload(p, clazz)).collect(Collectors.toList());
    }

    public <T> List<List<T>> getAllListPayloads(String dest, Class<T> clazz) {
        return AgentUtils.fromNullableCollection((Collection)this.messages.get(dest)).map(p -> this.mapListPayload(p, clazz)).collect(Collectors.toList());
    }

    public <T> T getPayload(String dest, Class<T> clazz) {
        Object payload = this.getPayload(dest);
        return this.mapPayload(payload, clazz);
    }

    public <T> T getPayload(String dest, TypeReference<T> ref) {
        Object payload = this.getPayload(dest);
        return this.mapPayload(payload, ref);
    }

    public <T> List<T> getListPayload(String dest, Class<T> clazz) {
        byte[] bytes;
        Object payload = F.last((Iterable)this.messages.get(dest));
        if (payload instanceof byte[] && (bytes = (byte[])payload).length == 0) {
            return Collections.emptyList();
        }
        return this.mapListPayload(payload, clazz);
    }

    public Object getPayload(String dest) {
        return F.last((Iterable)this.messages.get(dest));
    }

    public List<Object> getAllRawPayloads(String dest) {
        return this.messages.get(dest);
    }

    private <T> T mapPayload(Object payload, Class<T> clazz) {
        if (payload == null) {
            return null;
        }
        try {
            return (T)this.mapper.readValue((byte[])payload, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T mapPayload(Object payload, TypeReference<T> ref) {
        if (payload == null) {
            return null;
        }
        try {
            return (T)this.mapper.readValue((byte[])payload, ref);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> List<T> mapListPayload(Object payload, Class<T> clazz) {
        if (payload == null) {
            return Collections.emptyList();
        }
        CollectionType type = this.mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)this.mapper.readValue((byte[])payload, (JavaType)type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public void addMixIn(Class<?> target, Class<?> mixinSrc) {
        this.mapper.addMixIn(target, mixinSrc);
    }

    public void toggleFrozenStatus(boolean freeze) {
        this.chFrozen.set(freeze);
    }

    private void waitIfChannelFrozen() {
        try {
            while (this.chFrozen.get()) {
                U.sleep((long)100L);
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteInterruptedException(e.getMessage());
        }
    }
}

