/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.gridgain.control.agent.commandline.ManagementCommandHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ManagementCommandHandlerLoggingTest {
    private static final String DEFAULT_LOGGER_NAME = "org.gridgain.control.agent.commandline.ManagementCommandHandlerLog";
    private static final String CUSTOM_LOGGER_NAME = "org.gridgain.control.agent.commandline.ManagementCommandHandler";
    private static final String ROOT_LOGGER_NAME = "";

    @Test
    public void testExternalConfigIsNotOverridden() {
        String resourceName = "management-utility-logging.properties";
        String resourcePath = this.getClass().getClassLoader().getResource(resourceName).getPath();
        System.setProperty("java.util.logging.config.file", resourcePath);
        new ManagementCommandHandler();
        ArrayList<String> loggers = Collections.list(LogManager.getLogManager().getLoggerNames());
        Assert.assertTrue((boolean)loggers.contains(CUSTOM_LOGGER_NAME));
        Logger customLogger = LogManager.getLogManager().getLogger(CUSTOM_LOGGER_NAME);
        Assert.assertEquals((long)0L, (long)customLogger.getHandlers().length);
        Logger rootLogger = LogManager.getLogManager().getLogger(ROOT_LOGGER_NAME);
        Assert.assertEquals((long)1L, (long)rootLogger.getHandlers().length);
        Assert.assertEquals(FileHandler.class, rootLogger.getHandlers()[0].getClass());
    }

    @Test
    public void testLoggingDefaultConfig() {
        new ManagementCommandHandler();
        ArrayList<String> loggers = Collections.list(LogManager.getLogManager().getLoggerNames());
        Assert.assertTrue((boolean)loggers.contains(DEFAULT_LOGGER_NAME));
        Logger logger = LogManager.getLogManager().getLogger(DEFAULT_LOGGER_NAME);
        Handler[] handlers = logger.getHandlers();
        FileHandler fileHandler = Arrays.stream(handlers).filter(h -> h instanceof FileHandler).map(h -> (FileHandler)h).findFirst().orElseThrow(() -> new AssertionError((Object)"FileHandler not found"));
        StreamHandler consoleHandler = Arrays.stream(handlers).filter(h -> h instanceof StreamHandler).map(h -> (StreamHandler)h).findFirst().orElseThrow(() -> new AssertionError((Object)"StreamHandler not found"));
    }

    @After
    public void tearDown() {
        System.clearProperty("java.util.logging.config.file");
    }
}

