/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.query.scan;

import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.action.query.scan.RegexScanQueryFilter;
import org.gridgain.control.agent.dto.query.Person;
import org.junit.Assert;
import org.junit.Test;

public class RegexScanQueryFilterTest
extends AgentCommonAbstractTest {
    IgniteCache<Object, Object> cache;

    @Override
    public void setup() throws Exception {
        super.setup();
        IgniteEx ignite = this.initGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.cache = ignite.createCache("cache");
        this.cache.put((Object)1, (Object)new Person("John", 20));
        this.cache.put((Object)2, (Object)new Person("Sam", 31));
        this.cache.put((Object)3, (Object)new Person("Jordan", 25));
        this.cache.put((Object)35, (Object)53);
        this.cache.put((Object)4, (Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!");
    }

    @Test
    public void scanQueryFilterEntries() {
        List<Cache.Entry<Object, Object>> entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.filter("1", "\"name\":\"John\"")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)1L, (long)entries.size());
        Cache.Entry<Object, Object> entry = entries.get(0);
        Assert.assertEquals((Object)1, (Object)entry.getKey());
        BinaryObject binaryVal = (BinaryObject)entry.getValue();
        Assert.assertEquals((Object)"John", (Object)((String)binaryVal.field("name")));
        Assert.assertEquals((long)20L, (long)((Integer)binaryVal.field("age")).intValue());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.keyFilter("2")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)1L, (long)entries.size());
        entry = entries.get(0);
        Assert.assertEquals((Object)2, (Object)entry.getKey());
        binaryVal = (BinaryObject)entry.getValue();
        Assert.assertEquals((Object)"Sam", (Object)((String)binaryVal.field("name")));
        Assert.assertEquals((long)31L, (long)((Integer)binaryVal.field("age")).intValue());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.valFilter("20")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)1L, (long)entries.size());
        entry = entries.get(0);
        Assert.assertEquals((Object)1, (Object)entry.getKey());
        binaryVal = (BinaryObject)entry.getValue();
        Assert.assertEquals((Object)"John", (Object)((String)binaryVal.field("name")));
        Assert.assertEquals((long)20L, (long)((Integer)binaryVal.field("age")).intValue());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.keyFilter("(1|2)")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.keyFilter("1|2|35")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)3L, (long)entries.size());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.valFilter("\"name\":\"Jo[a-zA-Z]+\"")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.valFilter("\"age\":2\\d+")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.valFilter("\"age\":2[0-5]+")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.valFilter("\"age\":2[0-4]+")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)1L, (long)entries.size());
    }

    @Test
    public void scanQueryFilterWrongArgs() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new RegexScanQueryFilter(null, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> new RegexScanQueryFilter("", "", -1L));
        Assert.assertThrows(IllegalArgumentException.class, () -> new RegexScanQueryFilter("", "", 0L));
        Assert.assertThrows(IllegalArgumentException.class, () -> new RegexScanQueryFilter("", null, -1L));
        Assert.assertThrows(IllegalArgumentException.class, () -> new RegexScanQueryFilter(null, "", -1L));
    }

    @Test
    public void filterRequiresKeyAndValueMatches() {
        List<Cache.Entry<Object, Object>> entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.filter("35", "53")));
        Assert.assertNotNull(entries);
        Assert.assertEquals((long)1L, (long)entries.size());
        Cache.Entry<Object, Object> entry = entries.get(0);
        Assert.assertEquals((Object)35, (Object)entry.getKey());
        Assert.assertEquals((Object)53, (Object)entry.getValue());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.filter("35", "35")));
        Assert.assertNotNull(entries);
        Assert.assertTrue((boolean)entries.isEmpty());
        entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.filter("53", "53")));
        Assert.assertNotNull(entries);
        Assert.assertTrue((boolean)entries.isEmpty());
    }

    @Test
    public void filterWentOutTimeLimit() {
        ScanQuery scanQry = new ScanQuery().setFilter((IgniteBiPredicate)this.valFilter("(.*a){100}"));
        RuntimeException ex = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.getAllEntries((ScanQuery<Object, Object>)scanQry));
    }

    @Test
    public void doNotCheckValueIfKeyDoesNotMatch() {
        List<Cache.Entry<Object, Object>> entries = this.getAllEntries((ScanQuery<Object, Object>)new ScanQuery().setFilter((IgniteBiPredicate)this.filter("6", "(.*a){100}")));
        Assert.assertEquals((long)0L, (long)entries.size());
    }

    protected IgniteEx initGrid() {
        return this.startGrid();
    }

    private RegexScanQueryFilter keyFilter(String keyRegex) {
        return new RegexScanQueryFilter(keyRegex, null);
    }

    private RegexScanQueryFilter valFilter(String valRegex) {
        return new RegexScanQueryFilter(null, valRegex);
    }

    private RegexScanQueryFilter filter(String keyRegex, String valRegex) {
        return new RegexScanQueryFilter(keyRegex, valRegex);
    }

    private List<Cache.Entry<Object, Object>> getAllEntries(ScanQuery<Object, Object> scanQry) {
        try (QueryCursor cursor = this.cache.withKeepBinary().query(scanQry);){
            List list = cursor.getAll();
            return list;
        }
    }
}

