/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.query;

import java.util.ArrayList;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.gridgain.control.agent.action.query.CursorHolder;
import org.gridgain.control.agent.action.query.QueryHolder;
import org.gridgain.control.agent.action.query.QueryHolderRegistry;
import org.gridgain.control.agent.processor.AbstractServiceTest;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class QueryRegistryTest
extends AbstractServiceTest {
    @Test
    public void shouldRemoveExpiredHolders() throws Exception {
        String qryId = "qry";
        QueryHolderRegistry registry = new QueryHolderRegistry(this.getMockContext(), 100L);
        registry.createQueryHolder(qryId);
        registry.addCursor(qryId, new CursorHolder((QueryCursor)new QueryCursorImpl(new ArrayList())));
        Thread.sleep(300L);
        TestUtils.assertThrows(() -> registry.findHolder(qryId), IgniteException.class, "Query results are expired [queryId=" + qryId + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotRemoveExpiredHoldersIfTheyWasFetched() throws Exception {
        QueryHolder holder;
        String qryId = "qry";
        QueryHolderRegistry registry = new QueryHolderRegistry(this.getMockContext(), 200L);
        registry.createQueryHolder(qryId);
        Thread.sleep(400L);
        Assert.assertNull((Object)registry.findHolder(qryId).cursor(null));
        String curId = registry.addCursor(qryId, new CursorHolder((QueryCursor)new QueryCursorImpl(new ArrayList())));
        QueryHolder queryHolder = holder = registry.findHolder(qryId);
        synchronized (queryHolder) {
            Thread.sleep(400L);
            holder.accessed(true);
        }
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(100L);
            registry.findHolder(qryId);
            holder.accessed(true);
        }
        Thread.sleep(600L);
        TestUtils.assertThrows(() -> registry.findHolder(qryId), IgniteException.class, "Query results are expired [queryId=" + qryId + "]");
    }
}

