/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class UploadedResourceController {
    public static final Map<UUID, List<FileContent>> RESOURCES = new HashMap<UUID, List<FileContent>>();

    @ResponseStatus(value=HttpStatus.OK)
    @PutMapping(value={"/api/v1/cluster-logs/{resId}"}, consumes={"multipart/form-data"})
    public synchronized void uploadClusterLogs(@PathVariable(value="resId") UUID resId, @RequestPart(name="files") List<MultipartFile> files) {
        List tmpFiles = files.stream().map(file -> {
            assert (file.getOriginalFilename() != null);
            String content = new String(file.getBytes(), StandardCharsets.UTF_8);
            return new FileContent(file.getOriginalFilename(), content.substring(0, content.length() - 2));
        }).collect(Collectors.toList());
        RESOURCES.merge(resId, tmpFiles, (v1, v2) -> Stream.concat(v1.stream(), v2.stream()).collect(Collectors.toList()));
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PutMapping(value={"/api/v1/debug-info/{resId}"}, consumes={"multipart/form-data"})
    public synchronized void uploadDebugInfo(@PathVariable(value="resId") UUID resId, @RequestParam(value="path") String path, @RequestPart(name="files") List<MultipartFile> files) {
        List tmpFiles = files.stream().map(file -> {
            assert (file.getOriginalFilename() != null);
            String content = new String(file.getBytes(), StandardCharsets.UTF_8);
            return new FileContent(Paths.get(path, file.getOriginalFilename()).toString(), content.substring(0, content.length() - 2));
        }).collect(Collectors.toList());
        RESOURCES.merge(resId, tmpFiles, (v1, v2) -> Stream.concat(v1.stream(), v2.stream()).collect(Collectors.toList()));
    }

    public static class FileContent {
        private final String path;
        private final String content;

        public FileContent(String path, String content) {
            this.path = path;
            this.content = content;
        }

        public String getPath() {
            return this.path;
        }

        public String getContent() {
            return this.content;
        }
    }
}

