/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.processor.CacheChangesProcessorTest;
import org.junit.Assert;
import org.junit.Test;

public class TdeActionControllerTest
extends AbstractActionControllerTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
        encSpi.setKeyStorePath(CacheChangesProcessorTest.KEYSTORE_PATH);
        encSpi.setKeyStorePassword("tde-password".toCharArray());
        return super.getConfiguration(igniteInstanceName).setEncryptionSpi((EncryptionSpi)encSpi);
    }

    @Test
    public void shouldChangeMasterKey() {
        this.assertCurrentMasterKey("ignite.master.key");
        Request req = new Request().setId(UUID.randomUUID()).setAction("TdeActions.changeMasterKey").setArgument((Object)"ignite.master.key2");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
        this.assertCurrentMasterKey("ignite.master.key2");
    }

    @Test
    public void shouldFailMasterKeyWrongFormat() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("TdeActions.changeMasterKey").setArgument(null);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
        this.assertCurrentMasterKey("ignite.master.key");
        req = new Request().setId(UUID.randomUUID()).setAction("TdeActions.changeMasterKey").setArgument((Object)"");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
        this.assertCurrentMasterKey("ignite.master.key");
    }

    @Test
    public void shouldFailMasterKeyNotFound() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("TdeActions.changeMasterKey").setArgument((Object)"ignite.master.key.absent");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
        this.assertCurrentMasterKey("ignite.master.key");
    }

    private void assertCurrentMasterKey(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.ignite(0).configuration().getEncryptionSpi().getMasterKeyName());
    }
}

