/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.PluginConfiguration;
import org.assertj.core.util.Sets;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.SnapshotArgument;
import org.gridgain.control.agent.dto.action.SnapshotOperationArgument;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.snapshot.GridGainSnapshotInfo;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.SnapshotsUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotActionsControllerTest
extends AbstractActionControllerTest {
    @Override
    protected void cleanup() {
        super.cleanup();
        this.deleteDirectory("custom-snapshot-dir");
        this.deleteDirectory("snapshot");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        return super.getConfiguration(igniteInstanceName).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
    }

    @Test
    public void shouldCreateFullSnapshot() {
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        String msg = "Test snapshot";
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.create").setArgument((Object)new SnapshotArgument().setFullSnapshot(true).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setSnapshotOperationParallelism(1).setCompressionOption(CompressionOption.NONE).setMessage(msg));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
            List infos = snapshot.listSnapshots((Collection)F.asList((Object)TestUtils.resolveSnapshotDirectory()));
            Assert.assertEquals((long)1L, (long)infos.size());
            SnapshotInfo info = (SnapshotInfo)F.first((List)infos);
            Assert.assertEquals((Object)info.cacheNames(), (Object)cacheNames);
            Assert.assertEquals((Object)info.message(), (Object)msg);
            return true;
        });
    }

    @Test
    public void shouldCreateIncrementalSnapshot() {
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, TestUtils.resolveSnapshotDirectory()).get(20L, TimeUnit.SECONDS);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.create").setArgument((Object)new SnapshotArgument().setCacheNames(Sets.set((Object[])new String[]{"test-cache"})).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setSnapshotOperationParallelism(1).setCompressionOption(CompressionOption.NONE).setMessage("Test snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
            List infos = snapshot.listSnapshots((Collection)F.asList((Object)TestUtils.resolveSnapshotDirectory()));
            Assert.assertEquals((long)2L, (long)infos.size());
            Assert.assertTrue((boolean)infos.stream().allMatch(i -> i.cacheNames().equals(cacheNames)));
            return true;
        });
    }

    @Test
    public void shouldDeleteSnapshot() {
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, null).get(20L, TimeUnit.SECONDS);
        SnapshotInfo info = (SnapshotInfo)F.first((List)snapshot.listSnapshots(Collections.emptyList()));
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.delete").setArgument((Object)new SnapshotArgument().setSnapshotId(info.snapshotId()).setDeleteSources(true).setMessage("Test delete snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            List infos = snapshot.listSnapshots(Collections.emptyList());
            Assert.assertEquals((long)0L, (long)infos.size());
            return true;
        });
    }

    @Test
    public void shouldCopySnapshot() {
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
        TestUtils.createFullSnapshot(this.cluster.ignite(), null, null).get(20L, TimeUnit.SECONDS);
        SnapshotInfo info = (SnapshotInfo)F.first((List)snapshot.listSnapshots(Collections.emptyList()));
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.copy").setArgument((Object)new SnapshotArgument().setSnapshotId(info.snapshotId()).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setMessage("Test copy snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            List infosByDfltPath = snapshot.listSnapshots(Collections.emptyList());
            List infosByCustomPath = snapshot.listSnapshots((Collection)F.asList((Object)TestUtils.resolveSnapshotDirectory()));
            Assert.assertEquals((long)1L, (long)infosByDfltPath.size());
            Assert.assertEquals((long)1L, (long)infosByCustomPath.size());
            return true;
        });
    }

    @Test
    public void shouldMoveSnapshot() {
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
        TestUtils.createFullSnapshot(this.cluster.ignite(), null, null).get(20L, TimeUnit.SECONDS);
        SnapshotInfo info = (SnapshotInfo)F.first((List)snapshot.listSnapshots(Collections.emptyList()));
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.move").setArgument((Object)new SnapshotArgument().setSnapshotId(info.snapshotId()).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setMessage("Test move snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            List infosByDfltPath = snapshot.listSnapshots(Collections.emptyList());
            List infosByCustomPath = snapshot.listSnapshots((Collection)F.asList((Object)TestUtils.resolveSnapshotDirectory()));
            Assert.assertEquals((long)0L, (long)infosByDfltPath.size());
            Assert.assertEquals((long)1L, (long)infosByCustomPath.size());
            return true;
        });
    }

    @Test
    public void shouldCheckSnapshot() throws IgniteCheckedException {
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, null);
        fut.get(20L, TimeUnit.SECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        TestUtils.corruptSnapshot(snapshotId, Collections.singleton("snapshot"), "test-cache".hashCode());
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.check").setArgument((Object)new SnapshotArgument().setSnapshotId(snapshotId).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setCacheNames(cacheNames).setMessage("Test check snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            Assert.assertNotNull((Object)r.getResult());
            Map jobRes = (Map)F.first((List)((List)r.getResult()));
            Assert.assertEquals((Object)"test-cache", jobRes.get("cacheName"));
            Assert.assertTrue((boolean)((String)jobRes.get("issue")).startsWith("Page is corrupted"));
            Assert.assertEquals((Object)1, jobRes.get("partitionId"));
            return true;
        });
    }

    @Test
    public void shouldGetListOfSnapshots() {
        this.cluster.ignite().getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, null);
        fut.get(20L, TimeUnit.SECONDS);
        this.inInterceptor.clearMessages();
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.reloadList");
        this.executeAction((AbstractRequest)req, res -> true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotInfo> snapshots = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotDest((UUID)this.cluster.id()), GridGainSnapshotInfo.class);
            if (snapshots.size() != 1) {
                return false;
            }
            GridGainSnapshotInfo snapshot = (GridGainSnapshotInfo)F.first(snapshots);
            Assert.assertTrue((boolean)snapshot.isFull());
            Assert.assertEquals(Collections.singleton("test-cache"), (Object)snapshot.getCacheNames());
            Assert.assertTrue((boolean)snapshot.getParentSnapshotIds().isEmpty());
            return true;
        });
    }

    @Test
    public void shouldRestoreSnapshot() {
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), null, null);
        fut.get(20L, TimeUnit.SECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        IgniteCache cache = this.cluster.ignite().cache("test-cache");
        cache.put((Object)1, (Object)3);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.restore").setArgument((Object)new SnapshotArgument().setSnapshotId(snapshotId).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setCacheNames(cacheNames).setForce(true).setMessage("Test restore snapshot"));
        this.executeAction(req, Duration.ofMinutes(2L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            Assert.assertNull((Object)r.getResult());
            Assert.assertEquals((Object)2, (Object)cache.get((Object)1));
            return true;
        });
    }

    @Test
    public void shouldCancelSnapshot() {
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), null, null);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.cancelSnapshotOperation").setArgument((Object)new SnapshotOperationArgument().setOperationId(fut.operationId()).setForce(true).setMessage("Test cancel snapshot"));
        this.executeAction(req, Duration.ofMinutes(2L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            Assert.assertTrue((boolean)((Boolean)r.getResult()));
            return true;
        });
    }
}

